/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.umldrawingtools;

import CH.ifa.draw.figures.AbstractLineDecoration;
import CH.ifa.draw.figures.ArrowTip;
import ch.ehi.uml1_4.foundation.core.AssociationEnd;
import ch.ehi.umleditor.application.LauncherView;
import java.awt.Color;
import java.awt.Polygon;

class AssociationLineDecoration
extends AbstractLineDecoration {
    private int mySize;

    public AssociationLineDecoration(int aggregationKind, Color lineColor) {
        this.setSize(21);
        this.setBorderColor(lineColor);
        if (aggregationKind == 2) {
            this.setFillColor(LauncherView.getSettings().getBackgroundColor());
        } else {
            this.setFillColor(lineColor);
        }
    }

    public static AbstractLineDecoration createDecoration(AssociationEnd associationEnd, Color lineColor) {
        int aggregationKind = associationEnd.getAggregation();
        if (aggregationKind == 1) {
            if (associationEnd.isNavigable()) {
                return AssociationLineDecoration.getNavigableDecoration(lineColor);
            }
        } else {
            AssociationLineDecoration decoration = new AssociationLineDecoration(aggregationKind, lineColor);
            if (associationEnd.isNavigable()) {
                // empty if block
            }
            return decoration;
        }
        return null;
    }

    private static ArrowTip getNavigableDecoration(Color lineColor) {
        ArrowTip arrowTip = new ArrowTip(0.4, 12.0, 0.0);
        arrowTip.setBorderColor(lineColor);
        return arrowTip;
    }

    public int getSize() {
        return this.mySize;
    }

    @Override
    public Polygon outline(int x1, int y1, int x2, int y2) {
        Polygon shape = new Polygon();
        double xDir = x2 - x1;
        double yDir = y2 - y1;
        double vLength = Math.sqrt(xDir * xDir + yDir * yDir);
        if (vLength == 0.0) {
            return shape;
        }
        if (xDir == 0.0) {
            xDir = 1.0;
        }
        double endX = (double)x1 + (xDir /= vLength) * (double)this.getSize();
        double endY = (double)y1 + (yDir /= vLength) * (double)this.getSize();
        double h = Math.sqrt(this.getSize());
        double v1y = 1.0;
        double v1x = -(yDir * v1y) / xDir;
        double v1Length = Math.sqrt(v1x * v1x + v1y * v1y);
        double p1y = (endY + (double)y1) / 2.0 + (v1y /= v1Length) * h;
        double p1x = (endX + (double)x1) / 2.0 + (v1x /= v1Length) * h;
        double p2y = (endY + (double)y1) / 2.0 - v1y * h;
        double p2x = (endX + (double)x1) / 2.0 - v1x * h;
        shape.addPoint(x1, y1);
        shape.addPoint((int)p1x, (int)p1y);
        shape.addPoint((int)endX, (int)endY);
        shape.addPoint((int)p2x, (int)p2y);
        shape.addPoint(x1, y1);
        return shape;
    }

    public void setSize(int newSize) {
        this.mySize = newSize;
    }
}

