/*
 * Decompiled with CFR 0.152.
 */
package ch.softenvironment.view;

import ch.softenvironment.client.ResourceManager;
import ch.softenvironment.util.StringUtils;
import ch.softenvironment.view.FileHistoryListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class FileHistoryMenu
extends JMenu {
    private FileHistoryListener listener = null;
    private int numberOfEntries = 0;
    private List history = new ArrayList();

    public FileHistoryMenu(FileHistoryListener listener, int maxNumberOfEntries, List currentEntries) {
        this.listener = listener;
        this.numberOfEntries = maxNumberOfEntries;
        this.setText(ResourceManager.getResource(FileHistoryMenu.class, "MnuFileHistory_text"));
        this.setToolTipText(ResourceManager.getResource(FileHistoryMenu.class, "MnuFileHistory_toolTipText"));
        for (int i = 0; i < currentEntries.size() && i < maxNumberOfEntries; ++i) {
            String filename = (String)currentEntries.get(i);
            if (StringUtils.isNullOrEmpty(filename)) continue;
            this.history.add(filename);
        }
        this.buildSubmenu();
    }

    public void addRecent(String filename) {
        this.removeRecent(filename);
        this.history.add(0, filename);
        if (this.history.size() > this.numberOfEntries) {
            this.history.remove(this.numberOfEntries);
        }
        this.buildSubmenu();
    }

    private void buildSubmenu() {
        this.removeAll();
        for (final String filename : this.history) {
            JMenuItem menuItem = new JMenuItem(filename);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    FileHistoryMenu.this.listener.openFile(filename);
                }
            });
            this.add(menuItem);
        }
    }

    public List getHistory() {
        return this.history;
    }

    public void removeRecent(String filename) {
        if (this.history.contains(filename)) {
            this.history.remove(filename);
        }
        this.buildSubmenu();
    }
}

