/*
 * Decompiled with CFR 0.152.
 */
package ch.softenvironment.view;

import ch.softenvironment.util.Tracer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.border.EtchedBorder;

public class SplashScreen
extends JWindow {
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private JPanel ivjJWindowContentPane = null;
    private JLabel ivjLblImage = null;

    public SplashScreen(Dimension windowSize, String image) {
        this.initialize();
        this.setSize(windowSize);
        this.setImage(image);
    }

    public SplashScreen(Dimension windowSize, ImageIcon image) {
        this.initialize();
        this.setSize(windowSize);
        this.setImage(image);
    }

    private void connEtoC1(WindowEvent arg1) {
        try {
            this.dispose();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private JPanel getJWindowContentPane() {
        if (this.ivjJWindowContentPane == null) {
            try {
                this.ivjJWindowContentPane = new JPanel();
                this.ivjJWindowContentPane.setName("JWindowContentPane");
                this.ivjJWindowContentPane.setBorder(new EtchedBorder());
                this.ivjJWindowContentPane.setLayout(new BorderLayout());
                this.getJWindowContentPane().add((Component)this.getLblImage(), "Center");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJWindowContentPane;
    }

    private JLabel getLblImage() {
        if (this.ivjLblImage == null) {
            try {
                this.ivjLblImage = new JLabel();
                this.ivjLblImage.setName("LblImage");
                this.ivjLblImage.setIcon(null);
                this.ivjLblImage.setText("");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLblImage;
    }

    private void handleException(Throwable exception) {
        Tracer.getInstance().uncaughtException(exception);
    }

    private void initConnections() throws Exception {
        this.addWindowListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("XSplashScreen");
            this.setSize(300, 220);
            this.setContentPane(this.getJWindowContentPane());
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        this.getLblImage().setText("");
    }

    public void setImage(String image) {
        ImageIcon icon = new ImageIcon(SplashScreen.class.getResource(image));
        if (icon == null) {
            Tracer.getInstance().runtimeWarning("given iconFile not found <" + image + ">!");
        } else {
            this.setImage(icon);
        }
    }

    public void setImage(ImageIcon icon) {
        if (icon == null) {
            Tracer.getInstance().runtimeWarning("given icon is null!");
        }
        this.getLblImage().setIcon(icon);
    }

    class IvjEventHandler
    implements WindowListener {
        IvjEventHandler() {
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowClosed(WindowEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            if (e.getSource() == SplashScreen.this) {
                SplashScreen.this.connEtoC1(e);
            }
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }
    }
}

