/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.framework;

import com.ibm.xmi.framework.FileWriter;
import com.ibm.xmi.framework.Namespace;
import com.ibm.xmi.framework.Object20Writer;
import com.ibm.xmi.framework.ObjectWriter;
import com.ibm.xmi.framework.PrintXML;
import com.ibm.xmi.framework.XMIFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

class File20Writer
extends FileWriter {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999-2002. All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private boolean xsiFlag = false;
    private ArrayList namespaces = new ArrayList();

    public File20Writer(XMIFile xMIFile) {
        super(xMIFile);
        Iterator iterator = xMIFile.getNamespaces().iterator();
        while (iterator.hasNext()) {
            this.namespaces.add(iterator.next());
        }
    }

    protected Namespace getNamespace(Object object) {
        return this.wrapper.getNamespace(object);
    }

    private void processData(Object object) {
        Namespace namespace = this.wrapper.getNamespace(object);
        if (namespace != null && !this.namespaces.contains(namespace)) {
            this.namespaces.add(namespace);
        }
    }

    protected void processLink(Object object) {
        this.processData(object);
    }

    protected void processObject(Object object, String string, String string2, int n) {
        this.processData(object);
        super.processObject(object, string, string2, n);
    }

    protected void processProperty(Object object) {
        this.processData(object);
    }

    protected String[] getXMIAttribs() {
        String[] stringArray = null;
        stringArray = this.xsiFlag ? new String[6 + this.namespaces.size() * 2] : new String[4 + this.namespaces.size() * 2];
        stringArray[0] = "xmi:version";
        stringArray[1] = this.file.getXMIVersion();
        stringArray[2] = "xmlns:xmi";
        stringArray[3] = "http://www.omg.org/XMI";
        int n = 3;
        if (this.xsiFlag) {
            stringArray[4] = "xmlns:xsi";
            stringArray[5] = "http://www.w3.org/2001/XMLSchema-instance";
            n = 5;
        }
        int n2 = 0;
        while (n2 < this.namespaces.size()) {
            Namespace namespace = (Namespace)this.namespaces.get(n2);
            stringArray[++n] = !namespace.getPrefix().equals("") ? "xmlns:" + namespace.getPrefix() : "xmlns";
            stringArray[++n] = namespace.getURI();
            ++n2;
        }
        return stringArray;
    }

    protected ObjectWriter makeObjectWriter(Object object) {
        Object20Writer object20Writer = new Object20Writer(object);
        object20Writer.setFileWriter(this);
        object20Writer.setWrapper(this.wrapper);
        return object20Writer;
    }

    protected void writeHeader(int n, int n2) throws Exception {
        PrintXML.printXMLPI("1.0");
        String[] stringArray = this.getXMIAttribs();
        PrintXML.printStartElement("xmi:XMI", stringArray, false, 0);
        this.writeXMIHeader(n + n2, n2);
    }

    protected void writeContent(int n, int n2) throws Exception {
        Iterator iterator = this.getTopObjects().iterator();
        while (iterator.hasNext()) {
            ObjectWriter objectWriter = this.makeObjectWriter(iterator.next());
            objectWriter.setFileWriter(this);
            objectWriter.write(n, n2);
        }
        PrintXML.printEndElement("xmi:XMI", 0);
    }

    protected void removeNulls(Collection collection, Collection collection2) {
        if (collection2.size() > 0) {
            Iterator iterator = collection2.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                int n = this.wrapper.getType(e);
                if (n == 7 || n == 6) {
                    this.xsiFlag = true;
                    continue;
                }
                collection.remove(e);
            }
        }
    }

    protected void writeXMIHeader(int n, int n2) throws Exception {
        if (this.fileHasHeader()) {
            this.writeXMIHeaderContent(n, n2);
        }
    }

    protected String getMetametamodel() {
        return "xmi:metametamodel";
    }

    protected String getMetamodel() {
        return "xmi:metamodel";
    }

    protected String getModel() {
        return "xmi:Model";
    }

    protected String getImport() {
        return "xmi:import";
    }

    protected String getVersionAttrib() {
        return "version";
    }

    protected String getNameAttrib() {
        return "name";
    }

    protected String getDocumentation() {
        return "xmi:Documentation";
    }

    protected String getExporter() {
        return "exporter";
    }

    protected String getExporterVersion() {
        return "exporterVersion";
    }

    protected String getOwner() {
        return "owner";
    }

    protected String getContact() {
        return "contact";
    }

    protected String getNotice() {
        return "notice";
    }

    protected String getShortDescription() {
        return "shortDescription";
    }

    protected String getLongDescription() {
        return "longDescription";
    }
}

