/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.framework;

import com.ibm.xmi.framework.Data;
import com.ibm.xmi.framework.DefinitionWriter;
import com.ibm.xmi.framework.Namespace;
import com.ibm.xmi.framework.PrintXML;
import com.ibm.xmi.framework.XMIObject;
import com.ibm.xmi.framework.XMISchema;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

class SchemaConstructWriter
extends DefinitionWriter {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999-2002. All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected XMISchema schema;

    public SchemaConstructWriter(Object object) {
        super(object);
    }

    protected boolean equalsNamespace(Object object) {
        Namespace namespace = this.schema.getTargetNamespace();
        Namespace namespace2 = this.wrapper.getNamespace(object);
        if (namespace == null && namespace2 == null) {
            return true;
        }
        if (namespace == null && namespace2 != null || namespace2 == null && namespace != null) {
            return false;
        }
        return namespace.getURI() != null && namespace2.getURI() != null && namespace.getURI().equals(namespace2.getURI());
    }

    protected String getDocumentation() {
        return this.getDocumentation(this.getSource());
    }

    protected String getDocumentation(XMIObject xMIObject) {
        if (xMIObject == null) {
            return null;
        }
        Iterator iterator = this.getTaggedValues(xMIObject).iterator();
        while (iterator.hasNext()) {
            String string = this.getDocumentationFromTV((XMIObject)iterator.next());
            if (string == null) continue;
            return string;
        }
        return null;
    }

    protected Collection getTaggedValues(XMIObject xMIObject) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object = xMIObject.getXMIValueOfValue("Foundation.Core.ModelElement.taggedValue");
        if (object != null) {
            if (object instanceof XMIObject) {
                arrayList.add(object);
            } else if (object instanceof Collection) {
                Iterator iterator = ((Collection)object).iterator();
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
            }
        }
        return arrayList;
    }

    protected String getDocumentationFromTV(XMIObject xMIObject) {
        String string = (String)xMIObject.getXMIValueOfValue("tag");
        if (string != null && string.equals("documentation")) {
            return (String)xMIObject.getXMIValueOfValue("value");
        }
        return null;
    }

    protected XMIObject getSource() {
        if (this.getDefinition() instanceof Data && ((Data)this.getDefinition()).getXMISource() instanceof XMIObject) {
            return (XMIObject)((Data)this.getDefinition()).getXMISource();
        }
        return null;
    }

    protected XMIObject getSource(Data data) {
        if (data.getXMISource() instanceof XMIObject) {
            return (XMIObject)data.getXMISource();
        }
        return null;
    }

    protected void printAttribute(String string, String string2, int n) throws Exception {
        String[] stringArray = new String[]{"name", string, "type", string2, "use", "optional"};
        PrintXML.printStartElement("xsd:attribute", stringArray, true, n);
    }

    protected void printAttributeRef(String string, int n) throws Exception {
        String[] stringArray = new String[]{"ref", string};
        PrintXML.printStartElement("xsd:attribute", stringArray, true, n);
    }

    protected void printEnumAttribute(String string, String string2, int n) throws Exception {
        String[] stringArray = new String[]{"name", string, "type", string2, "use", "optional"};
        PrintXML.printStartElement("xsd:attribute", stringArray, true, n);
    }

    protected void printAttributeGroupRef(String string, int n) throws Exception {
        String[] stringArray = new String[]{"ref", string};
        PrintXML.printStartElement("xsd:attributeGroup", stringArray, true, n);
    }

    protected void printComment(int n, int n2, String string) throws Exception {
        PrintXML.printStartElement("xsd:annotation", null, false, n);
        PrintXML.printStartElement("xsd:documentation", null, false, n + n2);
        PrintXML.printText(string);
        PrintXML.printEndElement("xsd:documentation", -1);
        PrintXML.printEndElement("xsd:annotation", n);
    }

    protected void printComment(int n, int n2, ArrayList arrayList) throws Exception {
        PrintXML.printStartElement("xsd:annotation", null, false, n);
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            PrintXML.printStartElement("xsd:documentation", null, false, n + n2);
            PrintXML.printText((String)iterator.next());
            PrintXML.printEndElement("xsd:documentation", -1);
        }
        PrintXML.printEndElement("xsd:annotation", n);
    }

    protected void printStartChoice(int n) throws Exception {
        String[] stringArray = new String[]{"minOccurs", "0", "maxOccurs", "unbounded"};
        PrintXML.printStartElement("xsd:choice", stringArray, false, n);
    }

    protected void printStartElement(String string, int n) throws Exception {
        String[] stringArray = new String[]{"name", this.stripNamespace(string)};
        PrintXML.printStartElement("xsd:element", stringArray, false, n);
    }

    protected void printElementRef(String string, int n) throws Exception {
        String[] stringArray = new String[]{"ref", string};
        PrintXML.printStartElement("xsd:element", stringArray, true, n);
    }

    protected void setSchema(XMISchema xMISchema) {
        this.schema = xMISchema;
    }

    protected String stripNamespace(String string) {
        int n = string.indexOf(":");
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    protected String stripIfSN(Object object) {
        if (this.equalsNamespace(object)) {
            return this.stripNamespace(this.wrapper.getXMIName(object));
        }
        return this.wrapper.getXMIName(object);
    }

    public void write(int n, int n2) throws Exception {
        super.write(n, n2);
    }
}

