/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.framework;

import com.ibm.xmi.framework.BadTypeException;
import com.ibm.xmi.framework.DataImpl;
import com.ibm.xmi.framework.Feature;
import com.ibm.xmi.framework.Value;
import com.ibm.xmi.framework.XMIObject;
import java.util.Collection;
import java.util.Iterator;

public class ValueImpl
extends DataImpl
implements Value {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999-2002. All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private boolean contained;
    private Object value;
    private int type;

    public ValueImpl() {
        this.type = 1;
    }

    public ValueImpl(String string) {
        super(string);
        this.type = 1;
    }

    public ValueImpl(Feature feature) {
        super(feature);
    }

    public int getXMIType() {
        if (this.getXMIDefiner() != null) {
            return ((Feature)this.getXMIDefiner()).getXMIValueType();
        }
        return this.type;
    }

    public void setXMIType(int n) {
        if (n != 1 && n != 2 && n != 3 && n != 4 && n != 6 && n != 7 && n != 8) {
            throw new BadTypeException(n);
        }
        this.type = n;
    }

    public Object getXMIValue() {
        return this.value;
    }

    public void setXMIValue(Object object) {
        this.value = object;
    }

    static String getTypeString(int n) {
        switch (n) {
            case 7: {
                return "DATA";
            }
            case 6: {
                return "ENUM";
            }
            case 8: {
                return "OBJ";
            }
            case 2: {
                return "REF";
            }
            case 3: {
                return "CTR";
            }
            case 4: {
                return "CNT";
            }
        }
        return "";
    }

    private String getValueString(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof String) {
            return "'" + object + "'";
        }
        if (object instanceof XMIObject) {
            return "[" + object + "]";
        }
        if (object instanceof Collection) {
            String string = "{";
            String string2 = "";
            Iterator iterator = ((Collection)object).iterator();
            while (iterator.hasNext()) {
                string = string + string2 + this.getValueString(iterator.next());
                string2 = ", ";
            }
            string = string + "}";
            return string;
        }
        return "";
    }

    public String toString() {
        String string = this.getXMIName() + " <" + ValueImpl.getTypeString(this.getXMIType()) + ">";
        string = string + " " + this.getValueString(this.getXMIValue()) + " ";
        if (this.getXMIDefiner() != null) {
            string = string + " definer: [" + this.getXMIDefiner() + "]";
        }
        if (this.getXMINamespace() != null) {
            string = string + " namespace: " + this.getXMINamespace();
        }
        return string;
    }
}

