/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import junit.framework.AssertionFailedError;

public class Assert
extends junit.framework.Assert {
    protected Assert() {
    }

    public static void assertEquals(File expected, File actual, boolean isBinary) throws FileNotFoundException, IOException {
        FilterInputStream ref = new BufferedInputStream(new FileInputStream(expected));
        if (expected.getPath().toLowerCase().endsWith(".gz")) {
            ref = new GZIPInputStream(ref);
        }
        FilterInputStream tst = new BufferedInputStream(new FileInputStream(actual));
        if (actual.getPath().toLowerCase().endsWith(".gz")) {
            tst = new GZIPInputStream(tst);
        }
        if (isBinary) {
            int diff = Assert.diff(ref, tst);
            if (diff >= 0) {
                throw new AssertionFailedError("File " + actual + ": comparison failed at offset " + diff);
            }
        } else {
            int diff = Assert.diff(new BufferedReader(new InputStreamReader(ref)), new BufferedReader(new InputStreamReader(tst)));
            if (diff >= 0) {
                throw new AssertionFailedError("File " + actual + ": comparison failed at line " + diff);
            }
        }
    }

    private static int diff(InputStream ref, InputStream tst) throws IOException {
        int bTst;
        int bRef;
        int i = 0;
        do {
            bRef = ref.read();
            bTst = tst.read();
            ++i;
        } while (bRef >= 0 && bTst >= 0 && bRef == bTst);
        ref.close();
        tst.close();
        return bRef == bTst ? -1 : i - 1;
    }

    private static int diff(BufferedReader ref, BufferedReader tst) throws IOException {
        String bTst;
        String bRef;
        int i = 1;
        do {
            bRef = ref.readLine();
            bTst = tst.readLine();
            ++i;
        } while (bRef != null && bTst != null && bRef.equals(bTst));
        ref.close();
        tst.close();
        return bRef == null && bTst == null ? -1 : i - 1;
    }
}

