/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.logging.ErrorTracker;
import ch.ehi.basics.logging.StdListener;
import ch.ehi.basics.settings.Settings;
import ch.ehi.basics.tools.StringUtility;
import ch.ehi.basics.view.GenericFileFilter;
import ch.interlis.ili2c.CheckReposIlis;
import ch.interlis.ili2c.CompilerLogEvent;
import ch.interlis.ili2c.Ili2c;
import ch.interlis.ili2c.Ili2cException;
import ch.interlis.ili2c.ModelScan;
import ch.interlis.ili2c.config.BoidEntry;
import ch.interlis.ili2c.config.Configuration;
import ch.interlis.ili2c.config.FileEntry;
import ch.interlis.ili2c.generator.ETF1Generator;
import ch.interlis.ili2c.generator.Gml32Generator;
import ch.interlis.ili2c.generator.ImdGenerator;
import ch.interlis.ili2c.generator.Interlis1Generator;
import ch.interlis.ili2c.generator.Interlis2Generator;
import ch.interlis.ili2c.generator.XSD22Generator;
import ch.interlis.ili2c.generator.XSD24Generator;
import ch.interlis.ili2c.generator.XSDGenerator;
import ch.interlis.ili2c.generator.iom.IomGenerator;
import ch.interlis.ili2c.gui.UserSettings;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.parser.Ili1Parser;
import ch.interlis.ili2c.parser.Ili22Parser;
import ch.interlis.ili2c.parser.Ili23Parser;
import ch.interlis.ili2c.parser.Ili24Parser;
import ch.interlis.ili2c.parser.MetaObjectParser;
import ch.interlis.ilirepository.IliFiles;
import ch.interlis.ilirepository.IliManager;
import ch.interlis.ilirepository.IliResolver;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;

public class Main {
    public static final String APP_JAR = "ili2c.jar";
    public static final String APP_NAME = "ili2c";
    public static final String ILI_DIR = "%ILI_DIR";
    public static final String JAR_DIR = "%JAR_DIR";
    public static final String JAR_MODELS = "standard";
    public static final String ILI_REPOSITORY = "http://models.interlis.ch/";
    public static final String DEFAULT_ILIDIRS = "%ILI_DIR;http://models.interlis.ch/;%JAR_DIR";
    private static String version = null;

    protected static boolean hasArg(String v1, String v2, String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals(v1) && !args[i].equals(v2)) continue;
            return true;
        }
        return false;
    }

    protected static void printVersion() {
        System.err.println("INTERLIS Compiler, Version " + Main.getVersion());
        System.err.println("  Distributed by the Coordination of Geographic Information");
        System.err.println("  and Geographic Information Systems Group (COSIG), CH-3084 Wabern");
        System.err.println("  Developed by Adasys AG, CH-8005 Zurich");
        System.err.println("  Maintained by Eisenhut Informatik AG, CH-3400 Burgdorf");
        System.err.println("  See http://www.interlis.ch for information about INTERLIS");
        System.err.println("  Parts of this program have been generated by ANTLR; see http://www.antlr.org");
        System.err.println("  This product includes software developed by the");
        System.err.println("  Apache Software Foundation (http://www.apache.org/).");
    }

    protected static void printDescription() {
        System.err.println("DESCRIPTION");
        System.err.println("  Parses and compiles INTERLIS Version 2.3 data model definitions.");
        System.err.println("  Other options include conversion from INTERLIS Version 1 and back");
        System.err.println("  (option -o1) and generation of an XML-Schema, released 2001 (option -oXSD).");
    }

    protected static void printUsage(String progName) {
        System.err.println("USAGE");
        System.err.println("  " + progName + " [Options] file1.ili file2.ili ...");
    }

    protected static void printExamples(String progName) {
        System.err.println("EXAMPLES");
        System.err.println();
        System.err.println("Check whether an INTERLIS definition in \"file1.ili\" is valid:");
        System.err.println("    java -jar " + progName + " file1.ili");
        System.err.println();
        System.err.println("Check whether a definition distributed over several files is valid:");
        System.err.println("    java -jar " + progName + " file1.ili file2.ili");
        System.err.println();
        System.err.println("Generate an INTERLIS-1 definition:");
        System.err.println("    java -jar " + progName + " -o1 file1.ili file2.ili");
        System.err.println();
        System.err.println("Generate an INTERLIS-2 definition:");
        System.err.println("    java -jar " + progName + " -o2 file1.ili file2.ili");
        System.err.println();
        System.err.println("Generate a definition of the predefined MODEL INTERLIS:");
        System.err.println("    java -jar " + progName + " -o2 --with-predefined");
        System.err.println();
        System.err.println("Generate an XML-Schema:");
        System.err.println("    java -jar " + progName + " -oXSD file1.ili file2.ili");
        System.err.println();
    }

    public static void main(String[] args) {
        boolean emitPredefined = false;
        boolean doAuto = true;
        boolean checkMetaObjs = false;
        boolean doCheckRepoIlis = false;
        boolean withWarnings = true;
        boolean numErrorsWhileGenerating = false;
        String notifyOnError = "compiler@interlis.ch";
        String ilidirs = DEFAULT_ILIDIRS;
        String httpProxyHost = null;
        String httpProxyPort = null;
        if (args.length == 0) {
            ch.interlis.ili2c.gui.Main.main(args);
            return;
        }
        if (Main.hasArg("-u", "--usage", args)) {
            Main.printUsage(APP_NAME);
            return;
        }
        if (Main.hasArg("-h", "--help", args) || args.length == 0) {
            Main.printVersion();
            System.err.println();
            Main.printDescription();
            System.err.println();
            Main.printUsage(APP_NAME);
            System.err.println();
            System.err.println("OPTIONS");
            System.err.println();
            System.err.println("--no-auto             don't look automatically after required models.");
            System.err.println("-o0                   Generate no output (default).");
            System.err.println("-o1                   Generate INTERLIS-1 output.");
            System.err.println("-o2                   Generate INTERLIS-2 output.");
            System.err.println("-oXSD                 Generate an XTF XML-Schema.");
            System.err.println("-oFMT                 Generate an INTERLIS-1 Format.");
            System.err.println("-oIMD                 Generate Model as IlisMeta INTERLIS-Transfer (XTF).");
            System.err.println("-oIOM                 (deprecated) Generate Model as INTERLIS-Transfer (XTF).");
            System.err.println("--check-repo-ilis uri   check all ili files in the given repository.");
            System.err.println("--out file/dir        file or folder for output (folder must exist).");
            System.err.println("--ilidirs " + ilidirs + " list of directories with ili-files.");
            System.err.println("--proxy host          proxy server to access model repositories.");
            System.err.println("--proxyPort port      proxy port to access model repositories.");
            System.err.println("--with-predefined     Include the predefined MODEL INTERLIS in");
            System.err.println("                      the output. Usually, this is omitted.");
            System.err.println("--without-warnings    Report only errors, no warnings. Usually,");
            System.err.println("                      warnings are generated as well.");
            System.err.println("--trace               Display detailed trace messages.");
            System.err.println("--quiet               Suppress info messages.");
            System.err.println("-h|--help             Display this help text.");
            System.err.println("-u|--usage            Display short information about usage.");
            System.err.println("-v|--version          Display the version of ili2c.");
            System.err.println();
            Main.printExamples(APP_NAME);
            return;
        }
        if (Main.hasArg("-v", "--version", args)) {
            Main.printVersion();
            return;
        }
        try {
            String outfile = null;
            int outputKind = 1;
            ArrayList<String> ilifilev = new ArrayList<String>();
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("--with-predefined")) {
                    emitPredefined = true;
                    continue;
                }
                if (args[i].equals("--trace")) {
                    EhiLogger.getInstance().setTraceFilter(false);
                    continue;
                }
                if (args[i].equals("--quiet")) {
                    StdListener.getInstance().skipInfo(true);
                    continue;
                }
                if (args[i].equals("--no-auto")) {
                    doAuto = false;
                    continue;
                }
                if (args[i].equals("--check-repo-ilis")) {
                    doCheckRepoIlis = true;
                    continue;
                }
                if (args[i].equals("--out")) {
                    outfile = args[++i];
                    continue;
                }
                if (args[i].equals("--proxy")) {
                    httpProxyHost = args[++i];
                    continue;
                }
                if (args[i].equals("--proxyPort")) {
                    httpProxyPort = args[++i];
                    continue;
                }
                if (args[i].equals("--ilidirs")) {
                    ilidirs = args[++i];
                    continue;
                }
                if (args[i].equals("-o0")) {
                    outputKind = 1;
                    continue;
                }
                if (args[i].equals("-o1")) {
                    outputKind = 2;
                    continue;
                }
                if (args[i].equals("-o2")) {
                    outputKind = 3;
                    continue;
                }
                if (args[i].equals("-oXSD")) {
                    outputKind = 4;
                    continue;
                }
                if (args[i].equals("-oFMT")) {
                    outputKind = 5;
                    continue;
                }
                if (args[i].equals("-oGML")) {
                    outputKind = 6;
                    continue;
                }
                if (args[i].equals("-oETF1")) {
                    outputKind = 8;
                    continue;
                }
                if (args[i].equals("-oIMD")) {
                    outputKind = 9;
                    continue;
                }
                if (args[i].equals("-oIOM")) {
                    outputKind = 7;
                    continue;
                }
                if (args[i].equals("--without-warnings")) {
                    withWarnings = false;
                    continue;
                }
                if (args[i].equals("--with-warnings")) {
                    withWarnings = true;
                    continue;
                }
                if (args[i].charAt(0) == '-') {
                    System.err.println("ili2c:Unknown option: " + args[i]);
                    continue;
                }
                String filename = args[i];
                if (doCheckRepoIlis || new File(filename).isFile()) {
                    ilifilev.add(filename);
                    continue;
                }
                EhiLogger.logError(args[i] + ": There is no such file.");
            }
            UserSettings settings = new UserSettings();
            Main.setDefaultIli2cPathMap(settings);
            settings.setHttpProxyHost(httpProxyHost);
            settings.setHttpProxyPort(httpProxyPort);
            settings.setIlidirs(ilidirs);
            Configuration config = new Configuration();
            for (String ilifile : ilifilev) {
                FileEntry file = new FileEntry(ilifile, 1);
                config.addFileEntry(file);
            }
            if (doAuto) {
                config.setAutoCompleteModelList(true);
            } else {
                config.setAutoCompleteModelList(false);
            }
            config.setGenerateWarnings(withWarnings);
            config.setOutputKind(outputKind);
            if (outputKind != 1) {
                if (outfile != null) {
                    config.setOutputFile(outfile);
                } else {
                    config.setOutputFile("-");
                }
            }
            if (doCheckRepoIlis) {
                boolean failed = new CheckReposIlis().checkRepoIlis(config, settings);
                if (failed) {
                    EhiLogger.logError("check of ili's in repositories failed");
                    System.exit(1);
                }
            } else {
                TransferDescription td = Main.runCompiler(config, settings);
                if (td == null) {
                    EhiLogger.logError("compiler failed");
                    System.exit(1);
                }
            }
        }
        catch (Exception ex) {
            EhiLogger.logError("ili2c: An internal error has occured. Please notify " + notifyOnError, ex);
            System.exit(1);
        }
    }

    public static ArrayList<String> getIliLookupPaths(ArrayList<String> ilifilev) {
        ArrayList<String> ilipathv = new ArrayList<String>();
        HashSet<String> seenDirs = new HashSet<String>();
        for (String ilifile : ilifilev) {
            String parentdir = new File(ilifile).getAbsoluteFile().getParent();
            if (seenDirs.contains(parentdir)) continue;
            seenDirs.add(parentdir);
            ilipathv.add(parentdir);
        }
        String ili2cHome = Main.getIli2cHome();
        if (ili2cHome != null) {
            ilipathv.add(ili2cHome + File.separator + JAR_MODELS);
        }
        return ilipathv;
    }

    public static String getIli2cHome() {
        int start;
        String classpath = System.getProperty("java.class.path");
        int index = classpath.toLowerCase().indexOf(APP_JAR);
        return index > (start = classpath.lastIndexOf(File.pathSeparator, index) + 1) ? classpath.substring(start, index - 1) : null;
    }

    public static TransferDescription runCompiler(Configuration config) {
        return Main.runCompiler(config, null);
    }

    public static void setDefaultIli2cPathMap(Settings settings) {
        HashMap<String, String> pathmap = new HashMap<String, String>();
        String ili2cHome = Main.getIli2cHome();
        if (ili2cHome != null) {
            pathmap.put(JAR_DIR, ili2cHome + File.separator + JAR_MODELS);
        }
        pathmap.put(ILI_DIR, null);
        settings.setTransientObject("ch.interlis.ili2c.pathMap", pathmap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TransferDescription runCompiler(Configuration config, Settings settings) {
        Object stream;
        Object e;
        ArrayList<Object> filev;
        block117: {
            block116: {
                ArrayList modeldirv;
                FileEntry e2;
                Iterator filei;
                ArrayList<String> ilifilev;
                String ilidirs;
                filev = new ArrayList<Object>();
                boolean doAutoCompleteModelList = config.isAutoCompleteModelList();
                if (doAutoCompleteModelList && settings != null && (ilidirs = settings.getValue("ch.interlis.ili2c.ilidirs")) == null) {
                    doAutoCompleteModelList = false;
                }
                if (!doAutoCompleteModelList) break block116;
                if (settings == null) {
                    Configuration files;
                    ilifilev = new ArrayList<String>();
                    filei = config.iteratorFileEntry();
                    while (filei.hasNext()) {
                        e2 = (FileEntry)filei.next();
                        if (e2.getKind() != 1) continue;
                        String fileName = e2.getFilename();
                        ilifilev.add(fileName);
                    }
                    modeldirv = Main.getIliLookupPaths(ilifilev);
                    try {
                        files = ModelScan.getConfigWithFiles(modeldirv, ilifilev);
                    }
                    catch (Ili2cException ex) {
                        EhiLogger.logError("ili-file scan failed", ex);
                        return null;
                    }
                    if (files == null) {
                        EhiLogger.logError("ili-file scan failed");
                        return null;
                    }
                    Main.logIliFiles(files);
                    filei = files.iteratorFileEntry();
                    while (filei.hasNext()) {
                        e = (FileEntry)filei.next();
                        filev.add(e);
                    }
                    break block117;
                } else {
                    ilifilev = new ArrayList();
                    filei = config.iteratorFileEntry();
                    while (filei.hasNext()) {
                        e2 = (FileEntry)filei.next();
                        if (e2.getKind() != 1) continue;
                        ilifilev.add(e2.getFilename());
                    }
                    Main.setHttpProxySystemProperties(settings);
                    HashMap pathmap = (HashMap)settings.getTransientObject("ch.interlis.ili2c.pathMap");
                    modeldirv = Main.getModelRepos(settings, ilifilev, pathmap);
                    IliManager manager = new IliManager();
                    IliResolver resolver = (IliResolver)settings.getTransientObject("ch.interlis.ili2c.customIliResolver");
                    if (resolver != null) {
                        manager.setResolver(resolver);
                    }
                    manager.setRepositories(modeldirv.toArray(new String[1]));
                    manager.setIliFiles(settings.getTransientValue("ch.interlis.ili2c.tempReposUri"), (IliFiles)settings.getTransientObject("ch.interlis.ili2c.tempReposIliFiles"));
                    try {
                        Configuration fileconfig = manager.getConfigWithFiles(ilifilev);
                        Ili2c.logIliFiles(fileconfig);
                        Iterator filei2 = fileconfig.iteratorFileEntry();
                        while (filei2.hasNext()) {
                            FileEntry fileEntry = (FileEntry)filei2.next();
                            filev.add(fileEntry);
                        }
                    }
                    catch (Ili2cException ex) {
                        EhiLogger.logError(ex);
                        return null;
                    }
                }
            }
            Iterator filei = config.iteratorFileEntry();
            while (filei.hasNext()) {
                FileEntry e3 = (FileEntry)filei.next();
                filev.add(e3);
            }
        }
        TransferDescription desc = new TransferDescription();
        boolean emitPredefined = config.isIncPredefModel();
        boolean checkMetaObjs = config.isCheckMetaObjs();
        CompilerLogEvent.enableWarnings(config.isGenerateWarnings());
        Iterator boidi = config.iteratorBoidEntry();
        while (boidi.hasNext()) {
            e = (BoidEntry)boidi.next();
            desc.addMetadataMapping(((BoidEntry)e).getMetaDataUseDef(), ((BoidEntry)e).getBoid());
        }
        double version = 0.0;
        for (FileEntry fileEntry : filev) {
            if (fileEntry.getKind() == 2) {
                if (!checkMetaObjs || MetaObjectParser.parse(desc, fileEntry.getFilename())) continue;
                return null;
            }
            String streamName = fileEntry.getFilename();
            if (version == 0.0) {
                version = ModelScan.getIliFileVersion(new File(streamName));
            }
            stream = null;
            try {
                stream = new FileInputStream(streamName);
            }
            catch (Exception ex) {
                EhiLogger.logError(ex);
                return null;
            }
            ErrorTracker tracker = null;
            try {
                tracker = new ErrorTracker();
                EhiLogger.getInstance().addListener(tracker);
                if (version == 2.2) {
                    if (!Ili22Parser.parseIliFile(desc, streamName, (InputStream)stream, checkMetaObjs, 0)) {
                        TransferDescription transferDescription = null;
                        return transferDescription;
                    }
                } else if (version == 2.4) {
                    if (!Ili24Parser.parseIliFile(desc, streamName, (InputStream)stream, checkMetaObjs, 0)) {
                        TransferDescription transferDescription = null;
                        return transferDescription;
                    }
                } else if (version == 1.0) {
                    if (!Ili1Parser.parseIliFile(desc, streamName, (InputStream)stream, 0)) {
                        TransferDescription transferDescription = null;
                        return transferDescription;
                    }
                } else if (!Ili23Parser.parseIliFile(desc, streamName, (InputStream)stream, checkMetaObjs, 0)) {
                    TransferDescription transferDescription = null;
                    return transferDescription;
                }
                if (!tracker.hasSeenErrors()) continue;
                TransferDescription transferDescription = null;
                return transferDescription;
            }
            catch (Exception ex5) {
                EhiLogger.logError(ex5);
                TransferDescription ex2 = null;
                return ex2;
            }
            finally {
                if (tracker != null) {
                    EhiLogger.getInstance().removeListener(tracker);
                    tracker = null;
                }
                try {
                    ((FileInputStream)stream).close();
                }
                catch (IOException ex) {
                    EhiLogger.logError(ex);
                }
            }
        }
        BufferedWriter bufferedWriter = null;
        try {
            switch (config.getOutputKind()) {
                case 1: {
                    return desc;
                }
                case 2: {
                    void var11_22;
                    if ("-".equals(config.getOutputFile())) {
                        BufferedWriter bufferedWriter2 = new BufferedWriter(new OutputStreamWriter(System.out));
                    } else {
                        try {
                            BufferedWriter bufferedWriter3 = new BufferedWriter(new FileWriter(config.getOutputFile()));
                        }
                        catch (IOException ex) {
                            EhiLogger.logError(ex);
                            stream = desc;
                            if (bufferedWriter == null) return stream;
                            try {
                                bufferedWriter.close();
                                return stream;
                            }
                            catch (IOException ex3) {
                                EhiLogger.logError(ex3);
                            }
                            return stream;
                        }
                    }
                    Interlis1Generator.generate((Writer)var11_22, desc);
                    return desc;
                }
                case 3: {
                    void var11_25;
                    if ("-".equals(config.getOutputFile())) {
                        BufferedWriter bufferedWriter4 = new BufferedWriter(new OutputStreamWriter(System.out));
                    } else {
                        try {
                            BufferedWriter bufferedWriter5 = new BufferedWriter(new FileWriter(config.getOutputFile()));
                        }
                        catch (IOException ex) {
                            EhiLogger.logError(ex);
                            stream = desc;
                            if (bufferedWriter == null) return stream;
                            try {
                                bufferedWriter.close();
                                return stream;
                            }
                            catch (IOException ex4) {
                                EhiLogger.logError(ex4);
                            }
                            return stream;
                        }
                    }
                    Interlis2Generator gen = new Interlis2Generator();
                    gen.generate((Writer)var11_25, desc, emitPredefined);
                    return desc;
                }
                case 4: {
                    void var11_28;
                    String ver = desc.getLastModel().getIliVersion();
                    if (!ver.equals("2.2") && !ver.equals("2.3")) {
                        XSD24Generator.generate(desc, new File(config.getOutputFile()));
                        return desc;
                    }
                    if ("-".equals(config.getOutputFile())) {
                        BufferedWriter bufferedWriter6 = new BufferedWriter(new OutputStreamWriter(System.out));
                    } else {
                        try {
                            BufferedWriter bufferedWriter7 = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(config.getOutputFile()), "UTF-8"));
                        }
                        catch (IOException ex) {
                            EhiLogger.logError(ex);
                            TransferDescription ex5 = desc;
                            if (bufferedWriter == null) return ex5;
                            try {
                                bufferedWriter.close();
                                return ex5;
                            }
                            catch (IOException ex6) {
                                EhiLogger.logError(ex6);
                            }
                            return ex5;
                        }
                    }
                    if (ver.equals("2.2")) {
                        XSD22Generator.generate((Writer)var11_28, desc);
                        return desc;
                    }
                    if (!ver.equals("2.3")) return desc;
                    XSDGenerator.generate((Writer)var11_28, desc);
                    return desc;
                }
                case 5: {
                    void var11_32;
                    TransferDescription ex;
                    if ("-".equals(config.getOutputFile())) {
                        BufferedWriter bufferedWriter8 = new BufferedWriter(new OutputStreamWriter(System.out));
                    } else {
                        try {
                            BufferedWriter bufferedWriter9 = new BufferedWriter(new FileWriter(config.getOutputFile()));
                        }
                        catch (IOException ex7) {
                            EhiLogger.logError(ex7);
                            ex = desc;
                            if (bufferedWriter == null) return ex;
                            try {
                                bufferedWriter.close();
                                return ex;
                            }
                            catch (IOException ex8) {
                                EhiLogger.logError(ex8);
                            }
                            return ex;
                        }
                    }
                    Interlis1Generator.generateFmt((Writer)var11_32, desc);
                    return desc;
                }
                case 6: {
                    Gml32Generator.generate(desc, config.getOutputFile());
                    return desc;
                }
                case 8: {
                    ETF1Generator.generate(desc, config.getOutputFile());
                    return desc;
                }
                case 9: {
                    ImdGenerator.generate(new File(config.getOutputFile()), desc, "ili2c-" + Main.getVersion());
                    return desc;
                }
                case 7: {
                    void var11_35;
                    TransferDescription ex;
                    if ("-".equals(config.getOutputFile())) {
                        BufferedWriter bufferedWriter10 = new BufferedWriter(new OutputStreamWriter(System.out));
                    } else {
                        try {
                            BufferedWriter bufferedWriter11 = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(config.getOutputFile()), "UTF-8"));
                        }
                        catch (IOException ex9) {
                            EhiLogger.logError(ex9);
                            ex = desc;
                            if (bufferedWriter == null) return ex;
                            try {
                                bufferedWriter.close();
                                return ex;
                            }
                            catch (IOException ex10) {
                                EhiLogger.logError(ex10);
                            }
                            return ex;
                        }
                    }
                    IomGenerator.generate((Writer)var11_35, desc);
                    return desc;
                }
            }
            return desc;
        }
        catch (Throwable e4) {
            EhiLogger.logError("failed to generate output", e4);
            TransferDescription transferDescription = null;
            return transferDescription;
        }
        finally {
            void var11_36;
            if (var11_36 != null) {
                try {
                    var11_36.close();
                }
                catch (IOException ex) {
                    EhiLogger.logError(ex);
                }
            }
        }
    }

    private static ArrayList getModelRepos(Settings settings, ArrayList<String> ilifilev, HashMap pathmap) {
        ArrayList<String> modeldirv = new ArrayList<String>();
        if (pathmap == null) {
            pathmap = new HashMap();
        }
        String ilidirs = settings.getValue("ch.interlis.ili2c.ilidirs");
        String[] modeldirs = ilidirs.split(";");
        HashSet<String> ilifiledirs = new HashSet<String>();
        for (int modeli = 0; modeli < modeldirs.length; ++modeli) {
            String m = modeldirs[modeli];
            if (m.equals(ILI_DIR) && pathmap.containsKey(ILI_DIR)) {
                for (int filei = 0; filei < ilifilev.size(); ++filei) {
                    String ilifile = ilifilev.get(filei);
                    if (GenericFileFilter.getFileExtension(ilifile) == null || (m = new File(ilifile).getAbsoluteFile().getParentFile().getAbsolutePath()) == null || m.length() <= 0 || ilifiledirs.contains(m)) continue;
                    ilifiledirs.add(m);
                    modeldirv.add(m);
                }
                continue;
            }
            if (m.startsWith("%")) {
                String key = m;
                if (!pathmap.containsKey(key) || (m = (String)pathmap.get(key)) == null || m.length() <= 0) continue;
                modeldirv.add(m);
                continue;
            }
            if (m == null || m.length() <= 0) continue;
            modeldirv.add(m);
        }
        return modeldirv;
    }

    public static void setHttpProxySystemProperties(Settings settings) {
        String httpProxyHost = settings.getValue("ch.interlis.ili2c.http_proxy_host");
        String httpProxyPort = settings.getValue("ch.interlis.ili2c.http_proxy_port");
        if (httpProxyHost != null) {
            EhiLogger.logState("httpProxyHost <" + httpProxyHost + ">");
            System.setProperty("http.proxyHost", httpProxyHost);
            if (httpProxyPort != null) {
                EhiLogger.logState("httpProxyPort <" + httpProxyPort + ">");
                System.setProperty("http.proxyPort", httpProxyPort);
            }
        } else {
            System.setProperty("java.net.useSystemProxies", "true");
        }
    }

    public static boolean editConfig(Configuration config) {
        ch.interlis.ili2c.gui.Main dialog = new ch.interlis.ili2c.gui.Main();
        return dialog.showDialog();
    }

    public static String getVersion() {
        if (version == null) {
            ResourceBundle resVersion = ResourceBundle.getBundle("ch.interlis.ili2c.Version");
            StringBuilder ret = new StringBuilder(20);
            ret.append(resVersion.getString("versionMajor"));
            ret.append('.');
            ret.append(resVersion.getString("versionMinor"));
            ret.append('.');
            ret.append(resVersion.getString("versionMicro"));
            ret.append('-');
            String branch = StringUtility.purge(resVersion.getString("versionBranch"));
            if (branch != null) {
                ret.append(branch);
                ret.append('-');
            }
            ret.append(resVersion.getString("versionDate"));
            version = ret.toString();
        }
        return version;
    }

    public static TransferDescription compileIliModels(ArrayList modelv, ArrayList modeldirv, String ilxFile) {
        Configuration config = null;
        try {
            config = ModelScan.getConfig(modeldirv, modelv);
        }
        catch (Ili2cException ex) {
            EhiLogger.logError("ili-file scan failed", ex);
            return null;
        }
        if (config == null) {
            return null;
        }
        config.setGenerateWarnings(false);
        Main.logIliFiles(config);
        if (ilxFile != null) {
            config.setOutputKind(7);
            config.setOutputFile(ilxFile);
        } else {
            config.setOutputKind(1);
        }
        TransferDescription ret = Main.runCompiler(config);
        return ret;
    }

    public static TransferDescription compileIliFiles(ArrayList filev, ArrayList modeldirv, String ilxFile) {
        Configuration config = null;
        try {
            config = ModelScan.getConfigWithFiles(modeldirv, filev);
        }
        catch (Ili2cException ex) {
            EhiLogger.logError("ili-file scan failed", ex);
            return null;
        }
        if (config == null) {
            return null;
        }
        Main.logIliFiles(config);
        config.setGenerateWarnings(false);
        if (ilxFile != null) {
            config.setOutputKind(7);
            config.setOutputFile(ilxFile);
        } else {
            config.setOutputKind(1);
        }
        TransferDescription ret = Main.runCompiler(config);
        return ret;
    }

    public static void logIliFiles(Configuration config) {
        Iterator filei = config.iteratorFileEntry();
        while (filei.hasNext()) {
            FileEntry file = (FileEntry)filei.next();
            EhiLogger.logState("ilifile <" + file.getFilename() + ">");
        }
    }
}

