/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ilirepository;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.tools.TopoSort;
import ch.ehi.basics.view.GenericFileFilter;
import ch.interlis.ili2c.Ili2c;
import ch.interlis.ili2c.Ili2cException;
import ch.interlis.ili2c.ModelScan;
import ch.interlis.ili2c.config.Configuration;
import ch.interlis.ili2c.config.FileEntry;
import ch.interlis.ili2c.modelscan.IliFile;
import ch.interlis.ili2c.modelscan.IliModel;
import ch.interlis.ilirepository.IliFiles;
import ch.interlis.ilirepository.IliResolver;
import ch.interlis.ilirepository.impl.RepositoryAccess;
import ch.interlis.ilirepository.impl.RepositoryAccessException;
import ch.interlis.ilirepository.impl.RepositoryCrawler;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class IliManager {
    public static final String ILISITE_XML = "ilisite.xml";
    public static final String ILIMODELS_XML = "ilimodels.xml";
    private long iliMaxTTL = 604800000L;
    private RepositoryAccess rep = new RepositoryAccess();
    private RepositoryCrawler crawler = new RepositoryCrawler();

    public void setRepositories(String[] uri) {
        this.crawler.setup(uri, this.rep);
    }

    public void setIliFiles(String uri, IliFiles iliFiles) {
        if (uri != null && iliFiles != null) {
            this.rep.setIliFiles(uri, iliFiles);
        }
    }

    public IliResolver getResolver() {
        return this.rep.getResolver();
    }

    public void setResolver(IliResolver resolver) {
        this.rep.setResolver(resolver);
    }

    public void setCache(File localdir) {
        this.rep.setCache(localdir);
    }

    public Configuration getConfigWithFiles(ArrayList<String> requiredIliFileNames) throws Ili2cException {
        if (requiredIliFileNames.isEmpty()) {
            throw new Ili2cException("no ili files given");
        }
        HashSet<IliFile> ilifiles = new HashSet<IliFile>();
        HashSet<IliFile> toVisitFiles = new HashSet<IliFile>();
        Iterator<String> reqFileIt = requiredIliFileNames.iterator();
        HashSet<String> availablemodels = new HashSet<String>();
        double version = 0.0;
        while (reqFileIt.hasNext()) {
            IliModel modelEle;
            Iterator modeli2;
            IliModel model1;
            IliModel model;
            Iterator modeli;
            String fname = reqFileIt.next();
            if (GenericFileFilter.getFileExtension(fname) != null) {
                IliModel model2;
                File file = new File(fname);
                if (!file.exists()) {
                    throw new Ili2cException(String.valueOf(fname) + ": " + "There is no such file.");
                }
                IliFile iliFile = ModelScan.scanIliFile(file);
                if (iliFile == null) {
                    throw new Ili2cException(String.valueOf(fname) + ": " + "Failed to scan ili-file.");
                }
                if (iliFile == null) continue;
                boolean skipThisFile = false;
                modeli = iliFile.iteratorModel();
                while (modeli.hasNext()) {
                    model2 = (IliModel)modeli.next();
                    if (version == 0.0) {
                        version = model2.getIliVersion();
                    } else if (version != model2.getIliVersion()) {
                        skipThisFile = true;
                        EhiLogger.logAdaption("different ili version; file ignored " + iliFile.getFilename());
                        break;
                    }
                    if (!availablemodels.contains(model2.getName())) continue;
                    skipThisFile = true;
                    EhiLogger.logAdaption("duplicate model; file ignored " + iliFile.getFilename());
                    break;
                }
                if (skipThisFile) continue;
                ilifiles.add(iliFile);
                toVisitFiles.add(iliFile);
                modeli = iliFile.iteratorModel();
                while (modeli.hasNext()) {
                    model2 = (IliModel)modeli.next();
                    availablemodels.add(model2.getName());
                }
                continue;
            }
            if (version == 0.0) {
                String firstModel = fname;
                model = null;
                IliFile ilifile = this.crawler.getIliFileMetadataDeep(firstModel, 0.0, true);
                if (ilifile != null) {
                    modeli = ilifile.iteratorModel();
                    while (modeli.hasNext()) {
                        model1 = (IliModel)modeli.next();
                        if (!model1.getName().equals(firstModel)) continue;
                        version = model1.getIliVersion();
                        model = model1;
                        ilifiles.add(ilifile);
                        toVisitFiles.add(ilifile);
                        modeli2 = ilifile.iteratorModel();
                        while (modeli2.hasNext()) {
                            modelEle = (IliModel)modeli2.next();
                            availablemodels.add(modelEle.getName());
                        }
                        break block3;
                    }
                }
                if (model != null) continue;
                throw new Ili2cException(String.valueOf(firstModel) + ": model not found");
            }
            String modelname = fname;
            if (availablemodels.contains(modelname)) continue;
            model = null;
            IliFile ilifile = this.crawler.getIliFileMetadataDeep(modelname, version, true);
            if (ilifile != null) {
                modeli = ilifile.iteratorModel();
                while (modeli.hasNext()) {
                    model1 = (IliModel)modeli.next();
                    if (!model1.getName().equals(modelname)) continue;
                    if (version != model1.getIliVersion()) {
                        throw new Ili2cException(String.valueOf(modelname) + ": unexpected version " + model1.getIliVersion() + " found");
                    }
                    model = model1;
                    ilifiles.add(ilifile);
                    toVisitFiles.add(ilifile);
                    modeli2 = ilifile.iteratorModel();
                    while (modeli2.hasNext()) {
                        modelEle = (IliModel)modeli2.next();
                        availablemodels.add(modelEle.getName());
                    }
                    break block5;
                }
            }
            if (model != null) continue;
            throw new Ili2cException(String.valueOf(modelname) + ": model not found");
        }
        return this.createConfig(toVisitFiles, version);
    }

    public Configuration getConfig(ArrayList<String> requiredModels, double iliVersion) throws Ili2cException {
        HashSet<IliFile> toVisitFiles = new HashSet<IliFile>();
        if (iliVersion == 0.0) {
            String firstModel = requiredModels.get(0);
            IliModel model = null;
            IliFile ilifile = this.crawler.getIliFileMetadataDeep(firstModel, 0.0, true);
            if (ilifile != null) {
                Iterator modeli = ilifile.iteratorModel();
                while (modeli.hasNext()) {
                    IliModel model1 = (IliModel)modeli.next();
                    if (!model1.getName().equals(firstModel)) continue;
                    iliVersion = model1.getIliVersion();
                    model = model1;
                    toVisitFiles.add(ilifile);
                    break;
                }
            }
            if (model == null) {
                throw new Ili2cException(String.valueOf(firstModel) + ": model not found");
            }
        }
        Iterator<String> it = requiredModels.iterator();
        HashSet<String> missingModels = new HashSet<String>();
        StringBuffer errmsg = new StringBuffer();
        String sep = "";
        while (it.hasNext()) {
            IliFile file;
            String model = it.next();
            if (model == null || (file = this.getFromSet(toVisitFiles, model, iliVersion)) != null) continue;
            file = this.crawler.getIliFileMetadataDeep(model, iliVersion, true);
            if (file == null) {
                if (missingModels.contains(model)) continue;
                missingModels.add(model);
                errmsg.append(sep);
                errmsg.append(model);
                sep = ", ";
                continue;
            }
            toVisitFiles.add(file);
        }
        if (!missingModels.isEmpty()) {
            errmsg.append(": model(s) not found");
            throw new Ili2cException(errmsg.toString());
        }
        return this.createConfig(toVisitFiles, iliVersion);
    }

    private Configuration createConfig(HashSet<IliFile> toVisitFiles, double iliVersion) throws Ili2cException {
        IliFile res;
        if (toVisitFiles.isEmpty()) {
            throw new IllegalStateException("toVisitFiles.isEmpty()");
        }
        HashSet<IliFile> visitedFiles = new HashSet<IliFile>();
        TopoSort reqFiles = new TopoSort();
        HashSet<String> missingModels = new HashSet<String>();
        StringBuffer errmsg = new StringBuffer();
        String sep = "";
        while (!toVisitFiles.isEmpty()) {
            IliFile ilifile = toVisitFiles.iterator().next();
            reqFiles.add(ilifile);
            Iterator modeli = ilifile.iteratorModel();
            while (modeli.hasNext()) {
                IliModel model = (IliModel)modeli.next();
                for (String dep : model.getDependencies()) {
                    if (dep.equals("INTERLIS")) continue;
                    IliFile supplier = this.getFromSet(visitedFiles, dep, iliVersion);
                    if (supplier == null) {
                        supplier = this.getFromSet(toVisitFiles, dep, iliVersion);
                    }
                    if (supplier == null) {
                        supplier = this.crawler.getIliFileMetadataDeep(dep, iliVersion, true);
                    }
                    if (supplier == null) {
                        if (missingModels.contains(dep)) continue;
                        errmsg.append(sep);
                        errmsg.append(dep);
                        sep = ", ";
                        missingModels.add(dep);
                        continue;
                    }
                    if (!visitedFiles.contains(supplier)) {
                        toVisitFiles.add(supplier);
                    }
                    if (supplier == ilifile) continue;
                    reqFiles.addcond(supplier, ilifile);
                }
            }
            toVisitFiles.remove(ilifile);
            visitedFiles.add(ilifile);
        }
        if (!missingModels.isEmpty()) {
            errmsg.append(": model(s) not found");
            throw new Ili2cException(errmsg.toString());
        }
        if (!reqFiles.sort()) {
            StringBuffer loopele = new StringBuffer();
            Iterator resi = reqFiles.getResult().iterator();
            sep = "";
            while (resi.hasNext()) {
                res = (IliFile)resi.next();
                loopele.append(sep);
                loopele.append(res.getFilename().getName());
                sep = "->";
            }
            throw new Ili2cException("loop in ili-files: " + loopele.toString());
        }
        Iterator resi = reqFiles.getResult().iterator();
        Configuration config = new Configuration();
        while (resi.hasNext()) {
            res = (IliFile)resi.next();
            File iliFile = null;
            try {
                iliFile = this.rep.getLocalFileLocation(res.getRepositoryUri(), res.getPath(), this.iliMaxTTL, res.getMd5());
                if (iliFile == null) {
                    if (res.getRepositoryUri() == null) {
                        throw new Ili2cException("failed to get ili file " + res.getPath());
                    }
                    throw new Ili2cException("failed to get ili file " + res.getRepositoryUri() + "/" + res.getPath());
                }
            }
            catch (RepositoryAccessException e) {
                if (res.getRepositoryUri() == null) {
                    throw new Ili2cException("failed to get ili file " + res.getPath(), e);
                }
                throw new Ili2cException("failed to get ili file " + res.getRepositoryUri() + "/" + res.getPath(), e);
            }
            config.addFileEntry(new FileEntry(iliFile.getPath(), 1));
        }
        return config;
    }

    private IliFile getFromSet(HashSet<IliFile> ilifiles, String modelName, double iliVersion) {
        for (IliFile ilifile : ilifiles) {
            Iterator modeli = ilifile.iteratorModel();
            while (modeli.hasNext()) {
                IliModel model = (IliModel)modeli.next();
                if (!model.getName().equals(modelName) || model.getIliVersion() != iliVersion) continue;
                return ilifile;
            }
        }
        return null;
    }

    public static void main(String[] args) {
        EhiLogger.getInstance().setTraceFilter(false);
        IliManager m = new IliManager();
        m.setRepositories(new String[]{"C:/tmp/test23", "http://models.interlis.ch"});
        ArrayList<String> requiredModels = new ArrayList<String>();
        ArrayList requiredFiles = new ArrayList();
        requiredModels.add("CatalogueObjects_V1");
        try {
            Configuration config = m.getConfig(requiredModels, 0.0);
            if (config != null) {
                Ili2c.logIliFiles(config);
            }
        }
        catch (Ili2cException e) {
            EhiLogger.logError(e);
        }
    }
}

