/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.control.basics;

public class XValues {
    private Double left;
    private Double right;

    public XValues(double left, double right) {
        this.left = left;
        this.right = right;
    }

    public double getLeft() {
        return this.left;
    }

    public double getRight() {
        return this.right;
    }

    public double getSpace() {
        return this.right - this.left;
    }

    public void addLeft(double inc) {
        this.left = this.left + inc;
    }

    public void subRight(double inc) {
        this.right = this.right - inc;
    }

    public static XValues createForEllipse(double y, double height, double width) {
        double halfHeight = height / 2.0;
        double halfWidth = width / 2.0;
        double halfEllipseWidthOnY = Math.sqrt((1.0 - Math.pow(halfHeight - y, 2.0) / Math.pow(halfHeight, 2.0)) * Math.pow(halfWidth, 2.0));
        XValues returnVal = new XValues(halfWidth - halfEllipseWidthOnY, halfWidth + halfEllipseWidthOnY);
        return returnVal;
    }

    public XValues intersect(XValues other, boolean nanPriority) {
        Double maxLeft = this.left;
        Double minRight = this.right;
        if (nanPriority) {
            if (other.left.equals(Double.NaN) || other.left > this.left) {
                maxLeft = other.left;
            }
            if (other.right.equals(Double.NaN) || other.right < this.right) {
                minRight = other.right;
            }
        } else {
            if (this.left.equals(Double.NaN) || other.left > this.left) {
                maxLeft = other.left;
            }
            if (this.right.equals(Double.NaN) || other.right < this.right) {
                minRight = other.right;
            }
        }
        return new XValues(maxLeft, minRight);
    }

    public String toString() {
        return "XValues [left=" + this.left + ", right=" + this.right + "]";
    }
}

