/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

import org.eclipse.jdt.core.compiler.CharOperation;

public final class HashtableOfIntValues
implements Cloneable {
    public static final int NO_VALUE = Integer.MIN_VALUE;
    public char[][] keyTable;
    public int[] valueTable;
    public int elementSize = 0;
    int threshold;

    public HashtableOfIntValues() {
        this(13);
    }

    public HashtableOfIntValues(int n) {
        this.threshold = n;
        int n2 = (int)((float)n * 1.75f);
        if (this.threshold == n2) {
            ++n2;
        }
        this.keyTable = new char[n2][];
        this.valueTable = new int[n2];
    }

    public Object clone() throws CloneNotSupportedException {
        HashtableOfIntValues hashtableOfIntValues = (HashtableOfIntValues)super.clone();
        hashtableOfIntValues.elementSize = this.elementSize;
        hashtableOfIntValues.threshold = this.threshold;
        int n = this.keyTable.length;
        hashtableOfIntValues.keyTable = new char[n][];
        System.arraycopy(this.keyTable, 0, hashtableOfIntValues.keyTable, 0, n);
        n = this.valueTable.length;
        hashtableOfIntValues.valueTable = new int[n];
        System.arraycopy(this.valueTable, 0, hashtableOfIntValues.valueTable, 0, n);
        return hashtableOfIntValues;
    }

    public boolean containsKey(char[] cArray) {
        char[] cArray2;
        int n = this.keyTable.length;
        int n2 = CharOperation.hashCode(cArray) % n;
        int n3 = cArray.length;
        while ((cArray2 = this.keyTable[n2]) != null) {
            if (cArray2.length == n3 && CharOperation.equals(cArray2, cArray)) {
                return true;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return false;
    }

    public int get(char[] cArray) {
        char[] cArray2;
        int n = this.keyTable.length;
        int n2 = CharOperation.hashCode(cArray) % n;
        int n3 = cArray.length;
        while ((cArray2 = this.keyTable[n2]) != null) {
            if (cArray2.length == n3 && CharOperation.equals(cArray2, cArray)) {
                return this.valueTable[n2];
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return Integer.MIN_VALUE;
    }

    public int put(char[] cArray, int n) {
        char[] cArray2;
        int n2 = this.keyTable.length;
        int n3 = CharOperation.hashCode(cArray) % n2;
        int n4 = cArray.length;
        while ((cArray2 = this.keyTable[n3]) != null) {
            if (cArray2.length == n4 && CharOperation.equals(cArray2, cArray)) {
                this.valueTable[n3] = n;
                return this.valueTable[n3];
            }
            if (++n3 != n2) continue;
            n3 = 0;
        }
        this.keyTable[n3] = cArray;
        this.valueTable[n3] = n;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return n;
    }

    public int removeKey(char[] cArray) {
        char[] cArray2;
        int n = this.keyTable.length;
        int n2 = CharOperation.hashCode(cArray) % n;
        int n3 = cArray.length;
        while ((cArray2 = this.keyTable[n2]) != null) {
            if (cArray2.length == n3 && CharOperation.equals(cArray2, cArray)) {
                int n4 = this.valueTable[n2];
                --this.elementSize;
                this.keyTable[n2] = null;
                this.valueTable[n2] = Integer.MIN_VALUE;
                this.rehash();
                return n4;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return Integer.MIN_VALUE;
    }

    private void rehash() {
        HashtableOfIntValues hashtableOfIntValues = new HashtableOfIntValues(this.elementSize * 2);
        int n = this.keyTable.length;
        while (--n >= 0) {
            char[] cArray = this.keyTable[n];
            if (cArray == null) continue;
            hashtableOfIntValues.put(cArray, this.valueTable[n]);
        }
        this.keyTable = hashtableOfIntValues.keyTable;
        this.valueTable = hashtableOfIntValues.valueTable;
        this.threshold = hashtableOfIntValues.threshold;
    }

    public int size() {
        return this.elementSize;
    }

    public String toString() {
        String string = "";
        int n = this.valueTable.length;
        for (int i = 0; i < n; ++i) {
            char[] cArray = this.keyTable[i];
            if (cArray == null) continue;
            string = string + new String(cArray) + " -> " + this.valueTable[i] + "\n";
        }
        return string;
    }
}

