/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.flow;

import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class InitializationFlowContext
extends ExceptionHandlingFlowContext {
    public int exceptionCount;
    public TypeBinding[] thrownExceptions = new TypeBinding[5];
    public ASTNode[] exceptionThrowers = new ASTNode[5];
    public FlowInfo[] exceptionThrowerFlowInfos = new FlowInfo[5];
    public FlowInfo initsBeforeContext;

    public InitializationFlowContext(FlowContext flowContext, ASTNode aSTNode, FlowInfo flowInfo, FlowContext flowContext2, BlockScope blockScope) {
        super(flowContext, aSTNode, Binding.NO_EXCEPTIONS, flowContext2, blockScope, FlowInfo.DEAD_END);
        this.initsBeforeContext = flowInfo;
    }

    public void checkInitializerExceptions(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        for (int i = 0; i < this.exceptionCount; ++i) {
            flowContext.checkExceptionHandlers(this.thrownExceptions[i], this.exceptionThrowers[i], this.exceptionThrowerFlowInfos[i], blockScope);
        }
    }

    @Override
    public FlowContext getInitializationContext() {
        return this;
    }

    @Override
    public String individualToString() {
        StringBuffer stringBuffer = new StringBuffer("Initialization flow context");
        for (int i = 0; i < this.exceptionCount; ++i) {
            stringBuffer.append('[').append(this.thrownExceptions[i].readableName());
            stringBuffer.append('-').append(this.exceptionThrowerFlowInfos[i].toString()).append(']');
        }
        return stringBuffer.toString();
    }

    @Override
    public void recordHandlingException(ReferenceBinding referenceBinding, UnconditionalFlowInfo unconditionalFlowInfo, TypeBinding typeBinding, TypeBinding typeBinding2, ASTNode aSTNode, boolean bl) {
        int n = this.thrownExceptions.length;
        if (this.exceptionCount == n) {
            this.thrownExceptions = new TypeBinding[n * 2];
            System.arraycopy(this.thrownExceptions, 0, this.thrownExceptions, 0, n);
            this.exceptionThrowers = new ASTNode[n * 2];
            System.arraycopy(this.exceptionThrowers, 0, this.exceptionThrowers, 0, n);
            this.exceptionThrowerFlowInfos = new FlowInfo[n * 2];
            System.arraycopy(this.exceptionThrowerFlowInfos, 0, this.exceptionThrowerFlowInfos, 0, n);
        }
        this.thrownExceptions[this.exceptionCount] = typeBinding;
        this.exceptionThrowers[this.exceptionCount] = aSTNode;
        this.exceptionThrowerFlowInfos[this.exceptionCount++] = unconditionalFlowInfo.copy();
    }
}

