/*
 * Decompiled with CFR 0.152.
 */
package gnu.mail.handler;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;

public abstract class Application
implements DataContentHandler {
    protected DataFlavor flavor;

    protected Application(String mimeType, String description) {
        this.flavor = new ActivationDataFlavor(byte[].class, mimeType, description);
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] flavors = new DataFlavor[]{this.flavor};
        return flavors;
    }

    public Object getTransferData(DataFlavor flavor, DataSource source) throws UnsupportedFlavorException, IOException {
        if (this.flavor.equals(flavor)) {
            return this.getContent(source);
        }
        return null;
    }

    public Object getContent(DataSource source) throws IOException {
        int len;
        InputStream in = source.getInputStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        while ((len = in.read(buf)) > -1) {
            out.write(buf, 0, len);
        }
        return out.toByteArray();
    }

    public void writeTo(Object object, String mimeType, OutputStream out) throws IOException {
        if (object instanceof byte[]) {
            byte[] bytes = (byte[])object;
            out.write(bytes);
            out.flush();
        } else if (object instanceof InputStream) {
            InputStream in = (InputStream)object;
            byte[] bytes = new byte[4096];
            int len = in.read(bytes);
            while (len != -1) {
                out.write(bytes, 0, len);
                len = in.read(bytes);
            }
            out.flush();
        } else {
            throw new IOException("Unsupported data type: " + object.getClass().getName());
        }
    }
}

