/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Shape;
import javax.accessibility.Accessible;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeCellRenderer;
import sun.tools.jconsole.inspector.XTree;

public class Utilities {
    private static final String windowsLaF = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";

    public static void updateTransparency(JComponent comp) {
        LookAndFeel laf = UIManager.getLookAndFeel();
        boolean transparent = laf.getClass().getName().equals(windowsLaF);
        Utilities.setTabbedPaneTransparency(comp, transparent);
    }

    private static void setTabbedPaneTransparency(JComponent comp, boolean transparent) {
        for (Component child : comp.getComponents()) {
            if (comp instanceof JTabbedPane) {
                Utilities.setTransparency((JComponent)child, transparent);
                continue;
            }
            if (!(child instanceof JComponent)) continue;
            Utilities.setTabbedPaneTransparency((JComponent)child, transparent);
        }
    }

    private static void setTransparency(JComponent comp, boolean transparent) {
        comp.setOpaque(!transparent);
        for (Component child : comp.getComponents()) {
            if (child instanceof JPanel || child instanceof JSplitPane || child instanceof JScrollPane || child instanceof JViewport || child instanceof JCheckBox) {
                Utilities.setTransparency((JComponent)child, transparent);
            }
            if (!(child instanceof XTree)) continue;
            XTree t = (XTree)child;
            DefaultTreeCellRenderer cr = (DefaultTreeCellRenderer)t.getCellRenderer();
            cr.setBackground(null);
            cr.setBackgroundNonSelectionColor(new Color(0, 0, 0, 1));
            t.setCellRenderer(cr);
            Utilities.setTransparency((JComponent)child, transparent);
        }
    }

    public static JScrollPane newTableScrollPane(JComponent comp) {
        return new TableScrollPane(comp);
    }

    public static void setAccessibleName(Accessible comp, String name) {
        comp.getAccessibleContext().setAccessibleName(name);
    }

    public static void setAccessibleDescription(Accessible comp, String description) {
        comp.getAccessibleContext().setAccessibleDescription(description);
    }

    public static Color ensureContrast(Color c1, Color c2) {
        double y2;
        double y1 = Utilities.getColorBrightness(c1);
        if (Math.abs(y1 - (y2 = Utilities.getColorBrightness(c2))) < 125.0) {
            c1 = y2 < 128.0 ? Utilities.setColorBrightness(c1, y2 + 125.0) : Utilities.setColorBrightness(c1, y2 - 125.0);
        }
        return c1;
    }

    public static double getColorBrightness(Color c) {
        return (double)c.getRed() * 0.299 + (double)c.getGreen() * 0.587 + (double)c.getBlue() * 0.114;
    }

    private static Color setColorBrightness(Color c, double y) {
        double i = (double)c.getRed() * 0.596 - (double)c.getGreen() * 0.275 - (double)c.getBlue() * 0.321;
        double q = (double)c.getRed() * 0.212 - (double)c.getGreen() * 0.523 + (double)c.getBlue() * 0.311;
        int r = Math.max(0, Math.min(255, (int)Math.round(y + i * 0.956 + q * 0.621)));
        int g = Math.max(0, Math.min(255, (int)Math.round(y - i * 0.272 - q * 0.647)));
        int b = Math.max(0, Math.min(255, (int)Math.round(y - i * 1.105 + q * 1.702)));
        return new Color(r, g, b);
    }

    private static class TableScrollPane
    extends JScrollPane {
        public TableScrollPane(JComponent comp) {
            super(comp);
        }

        @Override
        protected void paintBorder(Graphics g) {
            Insets insets;
            Border border = this.getBorder();
            if (border != null && (insets = border.getBorderInsets(this)) != null) {
                Shape oldClip = g.getClip();
                g.clipRect(0, 0, this.getWidth(), insets.top);
                super.paintBorder(g);
                g.setClip(oldClip);
            }
        }
    }
}

