/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Color;
import java.awt.GradientPaintContext;
import java.awt.LinearGradientPaintContext;
import java.awt.MultipleGradientPaint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.beans.ConstructorProperties;

public final class LinearGradientPaint
extends MultipleGradientPaint {
    private final Point2D start;
    private final Point2D end;

    public LinearGradientPaint(float startX, float startY, float endX, float endY, float[] fractions, Color[] colors) {
        this(new Point2D.Float(startX, startY), new Point2D.Float(endX, endY), fractions, colors, MultipleGradientPaint.CycleMethod.NO_CYCLE);
    }

    public LinearGradientPaint(float startX, float startY, float endX, float endY, float[] fractions, Color[] colors, MultipleGradientPaint.CycleMethod cycleMethod) {
        this(new Point2D.Float(startX, startY), new Point2D.Float(endX, endY), fractions, colors, cycleMethod);
    }

    public LinearGradientPaint(Point2D start, Point2D end, float[] fractions, Color[] colors) {
        this(start, end, fractions, colors, MultipleGradientPaint.CycleMethod.NO_CYCLE);
    }

    public LinearGradientPaint(Point2D start, Point2D end, float[] fractions, Color[] colors, MultipleGradientPaint.CycleMethod cycleMethod) {
        this(start, end, fractions, colors, cycleMethod, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform());
    }

    @ConstructorProperties(value={"startPoint", "endPoint", "fractions", "colors", "cycleMethod", "colorSpace", "transform"})
    public LinearGradientPaint(Point2D start, Point2D end, float[] fractions, Color[] colors, MultipleGradientPaint.CycleMethod cycleMethod, MultipleGradientPaint.ColorSpaceType colorSpace, AffineTransform gradientTransform) {
        super(fractions, colors, cycleMethod, colorSpace, gradientTransform);
        if (start == null || end == null) {
            throw new NullPointerException("Start and end points must benon-null");
        }
        if (start.equals(end)) {
            throw new IllegalArgumentException("Start point cannot equalendpoint");
        }
        this.start = new Point2D.Double(start.getX(), start.getY());
        this.end = new Point2D.Double(end.getX(), end.getY());
    }

    @Override
    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform transform, RenderingHints hints) {
        transform = new AffineTransform(transform);
        transform.concatenate(this.gradientTransform);
        if (this.fractions.length == 2 && this.cycleMethod != MultipleGradientPaint.CycleMethod.REPEAT && this.colorSpace == MultipleGradientPaint.ColorSpaceType.SRGB) {
            boolean cyclic = this.cycleMethod != MultipleGradientPaint.CycleMethod.NO_CYCLE;
            return new GradientPaintContext(cm, this.start, this.end, transform, this.colors[0], this.colors[1], cyclic);
        }
        return new LinearGradientPaintContext(this, cm, deviceBounds, userBounds, transform, hints, this.start, this.end, this.fractions, this.colors, this.cycleMethod, this.colorSpace);
    }

    public Point2D getStartPoint() {
        return new Point2D.Double(this.start.getX(), this.start.getY());
    }

    public Point2D getEndPoint() {
        return new Point2D.Double(this.end.getX(), this.end.getY());
    }
}

