/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaForm;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.SimpleMethodHandle;
import java.lang.invoke.WrongMethodTypeException;
import java.lang.reflect.Array;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import sun.invoke.empty.Empty;
import sun.invoke.util.ValueConversions;
import sun.invoke.util.VerifyType;
import sun.invoke.util.Wrapper;
import sun.misc.Unsafe;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;

abstract class MethodHandleImpl {
    static MethodHandle SELECT_ALTERNATIVE;
    static MethodHandle THROW_EXCEPTION;
    static MethodHandle FAKE_METHOD_HANDLE_INVOKE;

    MethodHandleImpl() {
    }

    static void initStatics() {
        MemberName.Factory.INSTANCE.getClass();
    }

    static MethodHandle makeArrayElementAccessor(Class<?> arrayClass, boolean isSetter) {
        if (!arrayClass.isArray()) {
            throw MethodHandleStatics.newIllegalArgumentException("not an array: " + arrayClass);
        }
        MethodHandle accessor = ArrayAccessor.getAccessor(arrayClass, isSetter);
        MethodType srcType = accessor.type().erase();
        MethodType lambdaType = srcType.invokerType();
        LambdaForm.Name[] names = LambdaForm.arguments(1, lambdaType);
        LambdaForm.Name[] args = Arrays.copyOfRange(names, 1, 1 + srcType.parameterCount());
        names[names.length - 1] = new LambdaForm.Name(accessor.asType(srcType), (Object[])args);
        LambdaForm form = new LambdaForm("getElement", lambdaType.parameterCount(), names);
        MethodHandle mh = SimpleMethodHandle.make(srcType, form);
        if (ArrayAccessor.needCast(arrayClass)) {
            mh = mh.bindTo(arrayClass);
        }
        mh = mh.asType(ArrayAccessor.correctType(arrayClass, isSetter));
        return mh;
    }

    static MethodHandle makePairwiseConvert(MethodHandle target, MethodType srcType, int level) {
        assert (level >= 0 && level <= 2);
        MethodType dstType = target.type();
        assert (dstType.parameterCount() == target.type().parameterCount());
        if (srcType == dstType) {
            return target;
        }
        int INARG_COUNT = srcType.parameterCount();
        int conversions = 0;
        boolean[] needConv = new boolean[1 + INARG_COUNT];
        for (int i = 0; i <= INARG_COUNT; ++i) {
            Class<?> dst;
            Class<?> src = i == INARG_COUNT ? dstType.returnType() : srcType.parameterType(i);
            Class<?> clazz = dst = i == INARG_COUNT ? srcType.returnType() : dstType.parameterType(i);
            if (VerifyType.isNullConversion(src, dst) && (level > 1 || !dst.isInterface() || dst.isAssignableFrom(src))) continue;
            needConv[i] = true;
            ++conversions;
        }
        boolean retConv = needConv[INARG_COUNT];
        boolean IN_MH = false;
        boolean INARG_BASE = true;
        int INARG_LIMIT = 1 + INARG_COUNT;
        int NAME_LIMIT = INARG_LIMIT + conversions + 1;
        int RETURN_CONV = !retConv ? -1 : NAME_LIMIT - 1;
        int OUT_CALL = (!retConv ? NAME_LIMIT : RETURN_CONV) - 1;
        MethodType lambdaType = srcType.basicType().invokerType();
        LambdaForm.Name[] names = LambdaForm.arguments(NAME_LIMIT - INARG_LIMIT, lambdaType);
        boolean OUTARG_BASE = false;
        Object[] outArgs = new Object[0 + INARG_COUNT];
        int nameCursor = INARG_LIMIT;
        for (int i = 0; i < INARG_COUNT; ++i) {
            Wrapper w;
            Class<?> src = srcType.parameterType(i);
            Class<?> dst = dstType.parameterType(i);
            if (!needConv[i]) {
                outArgs[0 + i] = names[1 + i];
                continue;
            }
            MethodHandle fn = null;
            if (src.isPrimitive()) {
                if (dst.isPrimitive()) {
                    fn = ValueConversions.convertPrimitive(src, dst);
                } else {
                    w = Wrapper.forPrimitiveType(src);
                    MethodHandle boxMethod = ValueConversions.box(w);
                    fn = dst == w.wrapperType() ? boxMethod : boxMethod.asType(MethodType.methodType(dst, src));
                }
            } else if (dst.isPrimitive()) {
                w = Wrapper.forPrimitiveType(dst);
                if (level == 0 || VerifyType.isNullConversion(src, w.wrapperType())) {
                    fn = ValueConversions.unbox(dst);
                } else if (src == Object.class || !Wrapper.isWrapperType(src)) {
                    MethodHandle unboxMethod;
                    fn = unboxMethod = level == 1 ? ValueConversions.unbox(dst) : ValueConversions.unboxCast(dst);
                } else {
                    Class<?> srcPrim = Wrapper.forWrapperType(src).primitiveType();
                    MethodHandle unbox = ValueConversions.unbox(srcPrim);
                    fn = unbox.asType(MethodType.methodType(dst, src));
                }
            } else {
                fn = ValueConversions.cast(dst);
            }
            LambdaForm.Name conv = new LambdaForm.Name(fn, names[1 + i]);
            assert (names[nameCursor] == null);
            names[nameCursor++] = conv;
            assert (outArgs[0 + i] == null);
            outArgs[0 + i] = conv;
        }
        assert (nameCursor == OUT_CALL);
        names[OUT_CALL] = new LambdaForm.Name(target, outArgs);
        if (RETURN_CONV < 0) {
            assert (OUT_CALL == names.length - 1);
        } else {
            MethodHandle fn;
            Class<?> needReturn = srcType.returnType();
            Class<?> haveReturn = dstType.returnType();
            Object[] arg = new Object[]{names[OUT_CALL]};
            if (haveReturn == Void.TYPE) {
                Object zero = Wrapper.forBasicType(needReturn).zero();
                fn = MethodHandles.constant(needReturn, zero);
                arg = new Object[]{};
            } else {
                MethodHandle identity = MethodHandles.identity(needReturn);
                MethodType needConversion = identity.type().changeParameterType(0, haveReturn);
                fn = MethodHandleImpl.makePairwiseConvert(identity, needConversion, level);
            }
            assert (names[RETURN_CONV] == null);
            names[RETURN_CONV] = new LambdaForm.Name(fn, arg);
            assert (RETURN_CONV == names.length - 1);
        }
        LambdaForm form = new LambdaForm("convert", lambdaType.parameterCount(), names);
        return SimpleMethodHandle.make(srcType, form);
    }

    static MethodHandle makeReferenceIdentity(Class<?> refType) {
        MethodType lambdaType = MethodType.genericMethodType(1).invokerType();
        LambdaForm.Name[] names = LambdaForm.arguments(1, lambdaType);
        names[names.length - 1] = new LambdaForm.Name(ValueConversions.identity(), names[1]);
        LambdaForm form = new LambdaForm("identity", lambdaType.parameterCount(), names);
        return SimpleMethodHandle.make(MethodType.methodType(refType, refType), form);
    }

    static MethodHandle makeVarargsCollector(MethodHandle target, Class<?> arrayType) {
        int last;
        MethodType type = target.type();
        if (type.parameterType(last = type.parameterCount() - 1) != arrayType) {
            target = target.asType(type.changeParameterType(last, arrayType));
        }
        target = target.asFixedArity();
        return new AsVarargsCollector(target, target.type(), arrayType);
    }

    static MethodHandle makeSpreadArguments(MethodHandle target, Class<?> spreadArgType, int spreadArgPos, int spreadArgCount) {
        MethodType targetType = target.type();
        for (int i = 0; i < spreadArgCount; ++i) {
            Class<Object> arg = VerifyType.spreadArgElementType(spreadArgType, i);
            if (arg == null) {
                arg = Object.class;
            }
            targetType = targetType.changeParameterType(spreadArgPos + i, arg);
        }
        target = target.asType(targetType);
        MethodType srcType = targetType.replaceParameterTypes(spreadArgPos, spreadArgPos + spreadArgCount, spreadArgType);
        MethodType lambdaType = srcType.invokerType();
        LambdaForm.Name[] names = LambdaForm.arguments(spreadArgCount + 2, lambdaType);
        int nameCursor = lambdaType.parameterCount();
        int[] indexes = new int[targetType.parameterCount()];
        int i = 0;
        int argIndex = 1;
        while (i < targetType.parameterCount() + 1) {
            Class<?> src = lambdaType.parameterType(i);
            if (i == spreadArgPos) {
                MethodHandle aload = MethodHandles.arrayElementGetter(spreadArgType);
                LambdaForm.Name array = names[argIndex];
                names[nameCursor++] = new LambdaForm.Name(Lazy.NF_checkSpreadArgument, array, spreadArgCount);
                for (int j = 0; j < spreadArgCount; ++j) {
                    indexes[i] = nameCursor;
                    names[nameCursor++] = new LambdaForm.Name(aload, array, j);
                    ++i;
                }
            } else if (i < indexes.length) {
                indexes[i] = argIndex;
            }
            ++i;
            ++argIndex;
        }
        assert (nameCursor == names.length - 1);
        LambdaForm.Name[] targetArgs = new LambdaForm.Name[targetType.parameterCount()];
        for (int i2 = 0; i2 < targetType.parameterCount(); ++i2) {
            int idx = indexes[i2];
            targetArgs[i2] = names[idx];
        }
        names[names.length - 1] = new LambdaForm.Name(target, (Object[])targetArgs);
        LambdaForm form = new LambdaForm("spread", lambdaType.parameterCount(), names);
        return SimpleMethodHandle.make(srcType, form);
    }

    static void checkSpreadArgument(Object av, int n) {
        int len;
        if (av == null ? n == 0 : (av instanceof Object[] ? (len = ((Object[])av).length) == n : (len = Array.getLength(av)) == n)) {
            return;
        }
        throw MethodHandleStatics.newIllegalArgumentException("array is not of length " + n);
    }

    static MethodHandle makeCollectArguments(MethodHandle target, MethodHandle collector, int collectArgPos, boolean retainOriginalArgs) {
        MethodType targetType = target.type();
        MethodType collectorType = collector.type();
        int collectArgCount = collectorType.parameterCount();
        Class<?> collectValType = collectorType.returnType();
        int collectValCount = collectValType == Void.TYPE ? 0 : 1;
        MethodType srcType = targetType.dropParameterTypes(collectArgPos, collectArgPos + collectValCount);
        if (!retainOriginalArgs) {
            srcType = srcType.insertParameterTypes(collectArgPos, collectorType.parameterList());
        }
        MethodType lambdaType = srcType.invokerType();
        LambdaForm.Name[] names = LambdaForm.arguments(2, lambdaType);
        int collectNamePos = names.length - 2;
        int targetNamePos = names.length - 1;
        LambdaForm.Name[] collectorArgs = Arrays.copyOfRange(names, 1 + collectArgPos, 1 + collectArgPos + collectArgCount);
        names[collectNamePos] = new LambdaForm.Name(collector, (Object[])collectorArgs);
        LambdaForm.Name[] targetArgs = new LambdaForm.Name[targetType.parameterCount()];
        int inputArgPos = 1;
        int targetArgPos = 0;
        int chunk = collectArgPos;
        System.arraycopy(names, inputArgPos, targetArgs, targetArgPos, chunk);
        inputArgPos += chunk;
        targetArgPos += chunk;
        if (collectValType != Void.TYPE) {
            targetArgs[targetArgPos++] = names[collectNamePos];
        }
        chunk = collectArgCount;
        if (retainOriginalArgs) {
            System.arraycopy(names, inputArgPos, targetArgs, targetArgPos, chunk);
            targetArgPos += chunk;
        }
        inputArgPos += chunk;
        chunk = targetArgs.length - targetArgPos;
        System.arraycopy(names, inputArgPos, targetArgs, targetArgPos, chunk);
        assert (inputArgPos + chunk == collectNamePos);
        names[targetNamePos] = new LambdaForm.Name(target, (Object[])targetArgs);
        LambdaForm form = new LambdaForm("collect", lambdaType.parameterCount(), names);
        return SimpleMethodHandle.make(srcType, form);
    }

    static MethodHandle selectAlternative(boolean testResult, MethodHandle target, MethodHandle fallback) {
        return testResult ? target : fallback;
    }

    static MethodHandle selectAlternative() {
        if (SELECT_ALTERNATIVE != null) {
            return SELECT_ALTERNATIVE;
        }
        try {
            SELECT_ALTERNATIVE = MethodHandles.Lookup.IMPL_LOOKUP.findStatic(MethodHandleImpl.class, "selectAlternative", MethodType.methodType(MethodHandle.class, Boolean.TYPE, MethodHandle.class, MethodHandle.class));
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException(ex);
        }
        return SELECT_ALTERNATIVE;
    }

    static MethodHandle makeGuardWithTest(MethodHandle test, MethodHandle target, MethodHandle fallback) {
        MethodType basicType = target.type().basicType();
        MethodHandle invokeBasic = MethodHandles.basicInvoker(basicType);
        int arity = basicType.parameterCount();
        int extraNames = 3;
        MethodType lambdaType = basicType.invokerType();
        LambdaForm.Name[] names = LambdaForm.arguments(extraNames, lambdaType);
        Object[] testArgs = Arrays.copyOfRange(names, 1, 1 + arity, Object[].class);
        Object[] targetArgs = Arrays.copyOfRange(names, 0, 1 + arity, Object[].class);
        names[arity + 1] = new LambdaForm.Name(test, testArgs);
        Object[] selectArgs = new Object[]{names[arity + 1], target, fallback};
        names[arity + 2] = new LambdaForm.Name(MethodHandleImpl.selectAlternative(), selectArgs);
        targetArgs[0] = names[arity + 2];
        names[arity + 3] = new LambdaForm.Name(new LambdaForm.NamedFunction(invokeBasic), targetArgs);
        LambdaForm form = new LambdaForm("guard", lambdaType.parameterCount(), names);
        return SimpleMethodHandle.make(target.type(), form);
    }

    static MethodHandle makeGuardWithCatch(MethodHandle target, Class<? extends Throwable> exType, MethodHandle catcher) {
        MethodType type = target.type();
        MethodType ctype = catcher.type();
        int nargs = type.parameterCount();
        if (nargs < GuardWithCatch.INVOKES.length) {
            MethodType gtype = type.generic();
            MethodType gcatchType = gtype.insertParameterTypes(0, Throwable.class);
            MethodHandle gtarget = MethodHandleImpl.makePairwiseConvert(target, gtype, 2);
            MethodHandle gcatcher = MethodHandleImpl.makePairwiseConvert(catcher, gcatchType, 2);
            GuardWithCatch gguard = new GuardWithCatch(gtarget, exType, gcatcher);
            if (gtarget == null || gcatcher == null) {
                throw new InternalError();
            }
            MethodHandle ginvoker = GuardWithCatch.INVOKES[nargs].bindReceiver(gguard);
            return MethodHandleImpl.makePairwiseConvert(ginvoker, type, 2);
        }
        MethodHandle gtarget = MethodHandleImpl.makeSpreadArguments(target, Object[].class, 0, nargs);
        catcher = catcher.asType(ctype.changeParameterType(0, Throwable.class));
        MethodHandle gcatcher = MethodHandleImpl.makeSpreadArguments(catcher, Object[].class, 1, nargs);
        GuardWithCatch gguard = new GuardWithCatch(gtarget, exType, gcatcher);
        if (gtarget == null || gcatcher == null) {
            throw new InternalError();
        }
        MethodHandle ginvoker = GuardWithCatch.VARARGS_INVOKE.bindReceiver(gguard);
        MethodHandle gcollect = MethodHandleImpl.makeCollectArguments(ginvoker, ValueConversions.varargsArray(nargs), 0, false);
        return MethodHandleImpl.makePairwiseConvert(gcollect, type, 2);
    }

    static MethodHandle throwException(MethodType type) {
        assert (Throwable.class.isAssignableFrom(type.parameterType(0)));
        int arity = type.parameterCount();
        if (arity > 1) {
            return MethodHandleImpl.throwException(type.dropParameterTypes(1, arity)).dropArguments(type, 1, arity - 1);
        }
        return MethodHandleImpl.makePairwiseConvert(MethodHandleImpl.throwException(), type, 2);
    }

    static MethodHandle throwException() {
        MethodHandle mh = THROW_EXCEPTION;
        if (mh != null) {
            return mh;
        }
        try {
            mh = MethodHandles.Lookup.IMPL_LOOKUP.findStatic(MethodHandleImpl.class, "throwException", MethodType.methodType(Empty.class, Throwable.class));
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException(ex);
        }
        THROW_EXCEPTION = mh;
        return mh;
    }

    static <T extends Throwable> Empty throwException(T t) throws T {
        throw t;
    }

    static MethodHandle fakeMethodHandleInvoke(MemberName method) {
        MethodType type = method.getInvocationType();
        assert (type.equals((Object)MethodType.methodType(Object.class, Object[].class)));
        MethodHandle mh = FAKE_METHOD_HANDLE_INVOKE;
        if (mh != null) {
            return mh;
        }
        mh = MethodHandleImpl.throwException(type.insertParameterTypes(0, UnsupportedOperationException.class));
        FAKE_METHOD_HANDLE_INVOKE = mh = mh.bindTo(new UnsupportedOperationException("cannot reflectively invoke MethodHandle"));
        return mh;
    }

    static MethodHandle bindCaller(MethodHandle mh, Class<?> hostClass) {
        return BindCaller.bindCaller(mh, hostClass);
    }

    private static class BindCaller {
        private static final Unsafe UNSAFE = Unsafe.getUnsafe();
        private static ClassValue<MethodHandle> CV_makeInjectedInvoker = new ClassValue<MethodHandle>(){

            @Override
            protected MethodHandle computeValue(Class<?> hostClass) {
                return BindCaller.makeInjectedInvoker(hostClass);
            }
        };
        private static final MethodHandle MH_checkCallerClass;
        private static final byte[] T_BYTES;

        private BindCaller() {
        }

        static MethodHandle bindCaller(MethodHandle mh, Class<?> hostClass) {
            if (hostClass == null || hostClass.isArray() || hostClass.isPrimitive() || hostClass.getName().startsWith("java.") || hostClass.getName().startsWith("sun.")) {
                throw new InternalError();
            }
            MethodHandle vamh = BindCaller.prepareForInvoker(mh);
            MethodHandle bccInvoker = CV_makeInjectedInvoker.get(hostClass);
            return BindCaller.restoreToType(bccInvoker.bindTo(vamh), mh.type());
        }

        private static MethodHandle makeInjectedInvoker(Class<?> hostClass) {
            MethodHandle bccInvoker;
            Class bcc = UNSAFE.defineAnonymousClass(hostClass, T_BYTES, null);
            if (hostClass.getClassLoader() != bcc.getClassLoader()) {
                throw new InternalError(hostClass.getName() + " (CL)");
            }
            try {
                if (hostClass.getProtectionDomain() != bcc.getProtectionDomain()) {
                    throw new InternalError(hostClass.getName() + " (PD)");
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            try {
                MethodHandle init = MethodHandles.Lookup.IMPL_LOOKUP.findStatic(bcc, "init", MethodType.methodType(Void.TYPE));
                init.invokeExact();
            }
            catch (Throwable ex) {
                throw MethodHandleStatics.uncaughtException(ex);
            }
            try {
                MethodType invokerMT = MethodType.methodType(Object.class, MethodHandle.class, Object[].class);
                bccInvoker = MethodHandles.Lookup.IMPL_LOOKUP.findStatic(bcc, "invoke_V", invokerMT);
            }
            catch (ReflectiveOperationException ex) {
                throw MethodHandleStatics.uncaughtException(ex);
            }
            try {
                MethodHandle vamh = BindCaller.prepareForInvoker(MH_checkCallerClass);
                Object object = bccInvoker.invokeExact(vamh, new Object[]{hostClass, bcc});
            }
            catch (Throwable ex) {
                throw MethodHandleStatics.newInternalError(ex);
            }
            return bccInvoker;
        }

        private static MethodHandle prepareForInvoker(MethodHandle mh) {
            mh = mh.asFixedArity();
            MethodType mt = mh.type();
            int arity = mt.parameterCount();
            MethodHandle vamh = mh.asType(mt.generic());
            vamh.internalForm().compileToBytecode();
            vamh = vamh.asSpreader(Object[].class, arity);
            vamh.internalForm().compileToBytecode();
            return vamh;
        }

        private static MethodHandle restoreToType(MethodHandle vamh, MethodType type) {
            return vamh.asCollector(Object[].class, type.parameterCount()).asType(type);
        }

        @CallerSensitive
        private static boolean checkCallerClass(Class<?> expected, Class<?> expected2) {
            Class actual = Reflection.getCallerClass();
            if (actual != expected && actual != expected2) {
                throw new InternalError("found " + actual.getName() + ", expected " + expected.getName() + (expected == expected2 ? "" : ", or else " + expected2.getName()));
            }
            return true;
        }

        static {
            Class<BindCaller> THIS_CLASS = BindCaller.class;
            assert (BindCaller.checkCallerClass(THIS_CLASS, THIS_CLASS));
            try {
                MH_checkCallerClass = MethodHandles.Lookup.IMPL_LOOKUP.findStatic(THIS_CLASS, "checkCallerClass", MethodType.methodType(Boolean.TYPE, Class.class, Class.class));
                assert (MH_checkCallerClass.invokeExact(THIS_CLASS, THIS_CLASS));
            }
            catch (Throwable ex) {
                throw MethodHandleStatics.newInternalError(ex);
            }
            final Object[] values = new Object[]{null};
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    try {
                        Class<T> tClass = T.class;
                        String tName = tClass.getName();
                        String tResource = tName.substring(tName.lastIndexOf(46) + 1) + ".class";
                        URLConnection uconn = tClass.getResource(tResource).openConnection();
                        int len = uconn.getContentLength();
                        byte[] bytes = new byte[len];
                        try (InputStream str = uconn.getInputStream();){
                            int nr = str.read(bytes);
                            if (nr != len) {
                                throw new IOException(tResource);
                            }
                        }
                        values[0] = bytes;
                    }
                    catch (IOException ex) {
                        throw MethodHandleStatics.newInternalError(ex);
                    }
                    return null;
                }
            });
            T_BYTES = (byte[])values[0];
        }

        private static class T {
            private T() {
            }

            static void init() {
            }

            static Object invoke_V(MethodHandle vamh, Object[] args) throws Throwable {
                return vamh.invokeExact(args);
            }
        }
    }

    private static class GuardWithCatch {
        private final MethodHandle target;
        private final Class<? extends Throwable> exType;
        private final MethodHandle catcher;
        static final MethodHandle[] INVOKES = GuardWithCatch.makeInvokes();
        static final MethodHandle VARARGS_INVOKE;

        GuardWithCatch(MethodHandle target, Class<? extends Throwable> exType, MethodHandle catcher) {
            this.target = target;
            this.exType = exType;
            this.catcher = catcher;
        }

        @LambdaForm.Hidden
        private Object invoke_V(Object ... av) throws Throwable {
            try {
                return this.target.invokeExact(av);
            }
            catch (Throwable t) {
                if (!this.exType.isInstance(t)) {
                    throw t;
                }
                return this.catcher.invokeExact(t, av);
            }
        }

        @LambdaForm.Hidden
        private Object invoke_L0() throws Throwable {
            try {
                return this.target.invokeExact();
            }
            catch (Throwable t) {
                if (!this.exType.isInstance(t)) {
                    throw t;
                }
                return this.catcher.invokeExact(t);
            }
        }

        @LambdaForm.Hidden
        private Object invoke_L1(Object a0) throws Throwable {
            try {
                return this.target.invokeExact(a0);
            }
            catch (Throwable t) {
                if (!this.exType.isInstance(t)) {
                    throw t;
                }
                return this.catcher.invokeExact(t, a0);
            }
        }

        @LambdaForm.Hidden
        private Object invoke_L2(Object a0, Object a1) throws Throwable {
            try {
                return this.target.invokeExact(a0, a1);
            }
            catch (Throwable t) {
                if (!this.exType.isInstance(t)) {
                    throw t;
                }
                return this.catcher.invokeExact(t, a0, a1);
            }
        }

        @LambdaForm.Hidden
        private Object invoke_L3(Object a0, Object a1, Object a2) throws Throwable {
            try {
                return this.target.invokeExact(a0, a1, a2);
            }
            catch (Throwable t) {
                if (!this.exType.isInstance(t)) {
                    throw t;
                }
                return this.catcher.invokeExact(t, a0, a1, a2);
            }
        }

        @LambdaForm.Hidden
        private Object invoke_L4(Object a0, Object a1, Object a2, Object a3) throws Throwable {
            try {
                return this.target.invokeExact(a0, a1, a2, a3);
            }
            catch (Throwable t) {
                if (!this.exType.isInstance(t)) {
                    throw t;
                }
                return this.catcher.invokeExact(t, a0, a1, a2, a3);
            }
        }

        @LambdaForm.Hidden
        private Object invoke_L5(Object a0, Object a1, Object a2, Object a3, Object a4) throws Throwable {
            try {
                return this.target.invokeExact(a0, a1, a2, a3, a4);
            }
            catch (Throwable t) {
                if (!this.exType.isInstance(t)) {
                    throw t;
                }
                return this.catcher.invokeExact(t, a0, a1, a2, a3, a4);
            }
        }

        @LambdaForm.Hidden
        private Object invoke_L6(Object a0, Object a1, Object a2, Object a3, Object a4, Object a5) throws Throwable {
            try {
                return this.target.invokeExact(a0, a1, a2, a3, a4, a5);
            }
            catch (Throwable t) {
                if (!this.exType.isInstance(t)) {
                    throw t;
                }
                return this.catcher.invokeExact(t, a0, a1, a2, a3, a4, a5);
            }
        }

        @LambdaForm.Hidden
        private Object invoke_L7(Object a0, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6) throws Throwable {
            try {
                return this.target.invokeExact(a0, a1, a2, a3, a4, a5, a6);
            }
            catch (Throwable t) {
                if (!this.exType.isInstance(t)) {
                    throw t;
                }
                return this.catcher.invokeExact(t, a0, a1, a2, a3, a4, a5, a6);
            }
        }

        @LambdaForm.Hidden
        private Object invoke_L8(Object a0, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6, Object a7) throws Throwable {
            try {
                return this.target.invokeExact(a0, a1, a2, a3, a4, a5, a6, a7);
            }
            catch (Throwable t) {
                if (!this.exType.isInstance(t)) {
                    throw t;
                }
                return this.catcher.invokeExact(t, a0, a1, a2, a3, a4, a5, a6, a7);
            }
        }

        static MethodHandle[] makeInvokes() {
            ArrayList<MethodHandle> invokes = new ArrayList<MethodHandle>();
            MethodHandles.Lookup lookup = MethodHandles.Lookup.IMPL_LOOKUP;
            while (true) {
                int nargs = invokes.size();
                String name = "invoke_L" + nargs;
                MethodHandle invoke = null;
                try {
                    invoke = lookup.findVirtual(GuardWithCatch.class, name, MethodType.genericMethodType(nargs));
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    // empty catch block
                }
                if (invoke == null) break;
                invokes.add(invoke);
            }
            assert (invokes.size() == 9);
            return invokes.toArray(new MethodHandle[0]);
        }

        static {
            try {
                VARARGS_INVOKE = MethodHandles.Lookup.IMPL_LOOKUP.findVirtual(GuardWithCatch.class, "invoke_V", MethodType.genericMethodType(0, true));
            }
            catch (ReflectiveOperationException ex) {
                throw MethodHandleStatics.uncaughtException(ex);
            }
        }
    }

    private static class Lazy {
        static final LambdaForm.NamedFunction NF_checkSpreadArgument;

        private Lazy() {
        }

        static {
            try {
                NF_checkSpreadArgument = new LambdaForm.NamedFunction(MethodHandleImpl.class.getDeclaredMethod("checkSpreadArgument", Object.class, Integer.TYPE));
                NF_checkSpreadArgument.resolve();
            }
            catch (ReflectiveOperationException ex) {
                throw MethodHandleStatics.newInternalError(ex);
            }
        }
    }

    static class AsVarargsCollector
    extends MethodHandle {
        private final MethodHandle target;
        private final Class<?> arrayType;
        private MethodHandle cache;

        AsVarargsCollector(MethodHandle target, MethodType type, Class<?> arrayType) {
            super(type, AsVarargsCollector.reinvokerForm(type));
            this.target = target;
            this.arrayType = arrayType;
            this.cache = target.asCollector(arrayType, 0);
        }

        @Override
        MethodHandle reinvokerTarget() {
            return this.target;
        }

        @Override
        public boolean isVarargsCollector() {
            return true;
        }

        @Override
        public MethodHandle asFixedArity() {
            return this.target;
        }

        @Override
        public MethodHandle asType(MethodType newType) {
            MethodHandle collector;
            MethodType type = this.type();
            int collectArg = type.parameterCount() - 1;
            int newArity = newType.parameterCount();
            if (newArity == collectArg + 1 && type.parameterType(collectArg).isAssignableFrom(newType.parameterType(collectArg))) {
                return this.asFixedArity().asType(newType);
            }
            if (this.cache.type().parameterCount() == newArity) {
                return this.cache.asType(newType);
            }
            int arrayLength = newArity - collectArg;
            try {
                collector = this.asFixedArity().asCollector(this.arrayType, arrayLength);
                assert (collector.type().parameterCount() == newArity) : "newArity=" + newArity + " but collector=" + collector;
            }
            catch (IllegalArgumentException ex) {
                throw new WrongMethodTypeException("cannot build collector", ex);
            }
            this.cache = collector;
            return collector.asType(newType);
        }

        @Override
        MethodHandle setVarargs(MemberName member) {
            if (member.isVarargs()) {
                return this;
            }
            return this.asFixedArity();
        }

        @Override
        MethodHandle viewAsType(MethodType newType) {
            MethodHandle mh = super.viewAsType(newType);
            MethodType type = mh.type();
            int arity = type.parameterCount();
            return mh.asVarargsCollector(type.parameterType(arity - 1));
        }

        @Override
        MemberName internalMemberName() {
            return this.asFixedArity().internalMemberName();
        }

        @Override
        MethodHandle bindArgument(int pos, char basicType, Object value) {
            return this.asFixedArity().bindArgument(pos, basicType, value);
        }

        @Override
        MethodHandle bindReceiver(Object receiver) {
            return this.asFixedArity().bindReceiver(receiver);
        }

        @Override
        MethodHandle dropArguments(MethodType srcType, int pos, int drops) {
            return this.asFixedArity().dropArguments(srcType, pos, drops);
        }

        @Override
        MethodHandle permuteArguments(MethodType newType, int[] reorder) {
            return this.asFixedArity().permuteArguments(newType, reorder);
        }
    }

    static final class ArrayAccessor {
        static final HashMap<Class<?>, MethodHandle> GETTER_CACHE = new HashMap();
        static final HashMap<Class<?>, MethodHandle> SETTER_CACHE = new HashMap();
        static final boolean USE_WEAKLY_TYPED_ARRAY_ACCESSORS = false;

        ArrayAccessor() {
        }

        static int getElementI(int[] a, int i) {
            return a[i];
        }

        static long getElementJ(long[] a, int i) {
            return a[i];
        }

        static float getElementF(float[] a, int i) {
            return a[i];
        }

        static double getElementD(double[] a, int i) {
            return a[i];
        }

        static boolean getElementZ(boolean[] a, int i) {
            return a[i];
        }

        static byte getElementB(byte[] a, int i) {
            return a[i];
        }

        static short getElementS(short[] a, int i) {
            return a[i];
        }

        static char getElementC(char[] a, int i) {
            return a[i];
        }

        static Object getElementL(Object[] a, int i) {
            return a[i];
        }

        static void setElementI(int[] a, int i, int x) {
            a[i] = x;
        }

        static void setElementJ(long[] a, int i, long x) {
            a[i] = x;
        }

        static void setElementF(float[] a, int i, float x) {
            a[i] = x;
        }

        static void setElementD(double[] a, int i, double x) {
            a[i] = x;
        }

        static void setElementZ(boolean[] a, int i, boolean x) {
            a[i] = x;
        }

        static void setElementB(byte[] a, int i, byte x) {
            a[i] = x;
        }

        static void setElementS(short[] a, int i, short x) {
            a[i] = x;
        }

        static void setElementC(char[] a, int i, char x) {
            a[i] = x;
        }

        static void setElementL(Object[] a, int i, Object x) {
            a[i] = x;
        }

        static Object getElementL(Class<?> arrayClass, Object[] a, int i) {
            arrayClass.cast(a);
            return a[i];
        }

        static void setElementL(Class<?> arrayClass, Object[] a, int i, Object x) {
            arrayClass.cast(a);
            a[i] = x;
        }

        static Object getElementL(Object a, int i) {
            return ArrayAccessor.getElementL((Object[])a, i);
        }

        static void setElementL(Object a, int i, Object x) {
            ArrayAccessor.setElementL((Object[])a, i, x);
        }

        static Object getElementL(Object arrayClass, Object a, int i) {
            return ArrayAccessor.getElementL((Class)arrayClass, (Object[])a, i);
        }

        static void setElementL(Object arrayClass, Object a, int i, Object x) {
            ArrayAccessor.setElementL((Class)arrayClass, (Object[])a, i, x);
        }

        static boolean needCast(Class<?> arrayClass) {
            Class<?> elemClass = arrayClass.getComponentType();
            return !elemClass.isPrimitive() && elemClass != Object.class;
        }

        static String name(Class<?> arrayClass, boolean isSetter) {
            Class<?> elemClass = arrayClass.getComponentType();
            if (elemClass == null) {
                throw new IllegalArgumentException();
            }
            return (!isSetter ? "getElement" : "setElement") + Wrapper.basicTypeChar(elemClass);
        }

        static MethodType type(Class<?> arrayClass, boolean isSetter) {
            Class<?> elemClass = arrayClass.getComponentType();
            Class<Object> arrayArgClass = arrayClass;
            if (!elemClass.isPrimitive()) {
                arrayArgClass = Object[].class;
            }
            if (!ArrayAccessor.needCast(arrayClass)) {
                return !isSetter ? MethodType.methodType(elemClass, arrayArgClass, Integer.TYPE) : MethodType.methodType(Void.TYPE, arrayArgClass, Integer.TYPE, elemClass);
            }
            Class<Class> classArgClass = Class.class;
            return !isSetter ? MethodType.methodType(Object.class, classArgClass, arrayArgClass, Integer.TYPE) : MethodType.methodType(Void.TYPE, classArgClass, arrayArgClass, Integer.TYPE, Object.class);
        }

        static MethodType correctType(Class<?> arrayClass, boolean isSetter) {
            Class<?> elemClass = arrayClass.getComponentType();
            return !isSetter ? MethodType.methodType(elemClass, arrayClass, Integer.TYPE) : MethodType.methodType(Void.TYPE, arrayClass, Integer.TYPE, elemClass);
        }

        static MethodHandle getAccessor(Class<?> arrayClass, boolean isSetter) {
            String name = ArrayAccessor.name(arrayClass, isSetter);
            MethodType type = ArrayAccessor.type(arrayClass, isSetter);
            try {
                return MethodHandles.Lookup.IMPL_LOOKUP.findStatic(ArrayAccessor.class, name, type);
            }
            catch (ReflectiveOperationException ex) {
                throw MethodHandleStatics.uncaughtException(ex);
            }
        }
    }
}

