/*
 * Decompiled with CFR 0.152.
 */
package sun.net.sdp;

import java.io.FileDescriptor;
import java.io.IOException;
import java.security.AccessController;
import sun.misc.JavaIOFileDescriptorAccess;
import sun.misc.SharedSecrets;
import sun.security.action.GetPropertyAction;
import sun.security.action.LoadLibraryAction;

public final class SdpSupport {
    private static final String os = AccessController.doPrivileged(new GetPropertyAction("os.name"));
    private static final boolean isSupported = os.equals("SunOS") || os.equals("Linux");
    private static final JavaIOFileDescriptorAccess fdAccess = SharedSecrets.getJavaIOFileDescriptorAccess();

    private SdpSupport() {
    }

    public static FileDescriptor createSocket() throws IOException {
        if (!isSupported) {
            throw new UnsupportedOperationException("SDP not supported on this platform");
        }
        int fdVal = SdpSupport.create0();
        FileDescriptor fd = new FileDescriptor();
        fdAccess.set(fd, fdVal);
        return fd;
    }

    public static void convertSocket(FileDescriptor fd) throws IOException {
        if (!isSupported) {
            throw new UnsupportedOperationException("SDP not supported on this platform");
        }
        int fdVal = fdAccess.get(fd);
        SdpSupport.convert0(fdVal);
    }

    private static native int create0() throws IOException;

    private static native void convert0(int var0) throws IOException;

    static {
        AccessController.doPrivileged(new LoadLibraryAction("net"));
    }
}

