/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.FileStoreAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Properties;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileAttributes;
import sun.nio.fs.UnixFileStoreAttributes;
import sun.nio.fs.UnixFileSystem;
import sun.nio.fs.UnixMountEntry;
import sun.nio.fs.UnixPath;

abstract class UnixFileStore
extends FileStore {
    private final UnixPath file;
    private final long dev;
    private final UnixMountEntry entry;
    private static final Object loadLock = new Object();
    private static volatile Properties props;

    private static long devFor(UnixPath file) throws IOException {
        try {
            return UnixFileAttributes.get(file, true).dev();
        }
        catch (UnixException x) {
            x.rethrowAsIOException(file);
            return 0L;
        }
    }

    UnixFileStore(UnixPath file) throws IOException {
        this.file = file;
        this.dev = UnixFileStore.devFor(file);
        this.entry = this.findMountEntry();
    }

    UnixFileStore(UnixFileSystem fs, UnixMountEntry entry) throws IOException {
        this.file = new UnixPath(fs, entry.dir());
        this.dev = entry.dev() == 0L ? UnixFileStore.devFor(this.file) : entry.dev();
        this.entry = entry;
    }

    abstract UnixMountEntry findMountEntry() throws IOException;

    UnixPath file() {
        return this.file;
    }

    long dev() {
        return this.dev;
    }

    UnixMountEntry entry() {
        return this.entry;
    }

    @Override
    public String name() {
        return this.entry.name();
    }

    @Override
    public String type() {
        return this.entry.fstype();
    }

    @Override
    public boolean isReadOnly() {
        return this.entry.isReadOnly();
    }

    private UnixFileStoreAttributes readAttributes() throws IOException {
        try {
            return UnixFileStoreAttributes.get(this.file);
        }
        catch (UnixException x) {
            x.rethrowAsIOException(this.file);
            return null;
        }
    }

    @Override
    public long getTotalSpace() throws IOException {
        UnixFileStoreAttributes attrs = this.readAttributes();
        return attrs.blockSize() * attrs.totalBlocks();
    }

    @Override
    public long getUsableSpace() throws IOException {
        UnixFileStoreAttributes attrs = this.readAttributes();
        return attrs.blockSize() * attrs.availableBlocks();
    }

    @Override
    public long getUnallocatedSpace() throws IOException {
        UnixFileStoreAttributes attrs = this.readAttributes();
        return attrs.blockSize() * attrs.freeBlocks();
    }

    @Override
    public <V extends FileStoreAttributeView> V getFileStoreAttributeView(Class<V> view) {
        if (view == null) {
            throw new NullPointerException();
        }
        return (V)((FileStoreAttributeView)null);
    }

    @Override
    public Object getAttribute(String attribute) throws IOException {
        if (attribute.equals("totalSpace")) {
            return this.getTotalSpace();
        }
        if (attribute.equals("usableSpace")) {
            return this.getUsableSpace();
        }
        if (attribute.equals("unallocatedSpace")) {
            return this.getUnallocatedSpace();
        }
        throw new UnsupportedOperationException("'" + attribute + "' not recognized");
    }

    @Override
    public boolean supportsFileAttributeView(Class<? extends FileAttributeView> type) {
        if (type == null) {
            throw new NullPointerException();
        }
        if (type == BasicFileAttributeView.class) {
            return true;
        }
        if (type == PosixFileAttributeView.class || type == FileOwnerAttributeView.class) {
            FeatureStatus status = this.checkIfFeaturePresent("posix");
            return status != FeatureStatus.NOT_PRESENT;
        }
        return false;
    }

    @Override
    public boolean supportsFileAttributeView(String name) {
        if (name.equals("basic") || name.equals("unix")) {
            return true;
        }
        if (name.equals("posix")) {
            return this.supportsFileAttributeView(PosixFileAttributeView.class);
        }
        if (name.equals("owner")) {
            return this.supportsFileAttributeView(FileOwnerAttributeView.class);
        }
        return false;
    }

    public boolean equals(Object ob) {
        if (ob == this) {
            return true;
        }
        if (!(ob instanceof UnixFileStore)) {
            return false;
        }
        UnixFileStore other = (UnixFileStore)ob;
        return this.dev == other.dev && Arrays.equals(this.entry.dir(), other.entry.dir()) && this.entry.name().equals(other.entry.name());
    }

    public int hashCode() {
        return (int)(this.dev ^ this.dev >>> 32) ^ Arrays.hashCode(this.entry.dir());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(new String(this.entry.dir()));
        sb.append(" (");
        sb.append(this.entry.name());
        sb.append(")");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FeatureStatus checkIfFeaturePresent(String feature) {
        String value;
        if (props == null) {
            Object object = loadLock;
            synchronized (object) {
                if (props == null) {
                    props = AccessController.doPrivileged(new PrivilegedAction<Properties>(){

                        @Override
                        public Properties run() {
                            return UnixFileStore.loadProperties();
                        }
                    });
                }
            }
        }
        if ((value = props.getProperty(this.type())) != null) {
            String[] values;
            for (String s : values = value.split("\\s")) {
                if ((s = s.trim().toLowerCase()).equals(feature)) {
                    return FeatureStatus.PRESENT;
                }
                if (!s.startsWith("no") || !(s = s.substring(2)).equals(feature)) continue;
                return FeatureStatus.NOT_PRESENT;
            }
        }
        return FeatureStatus.UNKNOWN;
    }

    private static Properties loadProperties() {
        Properties result = new Properties();
        String fstypes = System.getProperty("java.home") + "/lib/fstypes.properties";
        Path file = Paths.get(fstypes, new String[0]);
        try (SeekableByteChannel rbc = Files.newByteChannel(file, new OpenOption[0]);){
            result.load(Channels.newReader(rbc, "UTF-8"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    static enum FeatureStatus {
        PRESENT,
        NOT_PRESENT,
        UNKNOWN;

    }
}

