/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.AccessController;
import java.util.Date;
import sun.rmi.runtime.NewThreadAction;
import sun.security.action.GetPropertyAction;

class PipeWriter
implements Runnable {
    private ByteArrayOutputStream bufOut;
    private int cLast;
    private byte[] currSep;
    private PrintWriter out;
    private InputStream in;
    private String pipeString;
    private String execString;
    private static String lineSeparator;
    private static int lineSeparatorLength;
    private static int numExecs;

    private PipeWriter(InputStream in, OutputStream out, String tag, int nExecs) {
        this.in = in;
        this.out = new PrintWriter(out);
        this.bufOut = new ByteArrayOutputStream();
        this.currSep = new byte[lineSeparatorLength];
        this.execString = ":ExecGroup-" + Integer.toString(nExecs) + ':' + tag + ':';
    }

    @Override
    public void run() {
        byte[] buf = new byte[256];
        try {
            int count;
            while ((count = this.in.read(buf)) != -1) {
                this.write(buf, 0, count);
            }
            String lastInBuffer = this.bufOut.toString();
            this.bufOut.reset();
            if (lastInBuffer.length() > 0) {
                this.out.println(this.createAnnotation() + lastInBuffer);
                this.out.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void write(byte[] b, int off, int len) throws IOException {
        if (len < 0) {
            throw new ArrayIndexOutOfBoundsException(len);
        }
        for (int i = 0; i < len; ++i) {
            this.write(b[off + i]);
        }
    }

    private void write(byte b) throws IOException {
        int i = 0;
        for (i = 1; i < this.currSep.length; ++i) {
            this.currSep[i - 1] = this.currSep[i];
        }
        this.currSep[i - 1] = b;
        this.bufOut.write(b);
        if (this.cLast >= lineSeparatorLength - 1 && lineSeparator.equals(new String(this.currSep))) {
            this.cLast = 0;
            this.out.print(this.createAnnotation() + this.bufOut.toString());
            this.out.flush();
            this.bufOut.reset();
            if (this.out.checkError()) {
                throw new IOException("PipeWriter: IO Exception when writing to output stream.");
            }
        } else {
            ++this.cLast;
        }
    }

    private String createAnnotation() {
        return new Date().toString() + this.execString;
    }

    static void plugTogetherPair(InputStream in, OutputStream out, InputStream in1, OutputStream out1) {
        Thread inThread = null;
        Thread outThread = null;
        int nExecs = PipeWriter.getNumExec();
        inThread = AccessController.doPrivileged(new NewThreadAction(new PipeWriter(in, out, "out", nExecs), "out", true));
        outThread = AccessController.doPrivileged(new NewThreadAction(new PipeWriter(in1, out1, "err", nExecs), "err", true));
        inThread.start();
        outThread.start();
    }

    private static synchronized int getNumExec() {
        return numExecs++;
    }

    static {
        numExecs = 0;
        lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
        lineSeparatorLength = lineSeparator.length();
    }
}

