/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.xr;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.font.XRTextRenderer;
import sun.java2d.SunGraphics2D;
import sun.java2d.jules.TrapezoidList;
import sun.java2d.loops.XORComposite;
import sun.java2d.xr.GrowableEltArray;
import sun.java2d.xr.GrowableRectArray;
import sun.java2d.xr.MaskTileManager;
import sun.java2d.xr.XRBackend;
import sun.java2d.xr.XRBackendNative;
import sun.java2d.xr.XRColor;
import sun.java2d.xr.XRMaskImage;
import sun.java2d.xr.XRPaints;
import sun.java2d.xr.XRSolidSrcPict;
import sun.java2d.xr.XRSurfaceData;
import sun.java2d.xr.XRUtils;

public class XRCompositeManager {
    private static boolean enableGradCache = true;
    private static XRCompositeManager instance;
    private static final int SOLID = 0;
    private static final int TEXTURE = 1;
    private static final int GRADIENT = 2;
    int srcType;
    XRSolidSrcPict solidSrc32;
    XRSurfaceData texture;
    XRSurfaceData gradient;
    int alphaMask = 0;
    XRColor solidColor = new XRColor();
    float extraAlpha = 1.0f;
    byte compRule = (byte)3;
    XRColor alphaColor = new XRColor();
    XRSurfaceData solidSrcPict;
    int alphaMaskPict;
    int gradCachePixmap;
    int gradCachePicture;
    boolean xorEnabled = false;
    int validatedPixel = 0;
    Composite validatedComp;
    Paint validatedPaint;
    float validatedExtraAlpha = 1.0f;
    XRBackend con = new XRBackendNative();
    MaskTileManager maskBuffer;
    XRTextRenderer textRenderer;
    XRMaskImage maskImage;

    public static synchronized XRCompositeManager getInstance(XRSurfaceData xRSurfaceData) {
        if (instance == null) {
            instance = new XRCompositeManager(xRSurfaceData);
        }
        return instance;
    }

    private XRCompositeManager(XRSurfaceData xRSurfaceData) {
        String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("sun.java2d.xrgradcache");
            }
        });
        enableGradCache = string == null || !string.equalsIgnoreCase("false") && !string.equalsIgnoreCase("f");
        XRPaints.register(this);
        this.initResources(xRSurfaceData);
        this.maskBuffer = new MaskTileManager(this, xRSurfaceData.getXid());
        this.textRenderer = new XRTextRenderer(this);
        this.maskImage = new XRMaskImage(this, xRSurfaceData.getXid());
    }

    public void initResources(XRSurfaceData xRSurfaceData) {
        int n = xRSurfaceData.getXid();
        this.solidSrc32 = new XRSolidSrcPict(this.con, n);
        this.setForeground(0);
        int n2 = this.con.createPixmap(n, 8, 1, 1);
        this.alphaMaskPict = this.con.createPicture(n2, 2);
        this.con.setPictureRepeat(this.alphaMaskPict, 1);
        this.con.renderRectangle(this.alphaMaskPict, (byte)0, XRColor.NO_ALPHA, 0, 0, 1, 1);
        if (enableGradCache) {
            this.gradCachePixmap = this.con.createPixmap(n, 32, 256, 256);
            this.gradCachePicture = this.con.createPicture(this.gradCachePixmap, 0);
        }
    }

    public void setForeground(int n) {
        this.solidColor.setColorValues(n, true);
    }

    public void setGradientPaint(XRSurfaceData xRSurfaceData) {
        if (this.gradient != null) {
            this.con.freePicture(this.gradient.picture);
        }
        this.gradient = xRSurfaceData;
        this.srcType = 2;
    }

    public void setTexturePaint(XRSurfaceData xRSurfaceData) {
        this.texture = xRSurfaceData;
        this.srcType = 1;
    }

    public void XRResetPaint() {
        this.srcType = 0;
    }

    public void validateCompositeState(Composite composite, AffineTransform affineTransform, Paint paint, SunGraphics2D sunGraphics2D) {
        boolean bl;
        boolean bl2 = bl = paint != this.validatedPaint || paint == null;
        if (composite != this.validatedComp) {
            if (composite != null) {
                this.setComposite(composite);
            } else {
                composite = AlphaComposite.getInstance(3);
                this.setComposite(composite);
            }
            bl = true;
            this.validatedComp = composite;
        }
        if (sunGraphics2D != null && (this.validatedPixel != sunGraphics2D.pixel || bl)) {
            this.validatedPixel = sunGraphics2D.pixel;
            this.setForeground(this.validatedPixel);
        }
        if (bl) {
            if (paint != null && sunGraphics2D != null && sunGraphics2D.paintState >= 2) {
                XRPaints.setPaint(sunGraphics2D, paint);
            } else {
                this.XRResetPaint();
            }
            this.validatedPaint = paint;
        }
        if (this.srcType != 0) {
            AffineTransform affineTransform2 = (AffineTransform)affineTransform.clone();
            try {
                affineTransform2.invert();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                affineTransform2.setToIdentity();
            }
            this.getCurrentSource().validateAsSource(affineTransform2, -1, XRUtils.ATransOpToXRQuality(sunGraphics2D.interpolationType));
        }
    }

    private void setComposite(Composite composite) {
        if (composite instanceof AlphaComposite) {
            AlphaComposite alphaComposite = (AlphaComposite)composite;
            this.validatedExtraAlpha = alphaComposite.getAlpha();
            this.compRule = XRUtils.j2dAlphaCompToXR(alphaComposite.getRule());
            this.extraAlpha = this.validatedExtraAlpha;
            if (this.extraAlpha == 1.0f) {
                this.alphaMask = 0;
                this.alphaColor.alpha = XRColor.FULL_ALPHA.alpha;
            } else {
                this.alphaColor.alpha = XRColor.byteToXRColorValue((int)(this.extraAlpha * 255.0f));
                this.alphaMask = this.alphaMaskPict;
                this.con.renderRectangle(this.alphaMaskPict, (byte)1, this.alphaColor, 0, 0, 1, 1);
            }
            this.xorEnabled = false;
        } else if (composite instanceof XORComposite) {
            this.xorEnabled = true;
        } else {
            throw new InternalError("Composite accaleration not implemented for: " + composite.getClass().getName());
        }
    }

    public boolean maskRequired() {
        return !this.xorEnabled && (this.srcType != 0 || this.srcType == 0 && this.solidColor.alpha != 65535 || this.extraAlpha != 1.0f);
    }

    public void XRComposite(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        int n12 = n == 0 ? this.getCurrentSource().picture : n;
        int n13 = n4;
        int n14 = n5;
        if (enableGradCache && this.gradient != null && n12 == this.gradient.picture) {
            this.con.renderComposite((byte)1, this.gradient.picture, 0, this.gradCachePicture, n4, n5, 0, 0, 0, 0, n10, n11);
            n13 = 0;
            n14 = 0;
            n12 = this.gradCachePicture;
        }
        this.con.renderComposite(this.compRule, n12, n2, n3, n13, n14, n6, n7, n8, n9, n10, n11);
    }

    public void XRCompositeTraps(int n, int n2, int n3, TrapezoidList trapezoidList) {
        int n4 = 0;
        int n5 = 0;
        if (trapezoidList.getP1YLeft(0) < trapezoidList.getP2YLeft(0)) {
            n4 = trapezoidList.getP1XLeft(0);
            n5 = trapezoidList.getP1YLeft(0);
        } else {
            n4 = trapezoidList.getP2XLeft(0);
            n5 = trapezoidList.getP2YLeft(0);
        }
        n4 = (int)Math.floor(XRUtils.XFixedToDouble(n4));
        n5 = (int)Math.floor(XRUtils.XFixedToDouble(n5));
        this.con.renderCompositeTrapezoids(this.compRule, this.getCurrentSource().picture, 2, n, n4, n5, trapezoidList);
    }

    public void XRRenderRectangles(XRSurfaceData xRSurfaceData, GrowableRectArray growableRectArray) {
        if (this.xorEnabled) {
            this.con.GCRectangles(xRSurfaceData.getXid(), xRSurfaceData.getGC(), growableRectArray);
        } else if (growableRectArray.getSize() == 1) {
            this.con.renderRectangle(xRSurfaceData.getPicture(), this.compRule, this.solidColor, growableRectArray.getX(0), growableRectArray.getY(0), growableRectArray.getWidth(0), growableRectArray.getHeight(0));
        } else {
            this.con.renderRectangles(xRSurfaceData.getPicture(), this.compRule, this.solidColor, growableRectArray);
        }
    }

    public void XRCompositeRectangles(XRSurfaceData xRSurfaceData, GrowableRectArray growableRectArray) {
        int n = this.getCurrentSource().picture;
        for (int i = 0; i < growableRectArray.getSize(); ++i) {
            int n2 = growableRectArray.getX(i);
            int n3 = growableRectArray.getY(i);
            int n4 = growableRectArray.getWidth(i);
            int n5 = growableRectArray.getHeight(i);
            this.con.renderComposite(this.compRule, n, 0, xRSurfaceData.picture, n2, n3, 0, 0, n2, n3, n4, n5);
        }
    }

    protected XRSurfaceData getCurrentSource() {
        switch (this.srcType) {
            case 0: {
                return this.solidSrc32.prepareSrcPict(this.validatedPixel);
            }
            case 1: {
                return this.texture;
            }
            case 2: {
                return this.gradient;
            }
        }
        return null;
    }

    public void compositeBlit(XRSurfaceData xRSurfaceData, XRSurfaceData xRSurfaceData2, int n, int n2, int n3, int n4, int n5, int n6) {
        this.con.renderComposite(this.compRule, xRSurfaceData.picture, this.alphaMask, xRSurfaceData2.picture, n, n2, 0, 0, n3, n4, n5, n6);
    }

    public void compositeText(XRSurfaceData xRSurfaceData, int n, int n2, int n3, int n4, GrowableEltArray growableEltArray) {
        byte by = this.compRule != 1 ? (byte)this.compRule : (byte)3;
        this.con.XRenderCompositeText(by, this.getCurrentSource().picture, xRSurfaceData.picture, n4, n, n2, 0, 0, n3, growableEltArray);
    }

    public XRColor getMaskColor() {
        return !this.isTexturePaintActive() ? XRColor.FULL_ALPHA : this.getAlphaColor();
    }

    public int getExtraAlphaMask() {
        return this.alphaMask;
    }

    public boolean isTexturePaintActive() {
        return this.srcType == 1;
    }

    public boolean isSolidPaintActive() {
        return this.srcType == 0;
    }

    public XRColor getAlphaColor() {
        return this.alphaColor;
    }

    public XRBackend getBackend() {
        return this.con;
    }

    public float getExtraAlpha() {
        return this.validatedExtraAlpha;
    }

    public byte getCompRule() {
        return this.compRule;
    }

    public XRTextRenderer getTextRenderer() {
        return this.textRenderer;
    }

    public MaskTileManager getMaskBuffer() {
        return this.maskBuffer;
    }

    public XRMaskImage getMaskImage() {
        return this.maskImage;
    }
}

