/*
 * Copyright (c) 2012, 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_sq extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "Ora e Afrik\u00ebs Qendrore",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "Ora standarde e Mosk\u00ebs",
               "MSK",
               "Ora verore e Mosk\u00ebs",
               "MSD",
               "Ora e Mosk\u00ebs",
               "MT",
            };
        final String[] Japan = new String[] {
               "Ora standarde e Japonis\u00eb",
               "JST",
               "Ora verore e Japonis\u00eb",
               "JDT",
               "Ora e Japonis\u00eb",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "Ora standarde e Pakistanit",
               "PKT",
               "Ora verore e Pakistanit",
               "PKST",
               "Ora e Pakistanit",
               "PKT",
            };
        final String[] Taipei = new String[] {
               "Ora standarde e Tajpeit",
               "CST",
               "Ora verore e Tajpeit",
               "CDT",
               "Ora e Tajpeit",
               "CT",
            };
        final String[] Hovd = new String[] {
               "Ora standarde e Hovdit",
               "HOVT",
               "Ora verore e Hovdit",
               "HOVST",
               "Ora e Hovdit",
               "HOVT",
            };
        final String[] Magadan = new String[] {
               "Ora standarde e Magadanit",
               "MAGT",
               "Ora verore e Magadanit",
               "MAGST",
               "Ora e Magadanit",
               "MAGT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Ora standarde e Australis\u00eb Qendroro-Per\u00ebndimore",
               "ACWST",
               "Ora verore e Australis\u00eb Qendroro-Per\u00ebndimore",
               "ACWDT",
               "Ora e Australis\u00eb Qendroro-Per\u00ebndimore",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "Ora standarde e Europ\u00ebs Qendrore",
               "CET",
               "Ora verore e Europ\u00ebs Qendrore",
               "CEST",
               "Ora e Europ\u00ebs Qendrore",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "Ora standarde e Sakalinit",
               "SAKT",
               "Ora verore e Sakalinit",
               "SAKST",
               "Ora e Sakalinit",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "Ora standarde e Paraguait",
               "PYT",
               "Ora Verore e Paraguait",
               "PYST",
               "Ora e Paraguait",
               "PYT",
            };
        final String[] Acre = new String[] {
               "Ora standarde e Ejkrit [Ako]",
               "ACT",
               "Ora verore e Ejkrit [Ako]",
               "ACST",
               "Ora e Ejkrit [Ako]",
               "ACT",
            };
        final String[] Malaysia = new String[] {
               "Ora e Malajzis\u00eb",
               "MYT",
               "Malaysia Summer Time",
               "MYST",
               "Malaysia Time",
               "MYT",
            };
        final String[] America_Eastern = new String[] {
               "Ora standarde e SHBA-s\u00eb Lindore",
               "EST",
               "Ora verore e SHBA-s\u00eb Lindore",
               "EDT",
               "Ora e SHBA-s\u00eb Lindore",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "Ora standarde e Lord-Houit",
               "LHST",
               "Ora verore e Lord-Houit",
               "LHDT",
               "Ora e Lord-Houit",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "Ora standarde e Zeland\u00ebs s\u00eb Re",
               "NZST",
               "Ora verore e Zeland\u00ebs s\u00eb Re",
               "NZDT",
               "Ora e Zeland\u00ebs s\u00eb Re",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "Ora e Oqeanit Indian",
               "IOT",
               "Indian Ocean Territory Summer Time",
               "IOST",
               "Indian Ocean Territory Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "Ora standarde e Jakutskut",
               "YAKT",
               "Ora verore e Jakutskut",
               "YAKST",
               "Ora e Jakutskut",
               "YAKT",
            };
        final String[] Mauritius = new String[] {
               "Ora standarde e Mauritiusit",
               "MUT",
               "Ora verore e Mauritiusit",
               "MUST",
               "Ora e Mauritiusit",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "Ora e Afrik\u00ebs Lindore",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "Ora e Timorit Lindor",
               "TLT",
               "Timor-Leste Summer Time",
               "TLST",
               "Timor-Leste Time",
               "TLT",
            };
        final String[] Solomon = new String[] {
               "Ora e Ishujve Solomon\u00eb",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Kosrae = new String[] {
               "Ora e Kosr\u00ebs",
               "KOST",
               "Kosrae Summer Time",
               "KOSST",
               "Kosrae Time",
               "KOST",
            };
        final String[] Marshall_Islands = new String[] {
               "Ora e Ishujve Marshall\u00eb",
               "MHT",
               "Marshall Islands Summer Time",
               "MHST",
               "Marshall Islands Time",
               "MHT",
            };
        final String[] Europe_Eastern = new String[] {
               "Ora standarde e Europ\u00ebs Lindore",
               "EET",
               "Ora verore e Europ\u00ebs Lindore",
               "EEST",
               "Ora e Europ\u00ebs Lindore",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "Ora standarde e Njufaundlendit [Tok\u00ebs s\u00eb Re]",
               "NST",
               "Ora verore e Njufaundlendit [Tok\u00ebs s\u00eb Re]",
               "NDT",
               "Ora e Njufaundlendit [Tok\u00ebs s\u00eb Re]",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "Ora e Afganistanit",
               "AFT",
               "Afghanistan Summer Time",
               "AFST",
               "Afghanistan Time",
               "AFT",
            };
        final String[] Hong_Kong = new String[] {
               "Ora standarde e Hong-Kongut",
               "HKT",
               "Ora verore e Hong-Kongut",
               "HKST",
               "Ora e Hong-Kongut",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "Ora standarde e Argjentin\u00ebs Per\u00ebndimore",
               "ART",
               "Ora verore e Argjentin\u00ebs Per\u00ebndimore",
               "ARST",
               "Ora e Argjentin\u00ebs Per\u00ebndimore",
               "ART",
            };
        final String[] Atlantic = new String[] {
               "Ora standarde e Atlantikut",
               "AST",
               "Ora verore e Atlantikut",
               "ADT",
               "Ora e Atlantikut",
               "AT",
            };
        final String[] Ponape = new String[] {
               "Ora e Ponapeit",
               "PONT",
               "Pohnpei Summer Time",
               "PONST",
               "Ponape Time",
               "PONT",
            };
        final String[] Bolivia = new String[] {
               "Ora e Bolivis\u00eb",
               "BOT",
               "Bolivia Summer Time",
               "BOST",
               "Bolivia Time",
               "BOT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Ora standarde e Sh\u00ebn-Pier dhe Mikuelon",
               "PMST",
               "Ora verore e Sh\u00ebn-Pier dhe Mikuelon",
               "PMDT",
               "Ora e Sh\u00ebn-Pier dhe Mikuelon",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "Ora e Indokin\u00ebs",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] Yekaterinburg = new String[] {
               "Ora standarde e Ekaterinburgut",
               "YEKT",
               "Ora verore e Ekaterinburgut",
               "YEKST",
               "Ora e Ekaterinburgut",
               "YEKT",
            };
        final String[] Maldives = new String[] {
               "Ora e Maldivit",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Tahiti = new String[] {
               "Ora e Tahitit",
               "TAHT",
               "Tahiti Summer Time",
               "TAHST",
               "Tahiti Time",
               "TAHT",
            };
        final String[] Israel = new String[] {
               "Ora standarde e Izraelit",
               "IST",
               "Ora verore e Izraelit",
               "IDT",
               "Ora e Izraelit",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "Ora e Indonezis\u00eb Qendrore",
               "WITA",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "WITA",
            };
        final String[] Wallis = new String[] {
               "Ora e Uollisit dhe Futun\u00ebs",
               "WFT",
               "Wallis & Futuna Summer Time",
               "WFST",
               "Wallis & Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "Ora standarde e Afrik\u00ebs Jugore",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "Ora e Sjouit",
               "SYOT",
               "Syowa Summer Time",
               "SYOST",
               "Syowa Time",
               "SYOT",
            };
        final String[] Line_Islands = new String[] {
               "Ora e Ishujve Sporadik\u00eb Ekuatorial\u00eb",
               "LINT",
               "Line Is. Summer Time",
               "LINST",
               "Line Is. Time",
               "LINT",
            };
        final String[] Uzbekistan = new String[] {
               "Ora standarde e Uzbekistanit",
               "UZT",
               "Ora verore e Uzbekistanit",
               "UZST",
               "Ora e Uzbekistanit",
               "UZT",
            };
        final String[] Omsk = new String[] {
               "Ora standarde e Omskut",
               "OMST",
               "Ora verore e Omskut",
               "OMSST",
               "Ora e Omskut",
               "OMST",
            };
        final String[] Seychelles = new String[] {
               "Ora e Sishel\u00ebs",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] Uruguay = new String[] {
               "Ora standarde e Uruguait",
               "UYT",
               "Ora verore e Uruguait",
               "UYST",
               "Ora e Uruguait",
               "UYT",
            };
        final String[] Nepal = new String[] {
               "Ora e Nepalit",
               "NPT",
               "Nepal Summer Time",
               "NPST",
               "Nepal Time",
               "NPT",
            };
        final String[] Mongolia = new String[] {
               "Ora standarde e Ulan-Batorit",
               "ULAT",
               "Ora verore e Ulan-Batorit",
               "ULAST",
               "Ora e Ulan-Batorit",
               "ULAT",
            };
        final String[] America_Central = new String[] {
               "Ora standarde e SHBA-s\u00eb Qendrore",
               "CST",
               "Ora verore e SHBA-s\u00eb Qendrore",
               "CDT",
               "Ora e SHBA-s\u00eb Qendrore",
               "CT",
            };
        final String[] Truk = new String[] {
               "Ora e \u00c7ukut",
               "CHUT",
               "Chuuk Summer Time",
               "CHUST",
               "Chuuk Time",
               "CHUT",
            };
        final String[] Niue = new String[] {
               "Ora e Niues\u00eb",
               "NUT",
               "Niue Summer Time",
               "NUST",
               "Niue Time",
               "NUT",
            };
        final String[] Wake = new String[] {
               "Ora e Ishullit Uejk",
               "WAKT",
               "Wake Summer Time",
               "WAKST",
               "Wake Time",
               "WAKT",
            };
        final String[] Falkland = new String[] {
               "Ora standarde e Ishujve Folkland",
               "FKT",
               "Ora verore e Ishujve Folkland",
               "FKST",
               "Ora e Ishujve Folkland",
               "FKT",
            };
        final String[] Vanuatu = new String[] {
               "Ora standarde e Vanuatus\u00eb",
               "VUT",
               "Ora verore e Vanuatus\u00eb",
               "VUST",
               "Ora e Vanuatus\u00eb",
               "VUT",
            };
        final String[] Novosibirsk = new String[] {
               "Ora standarde e Novosibirskut",
               "NOVT",
               "Ora verore e Novosibirskut",
               "NOVST",
               "Ora e Novosibirskut",
               "NOVT",
            };
        final String[] Singapore = new String[] {
               "Ora e Singaporit",
               "SRET",
               "Srednekolymsk Daylight Time",
               "SREDT",
               "Srednekolymsk Time",
               "SRET",
            };
        final String[] Azores = new String[] {
               "Ora standarde e Azoreve",
               "AZOT",
               "Ora verore e Azoreve",
               "AZOST",
               "Ora e Azoreve",
               "AZOT",
            };
        final String[] Apia = new String[] {
               "Ora standarde e Apias",
               "WSST",
               "Ora verore e Apias",
               "WSDT",
               "Ora e Apias",
               "WST",
            };
        final String[] Bhutan = new String[] {
               "Ora e Butanit",
               "BTT",
               "Bhutan Summer Time",
               "BTST",
               "Bhutan Time",
               "BTT",
            };
        final String[] Suriname = new String[] {
               "Ora e Surinamit",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] Nauru = new String[] {
               "Ora e Naurus\u00eb",
               "NRT",
               "Nauru Summer Time",
               "NRST",
               "Nauru Time",
               "NRT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Ora standarde e Krasnojarskut",
               "KRAT",
               "Ora verore e Krasnojarskut",
               "KRAST",
               "Ora e Krasnojarskut",
               "KRAT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Ora e Kazakistanit Per\u00ebndimor",
               "AQTT",
               "Aqtau Summer Time",
               "AQTST",
               "Aqtau Time",
               "AQTT",
            };
        final String[] Myanmar = new String[] {
               "Ora e Mianmarit",
               "MMT",
               "Myanmar Summer Time",
               "MMST",
               "Myanmar Time",
               "MMT",
            };
        final String[] Christmas = new String[] {
               "Ora e Ishullit t\u00eb Krishtlindjeve",
               "CXT",
               "Christmas Island Summer Time",
               "CXST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "Ora standarde e Amazon\u00ebs",
               "AMT",
               "Ora verore e Amazon\u00ebs",
               "AMST",
               "Ora e Amazon\u00ebs",
               "AMT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Ora e Kazakistanit Lindor",
               "ALMT",
               "Alma-Ata Summer Time",
               "ALMST",
               "Alma-Ata Time",
               "ALMT",
            };
        final String[] Fiji = new String[] {
               "Ora standarde e Fixhit",
               "FJT",
               "Ora verore e Fixhit",
               "FJST",
               "Ora e Fixhit",
               "FJT",
            };
        final String[] Reunion = new String[] {
               "Ora e Reunionit",
               "RET",
               "Reunion Summer Time",
               "REST",
               "Reunion Time",
               "RET",
            };
        final String[] Cocos = new String[] {
               "Ora e Ishujve Kokos",
               "CCT",
               "Cocos Islands Summer Time",
               "CCST",
               "Cocos Islands Time",
               "CCT",
            };
        final String[] Chatham = new String[] {
               "Ora standarde e Katamit",
               "CHAST",
               "Ora verore e Katamit",
               "CHADT",
               "Ora e Katamit",
               "CHAT",
            };
        final String[] Vostok = new String[] {
               "Ora e Vostokut",
               "VOST",
               "Vostok Summer Time",
               "VOSST",
               "Vostok Time",
               "VOST",
            };
        final String[] Argentina = new String[] {
               "Ora standarde e Argjentin\u00ebs",
               "ART",
               "Ora verore e Argjentin\u00ebs",
               "ARST",
               "Ora e Argjentin\u00ebs",
               "ART",
            };
        final String[] Gambier = new String[] {
               "Ora e Gambierit",
               "GAMT",
               "Gambier Summer Time",
               "GAMST",
               "Gambier Time",
               "GAMT",
            };
        final String[] Kamchatka = new String[] {
               "Ora standarde e Petropavllovsk-Kam\u00e7atk\u00ebs",
               "PETT",
               "Ora verore e Petropavllovsk-Kam\u00e7atk\u00ebs",
               "PETST",
               "Ora e Petropavllovsk-Kam\u00e7atk\u00ebs",
               "PETT",
            };
        final String[] Tuvalu = new String[] {
               "Ora e Tuvalus\u00eb",
               "TVT",
               "Tuvalu Summer Time",
               "TVST",
               "Tuvalu Time",
               "TVT",
            };
        final String[] Galapagos = new String[] {
               "Ora e Galapagosit",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Macquarie = new String[] {
               "Ora e Ishullit Makuari",
               "MIST",
               "Macquarie Island Daylight Time",
               "MIDT",
               "Macquarie Island Time",
               "MIST",
            };
        final String[] Venezuela = new String[] {
               "Ora e Venezuel\u00ebs",
               "VET",
               "Venezuela Summer Time",
               "VEST",
               "Venezuela Time",
               "VET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Ora standarde e Ishujve Hauai-Aleutian",
               "HAST",
               "Ora verore e Ishujve Hauai-Aleutian",
               "HADT",
               "Ora e Ishujve Hauai-Aleutian",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "Ora standarde e Australis\u00eb Qendrore",
               "ACST",
               "Ora verore e Australis\u00eb Qendrore",
               "ACDT",
               "Ora e Australis\u00eb Qendrore",
               "ACT",
            };
        final String[] America_Pacific = new String[] {
               "Ora standarde amerikane e Bregut t\u00eb Paq\u00ebsorit",
               "PST",
               "Ora verore amerikane e Bregut t\u00eb Paq\u00ebsorit",
               "PDT",
               "Ora amerikane e Bregut t\u00eb Paq\u00ebsorit",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Ora e Ishujve Feniks",
               "PHOT",
               "Phoenix Is. Summer Time",
               "PHOST",
               "Phoenix Is. Time",
               "PHOT",
            };
        final String[] Turkmenistan = new String[] {
               "Ora standarde e Turkmenistanit",
               "TMT",
               "Ora verore e Turkmenistanit",
               "TMST",
               "Ora e Turkmenistanit",
               "TMT",
            };
        final String[] Europe_Western = new String[] {
               "Ora standarde e Europ\u00ebs Per\u00ebndimore",
               "WET",
               "Ora verore e Europ\u00ebs Per\u00ebndimore",
               "WEST",
               "Ora e Europ\u00ebs Per\u00ebndimore",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "Ora standarde e Kepit t\u00eb Gjelb\u00ebr",
               "CVT",
               "Ora verore e Kepit t\u00eb Gjelb\u00ebr",
               "CVST",
               "Ora e Kepit t\u00eb Gjelb\u00ebr",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "Ora e Ishullit Norfolk",
               "NFT",
               "Norfolk Summer Time",
               "NFST",
               "Norfolk Time",
               "NFT",
            };
        final String[] Guyana = new String[] {
               "Ora e Guajan\u00ebs",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Pitcairn = new String[] {
               "Ora e Pitkernit",
               "PST",
               "Pitcairn Daylight Time",
               "PDT",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "Ora e Rodher\u00ebs",
               "ROTT",
               "Rothera Summer Time",
               "ROTST",
               "Rothera Time",
               "ROTT",
            };
        final String[] Samoa = new String[] {
               "Ora standarde e Samoas",
               "SST",
               "Ora verore e Samoas",
               "SDT",
               "Ora e Samoas",
               "ST",
            };
        final String[] Palau = new String[] {
               "Ora e Palaut",
               "PWT",
               "Palau Summer Time",
               "PWST",
               "Palau Time",
               "PWT",
            };
        final String[] Europe_Further_Eastern = new String[] {
               "Ora e Lindjes s\u00eb Larg\u00ebt Europiane",
               "MSK",
               "Moscow Daylight Time",
               "MSD",
               "Moscow Time",
               "MT",
            };
        final String[] Azerbaijan = new String[] {
               "Ora standarde e Azerbajxhanit",
               "AZT",
               "Ora verore e Azerbajxhanit",
               "AZST",
               "Ora e Azerbajxhanit",
               "AZT",
            };
        final String[] Mawson = new String[] {
               "Ora e Mausonit",
               "MAWT",
               "Mawson Summer Time",
               "MAWST",
               "Mawson Time",
               "MAWT",
            };
        final String[] Mexico_Pacific = new String[] {
               "Ora standarde meksikane e Bregut t\u00eb Paq\u00ebsorit",
               "MST",
               "Ora verore meksikane e Bregut t\u00eb Paq\u00ebsorit",
               "MDT",
               "Ora meksikane e Bregut t\u00eb Paq\u00ebsorit",
               "MT",
            };
        final String[] Davis = new String[] {
               "Ora e Dejvisit",
               "DAVT",
               "Davis Summer Time",
               "DAVST",
               "Davis Time",
               "DAVT",
            };
        final String[] Cuba = new String[] {
               "Ora standarde e Kub\u00ebs",
               "CST",
               "Ora verore e Kub\u00ebs",
               "CDT",
               "Ora e Kub\u00ebs",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "Ora standarde e Afrik\u00ebs Per\u00ebndimore",
               "WAT",
               "Ora verore e Afrik\u00ebs Per\u00ebndimore",
               "WAST",
               "Ora e Afrik\u00ebs Per\u00ebndimore",
               "WAT",
            };
        final String[] GMT = new String[] {
               "Ora e Meridianit t\u00eb Grinui\u00e7it",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
            };
        final String[] Philippines = new String[] {
               "Ora standarde e Filipineve",
               "PHT",
               "Ora verore e Filipineve",
               "PHST",
               "Ora e Filipineve",
               "PHT",
            };
        final String[] French_Southern = new String[] {
               "Ora e Rajoneve Australiane dhe Antraktike Franceze",
               "TFT",
               "French Southern & Antarctic Lands Summer Time",
               "TFST",
               "French Southern & Antarctic Lands Time",
               "TFT",
            };
        final String[] South_Georgia = new String[] {
               "Ora e Gjeorgjis\u00eb s\u00eb Jugut",
               "GST",
               "South Georgia Daylight Time",
               "GDT",
               "South Georgia Time",
               "GT",
            };
        final String[] New_Caledonia = new String[] {
               "Ora standarde e Kaledonis\u00eb s\u00eb Re",
               "NCT",
               "Ora verore e Kaledonis\u00eb s\u00eb Re",
               "NCST",
               "Ora e Kaledonis\u00eb s\u00eb Re",
               "NCT",
            };
        final String[] Brunei = new String[] {
               "Ora e Brunei-Durasalamit",
               "BNT",
               "Brunei Summer Time",
               "BNST",
               "Brunei Time",
               "BNT",
            };
        final String[] Iran = new String[] {
               "Ora standarde e Iranit",
               "IRST",
               "Ora verore e Iranit",
               "IRDT",
               "Ora e Iranit",
               "IRT",
            };
        final String[] Easter = new String[] {
               "Ora standarde e Ishullit t\u00eb Pashk\u00ebs",
               "EAST",
               "Ora verore e Ishullit t\u00eb Pashk\u00ebs",
               "EASST",
               "Ora e Ishullit t\u00eb Pashk\u00ebs",
               "EAST",
            };
        final String[] Mexico_Northwest = new String[] {
               "Ora standarde e Meksik\u00ebs Veriper\u00ebndimore",
               "PST",
               "Ora verore e Meksik\u00ebs Veriper\u00ebndimore",
               "PDT",
               "Ora e Meksik\u00ebs Veriper\u00ebndimore",
               "PT",
            };
        final String[] DumontDUrville = new String[] {
               "Ora e Dumont-d\u2019Urvil\u00ebs",
               "DDUT",
               "Dumont-d'Urville Summer Time",
               "DDUST",
               "Dumont-d'Urville Time",
               "DDUT",
            };
        final String[] Tajikistan = new String[] {
               "Ora e Taxhikistanit",
               "TJT",
               "Tajikistan Summer Time",
               "TJST",
               "Tajikistan Time",
               "TJT",
            };
        final String[] Tonga = new String[] {
               "Ora standarde e Tong\u00ebs",
               "TOT",
               "Ora verore e Tong\u00ebs",
               "TOST",
               "Ora e Tong\u00ebs",
               "TOT",
            };
        final String[] Bangladesh = new String[] {
               "Ora standarde e Bangladeshit",
               "BDT",
               "Ora verore e Bangladeshit",
               "BDST",
               "Ora e Bangladeshit",
               "BDT",
            };
        final String[] Peru = new String[] {
               "Ora standarde e Perus\u00eb",
               "PET",
               "Ora verore e Perus\u00eb",
               "PEST",
               "Ora e Perus\u00eb",
               "PET",
            };
        final String[] Greenland_Western = new String[] {
               "Ora standarde e Grenland\u00ebs Per\u00ebndimore",
               "WGT",
               "Ora verore e Grenland\u00ebs Per\u00ebndimore",
               "WGST",
               "Ora e Grenland\u00ebs Per\u00ebndimore",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "Ora e Ekuadorit",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Greenland_Eastern = new String[] {
               "Ora standarde e Grenland\u00ebs Lindore",
               "EGT",
               "Ora verore e Grenland\u00ebs Lindore",
               "EGST",
               "Ora e Grenland\u00ebs Lindore",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "Ora e Gjirit",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Ora e Indonezis\u00eb Lindore",
               "WIT",
               "East Indonesia Summer Time",
               "EIST",
               "East Indonesia Time",
               "WIT",
            };
        final String[] Korea = new String[] {
               "Ora standarde koreane",
               "KST",
               "Ora verore koreane",
               "KDT",
               "Ora koreane",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "Ora standarde e Australis\u00eb Per\u00ebndimore",
               "AWST",
               "Ora verore e Australis\u00eb Per\u00ebndimore",
               "AWDT",
               "Ora e Australis\u00eb Per\u00ebndimore",
               "AWT",
            };
        final String[] Kyrgystan = new String[] {
               "Ora e Kirgistanit",
               "KGT",
               "Kirgizstan Summer Time",
               "KGST",
               "Kirgizstan Time",
               "KGT",
            };
        final String[] Indonesia_Western = new String[] {
               "Ora e Indonezis\u00eb Per\u00ebndimore",
               "WIB",
               "West Indonesia Summer Time",
               "WIST",
               "West Indonesia Time",
               "WIB",
            };
        final String[] Australia_Eastern = new String[] {
               "Ora standarde e Australis\u00eb Lindore",
               "AEST",
               "Ora verore e Australis\u00eb Lindore",
               "AEDT",
               "Ora e Australis\u00eb Lindore",
               "AET",
            };
        final String[] French_Guiana = new String[] {
               "Ora e Guajan\u00ebs Franceze",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Colombia = new String[] {
               "Ora standarde e Kolumbis\u00eb",
               "COT",
               "Ora verore e Kolumbis\u00eb",
               "COST",
               "Ora e Kolumbis\u00eb",
               "COT",
            };
        final String[] Chile = new String[] {
               "Ora standarde e Kilit",
               "CLT",
               "Ora verore e Kilit",
               "CLST",
               "Ora e Kilit",
               "CLT",
            };
        final String[] Gilbert_Islands = new String[] {
               "Ora e Ishujve Gilbert",
               "GILT",
               "Gilbert Is. Summer Time",
               "GILST",
               "Gilbert Is. Time",
               "GILT",
            };
        final String[] America_Mountain = new String[] {
               "Ora standarde amerikane e Brezit Malor",
               "MST",
               "Ora verore amerikane e Brezit Malor",
               "MDT",
               "Ora amerikane e Brezit Malor",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "Ora e Ishujve Markez\u00eb",
               "MART",
               "Marquesas Summer Time",
               "MARST",
               "Marquesas Time",
               "MART",
            };
        final String[] Arabian = new String[] {
               "Ora standarde arabe",
               "AST",
               "Ora verore arabe",
               "ADT",
               "Ora arabe",
               "AT",
            };
        final String[] Alaska = new String[] {
               "Ora standarde e Alask\u00ebs",
               "AKST",
               "Ora verore e Alsask\u00ebs",
               "AKDT",
               "Ora e Alask\u00ebs",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "Ora standarde e Vladivostokut",
               "VLAT",
               "Ora verore e Vladivostokut",
               "VLAST",
               "Ora e Vladivostokut",
               "VLAT",
            };
        final String[] Chamorro = new String[] {
               "Ora e Kamorros",
               "ChST",
               "Chamorro Daylight Time",
               "ChDT",
               "Chamorro Time",
               "ChT",
            };
        final String[] Irkutsk = new String[] {
               "Ora standarde e Irkutskut",
               "IRKT",
               "Ora verore e Irkutskut",
               "IRKST",
               "Ora e Irkutskut",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "Ora standarde e Gjeorgjis\u00eb",
               "GET",
               "Ora verore e Gjeorgjis\u00eb",
               "GEST",
               "Ora e Gjeorgjis\u00eb",
               "GET",
            };
        final String[] Tokelau = new String[] {
               "Ora e Tokelaut",
               "TKT",
               "Tokelau Summer Time",
               "TKST",
               "Tokelau Time",
               "TKT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Ora e Papua-Guines\u00eb s\u00eb Re",
               "PGT",
               "Papua New Guinea Summer Time",
               "PGST",
               "Papua New Guinea Time",
               "PGT",
            };
        final String[] Noronha = new String[] {
               "Ora standarde e Fernando-de-Noronj\u00ebs",
               "FNT",
               "Ora verore e Fernando-de-Noronj\u00ebs",
               "FNST",
               "Ora e Fernando-de-Noronj\u00ebs",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "Ora standarde e \u00c7oibalsanit",
               "CHOT",
               "Ora verore e \u00c7oibalsanit",
               "CHOST",
               "Ora e \u00c7oibalsanit",
               "CHOT",
            };
        final String[] Brasilia = new String[] {
               "Ora standarde e Brasil\u00ebs",
               "BRT",
               "Ora verore e Brasil\u00ebs",
               "BRST",
               "Ora e Brasil\u00ebs",
               "BRT",
            };
        final String[] China = new String[] {
               "Ora standarde e Kin\u00ebs",
               "CST",
               "Ora verore e Kin\u00ebs",
               "CDT",
               "Ora e Kin\u00ebs",
               "CT",
            };
        final String[] Armenia = new String[] {
               "Ora standarde e Armenis\u00eb",
               "AMT",
               "Ora verore e Armenis\u00eb",
               "AMST",
               "Ora e Armenis\u00eb",
               "AMT",
            };
        final String[] Samara = new String[] {
               "Ora standarde e Samar\u00ebs",
               "SAMT",
               "Ora verore e Samar\u00ebs",
               "SAMST",
               "Ora e Samar\u00ebs",
               "SAMT",
            };
        final String[] India = new String[] {
               "Ora standarde e Indis\u00eb",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "Ora standarde e Ishujve Kuk",
               "CKT",
               "Ora verore e Ishujve Kuk",
               "CKHST",
               "Ora e Ishujve Kuk",
               "CKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "Ora e Meridianit t\u00eb Grinui\u00e7it",
                    "GMT",
                    "Ora verore britanike",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Eirunepe", Acre },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", Atlantic },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", New_Zealand },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Europe/Samara", Samara },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Ora e Meridianit t\u00eb Grinui\u00e7it",
                    "GMT",
                    "Ora verore e Irland\u00ebs",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Further_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Acre },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "Asia/Srednekolymsk", Singapore },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
