/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.exporter.plugin;

import javax.swing.JPanel;
import org.gephi.io.exporter.plugin.ExporterGDF;
import org.gephi.io.exporter.spi.Exporter;
import org.gephi.io.exporter.spi.ExporterUI;
import org.gephi.ui.exporter.plugin.UIExporterGDFPanel;
import org.openide.util.NbBundle;

public class UIExporterGDF
implements ExporterUI {
    private UIExporterGDFPanel panel;
    private ExporterGDF exporterGDF;
    private ExporterGDFSettings settings = new ExporterGDFSettings();

    public void setup(Exporter exporter) {
        this.exporterGDF = (ExporterGDF)exporter;
        this.settings.load(this.exporterGDF);
        this.panel.setup(this.exporterGDF);
    }

    public void unsetup(boolean update) {
        if (update) {
            this.panel.unsetup(this.exporterGDF);
            this.settings.save(this.exporterGDF);
        }
        this.panel = null;
        this.exporterGDF = null;
    }

    public JPanel getPanel() {
        this.panel = new UIExporterGDFPanel();
        return this.panel;
    }

    public boolean isUIForExporter(Exporter exporter) {
        return exporter instanceof ExporterGDF;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(UIExporterGDF.class, (String)"UIExporterGDF.name");
    }

    private static class ExporterGDFSettings {
        private boolean normalize = false;
        private boolean simpleQuotes = false;
        private boolean useQuotes = true;
        private boolean exportColors = true;
        private boolean exportPosition = true;
        private boolean exportAttributes = true;
        private boolean exportVisibility = false;

        private ExporterGDFSettings() {
        }

        private void save(ExporterGDF exporterGDF) {
            this.normalize = exporterGDF.isNormalize();
            this.simpleQuotes = exporterGDF.isSimpleQuotes();
            this.useQuotes = exporterGDF.isUseQuotes();
            this.exportColors = exporterGDF.isExportColors();
            this.exportPosition = exporterGDF.isExportPosition();
            this.exportAttributes = exporterGDF.isExportAttributes();
            this.exportVisibility = exporterGDF.isExportVisibility();
        }

        private void load(ExporterGDF exporterGDF) {
            exporterGDF.setNormalize(this.normalize);
            exporterGDF.setSimpleQuotes(this.simpleQuotes);
            exporterGDF.setUseQuotes(this.useQuotes);
            exporterGDF.setExportColors(this.exportColors);
            exporterGDF.setExportAttributes(this.exportAttributes);
            exporterGDF.setExportPosition(this.exportPosition);
            exporterGDF.setExportVisibility(this.exportVisibility);
        }
    }
}

