/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;

public class ResolvedFilesCollectingVisitor
implements ArtifactVisitor {
    private final Set<File> files = Sets.newLinkedHashSet();
    private final Set<Throwable> failures = Sets.newLinkedHashSet();

    @Override
    public void visitArtifact(AttributeContainer variant, ResolvableArtifact artifact) {
        try {
            File file = artifact.getFile();
            this.files.add(file);
        }
        catch (Throwable t) {
            this.failures.add(t);
        }
    }

    @Override
    public boolean requireArtifactFiles() {
        return true;
    }

    @Override
    public void visitFailure(Throwable failure) {
        this.failures.add(failure);
    }

    @Override
    public boolean includeFiles() {
        return true;
    }

    @Override
    public void visitFile(ComponentArtifactIdentifier artifactIdentifier, AttributeContainer variant, File file) {
        this.files.add(file);
    }

    public Set<File> getFiles() {
        return this.files;
    }

    public Collection<Throwable> getFailures() {
        return this.failures;
    }
}

