/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.projectmodule;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentProvider;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentRegistry;
import org.gradle.internal.component.local.model.LocalComponentArtifactMetadata;
import org.gradle.internal.component.local.model.LocalComponentMetadata;

public class DefaultLocalComponentRegistry
implements LocalComponentRegistry {
    private final List<LocalComponentProvider> providers;
    private final ConcurrentMap<ProjectComponentIdentifier, LocalComponentMetadata> projects = new ConcurrentHashMap<ProjectComponentIdentifier, LocalComponentMetadata>();

    public DefaultLocalComponentRegistry(List<LocalComponentProvider> providers) {
        this.providers = providers;
    }

    @Override
    public LocalComponentMetadata getComponent(ProjectComponentIdentifier projectIdentifier) {
        LocalComponentMetadata metaData = (LocalComponentMetadata)this.projects.get(projectIdentifier);
        if (metaData != null) {
            return metaData;
        }
        for (LocalComponentProvider provider : this.providers) {
            LocalComponentMetadata componentMetaData = provider.getComponent(projectIdentifier);
            if (componentMetaData == null) continue;
            this.projects.putIfAbsent(projectIdentifier, componentMetaData);
            return componentMetaData;
        }
        return null;
    }

    @Override
    public Iterable<LocalComponentArtifactMetadata> getAdditionalArtifacts(ProjectComponentIdentifier project) {
        for (LocalComponentProvider provider : this.providers) {
            Iterable<LocalComponentArtifactMetadata> artifacts = provider.getAdditionalArtifacts(project);
            if (artifacts == null) continue;
            return artifacts;
        }
        return Collections.emptyList();
    }

    @Override
    public LocalComponentArtifactMetadata findAdditionalArtifact(ProjectComponentIdentifier project, String type) {
        for (LocalComponentArtifactMetadata artifactMetaData : this.getAdditionalArtifacts(project)) {
            if (!artifactMetaData.getName().getType().equals(type)) continue;
            return artifactMetaData;
        }
        return null;
    }
}

