/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories;

import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.repositories.AuthenticationContainer;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.internal.ExperimentalFeatures;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ModuleVersionPublisher;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ConfiguredModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.MetaDataParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.ModuleMetadataParser;
import org.gradle.api.internal.artifacts.repositories.AbstractAuthenticationSupportedRepository;
import org.gradle.api.internal.artifacts.repositories.PublicationAwareRepository;
import org.gradle.api.internal.artifacts.repositories.ResolutionAwareRepository;
import org.gradle.api.internal.artifacts.repositories.resolver.MavenResolver;
import org.gradle.api.internal.artifacts.repositories.transport.RepositoryTransport;
import org.gradle.api.internal.artifacts.repositories.transport.RepositoryTransportFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.MutableMavenModuleResolveMetadata;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.resource.local.FileResourceRepository;
import org.gradle.internal.resource.local.FileStore;
import org.gradle.internal.resource.local.LocallyAvailableResourceFinder;

public class DefaultMavenArtifactRepository
extends AbstractAuthenticationSupportedRepository
implements MavenArtifactRepository,
ResolutionAwareRepository,
PublicationAwareRepository {
    private final Transformer<String, MavenArtifactRepository> describer;
    private final FileResolver fileResolver;
    private final RepositoryTransportFactory transportFactory;
    private Object url;
    private List<Object> additionalUrls = new ArrayList<Object>();
    private final LocallyAvailableResourceFinder<ModuleComponentArtifactMetadata> locallyAvailableResourceFinder;
    private final FileStore<ModuleComponentArtifactIdentifier> artifactFileStore;
    private final MetaDataParser<MutableMavenModuleResolveMetadata> pomParser;
    private final ModuleMetadataParser metadataParser;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final FileStore<String> resourcesFileStore;
    private final FileResourceRepository fileResourceRepository;
    private final ExperimentalFeatures experimentalFeatures;

    public DefaultMavenArtifactRepository(FileResolver fileResolver, RepositoryTransportFactory transportFactory, LocallyAvailableResourceFinder<ModuleComponentArtifactMetadata> locallyAvailableResourceFinder, Instantiator instantiator, FileStore<ModuleComponentArtifactIdentifier> artifactFileStore, MetaDataParser<MutableMavenModuleResolveMetadata> pomParser, ModuleMetadataParser metadataParser, AuthenticationContainer authenticationContainer, ImmutableModuleIdentifierFactory moduleIdentifierFactory, FileStore<String> resourcesFileStore, FileResourceRepository fileResourceRepository, ExperimentalFeatures experimentalFeatures) {
        this(new DefaultDescriber(), fileResolver, transportFactory, locallyAvailableResourceFinder, instantiator, artifactFileStore, pomParser, metadataParser, authenticationContainer, moduleIdentifierFactory, resourcesFileStore, fileResourceRepository, experimentalFeatures);
    }

    public DefaultMavenArtifactRepository(Transformer<String, MavenArtifactRepository> describer, FileResolver fileResolver, RepositoryTransportFactory transportFactory, LocallyAvailableResourceFinder<ModuleComponentArtifactMetadata> locallyAvailableResourceFinder, Instantiator instantiator, FileStore<ModuleComponentArtifactIdentifier> artifactFileStore, MetaDataParser<MutableMavenModuleResolveMetadata> pomParser, ModuleMetadataParser metadataParser, AuthenticationContainer authenticationContainer, ImmutableModuleIdentifierFactory moduleIdentifierFactory, FileStore<String> resourcesFileStore, FileResourceRepository fileResourceRepository, ExperimentalFeatures experimentalFeatures) {
        super(instantiator, authenticationContainer);
        this.describer = describer;
        this.fileResolver = fileResolver;
        this.transportFactory = transportFactory;
        this.locallyAvailableResourceFinder = locallyAvailableResourceFinder;
        this.artifactFileStore = artifactFileStore;
        this.pomParser = pomParser;
        this.metadataParser = metadataParser;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.resourcesFileStore = resourcesFileStore;
        this.fileResourceRepository = fileResourceRepository;
        this.experimentalFeatures = experimentalFeatures;
    }

    @Override
    public String getDisplayName() {
        return (String)this.describer.transform((Object)this);
    }

    public URI getUrl() {
        return this.url == null ? null : this.fileResolver.resolveUri(this.url);
    }

    public void setUrl(URI url) {
        this.url = url;
    }

    public void setUrl(Object url) {
        this.url = url;
    }

    public Set<URI> getArtifactUrls() {
        LinkedHashSet<URI> result = new LinkedHashSet<URI>();
        for (Object additionalUrl : this.additionalUrls) {
            result.add(this.fileResolver.resolveUri(additionalUrl));
        }
        return result;
    }

    public void artifactUrls(Object ... urls) {
        this.additionalUrls.addAll(Lists.newArrayList((Object[])urls));
    }

    public void setArtifactUrls(Set<URI> urls) {
        this.setArtifactUrls((Iterable<?>)urls);
    }

    public void setArtifactUrls(Iterable<?> urls) {
        this.additionalUrls = Lists.newArrayList(urls);
    }

    protected boolean isPreferGradleMetadata() {
        return this.experimentalFeatures.isEnabled();
    }

    @Override
    public ModuleVersionPublisher createPublisher() {
        return this.createRealResolver();
    }

    @Override
    public ConfiguredModuleComponentRepository createResolver() {
        return this.createRealResolver();
    }

    protected MavenResolver createRealResolver() {
        URI rootUri = this.getUrl();
        if (rootUri == null) {
            throw new InvalidUserDataException("You must specify a URL for a Maven repository.");
        }
        MavenResolver resolver = this.createResolver(rootUri);
        for (URI repoUrl : this.getArtifactUrls()) {
            resolver.addArtifactLocation(repoUrl);
        }
        return resolver;
    }

    private MavenResolver createResolver(URI rootUri) {
        RepositoryTransport transport = this.getTransport(rootUri.getScheme());
        return new MavenResolver(this.getName(), rootUri, transport, this.locallyAvailableResourceFinder, this.artifactFileStore, this.pomParser, this.metadataParser, this.moduleIdentifierFactory, transport.getResourceAccessor(), this.resourcesFileStore, this.fileResourceRepository, this.isPreferGradleMetadata());
    }

    protected MetaDataParser<MutableMavenModuleResolveMetadata> getPomParser() {
        return this.pomParser;
    }

    protected ModuleMetadataParser getMetadataParser() {
        return this.metadataParser;
    }

    protected FileStore<ModuleComponentArtifactIdentifier> getArtifactFileStore() {
        return this.artifactFileStore;
    }

    protected RepositoryTransport getTransport(String scheme) {
        return this.transportFactory.createTransport(scheme, this.getName(), this.getConfiguredAuthentication());
    }

    protected LocallyAvailableResourceFinder<ModuleComponentArtifactMetadata> getLocallyAvailableResourceFinder() {
        return this.locallyAvailableResourceFinder;
    }

    private static class DefaultDescriber
    implements Transformer<String, MavenArtifactRepository> {
        private DefaultDescriber() {
        }

        public String transform(MavenArtifactRepository repository) {
            URI url = repository.getUrl();
            if (url == null) {
                return repository.getName();
            }
            return repository.getName() + '(' + url + ')';
        }
    }
}

