/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.io.Files;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.Buildable;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.DefaultResolvedArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.BrokenResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.BuildDependenciesVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariantSet;
import org.gradle.api.internal.artifacts.transform.AmbiguousTransformException;
import org.gradle.api.internal.artifacts.transform.ArtifactTransforms;
import org.gradle.api.internal.artifacts.transform.ConsumerVariantMatchResult;
import org.gradle.api.internal.artifacts.transform.VariantAttributeMatchingCache;
import org.gradle.api.internal.artifacts.transform.VariantSelector;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.Pair;
import org.gradle.internal.component.AmbiguousVariantSelectionException;
import org.gradle.internal.component.NoMatchingVariantSelectionException;
import org.gradle.internal.component.VariantSelectionException;
import org.gradle.internal.component.local.model.ComponentFileArtifactIdentifier;
import org.gradle.internal.component.model.AttributeMatcher;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.operations.BuildOperation;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.progress.BuildOperationDescriptor;

public class DefaultArtifactTransforms
implements ArtifactTransforms {
    private final VariantAttributeMatchingCache matchingCache;
    private final AttributesSchemaInternal schema;

    public DefaultArtifactTransforms(VariantAttributeMatchingCache matchingCache, AttributesSchemaInternal schema) {
        this.matchingCache = matchingCache;
        this.schema = schema;
    }

    @Override
    public VariantSelector variantSelector(AttributeContainerInternal consumerAttributes, boolean allowNoMatchingVariants) {
        return new AttributeMatchingVariantSelector(this.matchingCache, this.schema, (AttributeContainerInternal)consumerAttributes.asImmutable(), allowNoMatchingVariants);
    }

    private static class ArtifactTransformingVisitor
    implements ArtifactVisitor {
        private final ArtifactVisitor visitor;
        private final AttributeContainerInternal target;
        private final Map<ResolvableArtifact, TransformArtifactOperation> artifactResults;
        private final Map<File, TransformFileOperation> fileResults;

        private ArtifactTransformingVisitor(ArtifactVisitor visitor, AttributeContainerInternal target, Map<ResolvableArtifact, TransformArtifactOperation> artifactResults, Map<File, TransformFileOperation> fileResults) {
            this.visitor = visitor;
            this.target = target;
            this.artifactResults = artifactResults;
            this.fileResults = fileResults;
        }

        @Override
        public void visitArtifact(AttributeContainer variant, ResolvableArtifact artifact) {
            TransformArtifactOperation operation = this.artifactResults.get(artifact);
            if (operation.failure != null) {
                this.visitor.visitFailure(operation.failure);
                return;
            }
            ResolvedArtifact sourceArtifact = artifact.toPublicView();
            List transformedFiles = operation.result;
            TaskDependency buildDependencies = ((Buildable)artifact).getBuildDependencies();
            for (File output : transformedFiles) {
                IvyArtifactName artifactName = this.getArtifactName(sourceArtifact, output);
                ComponentFileArtifactIdentifier newId = new ComponentFileArtifactIdentifier(sourceArtifact.getId().getComponentIdentifier(), artifactName.toString());
                DefaultResolvedArtifact resolvedArtifact = new DefaultResolvedArtifact(sourceArtifact.getModuleVersion().getId(), artifactName, (ComponentArtifactIdentifier)newId, buildDependencies, output);
                this.visitor.visitArtifact((AttributeContainer)this.target, resolvedArtifact);
            }
        }

        private IvyArtifactName getArtifactName(ResolvedArtifact sourceArtifact, File output) {
            String name = Files.getNameWithoutExtension((String)output.getName());
            String extension = Files.getFileExtension((String)output.getName());
            String classifier = sourceArtifact.getClassifier();
            return new DefaultIvyArtifactName(name, extension, extension, classifier);
        }

        @Override
        public void visitFailure(Throwable failure) {
            this.visitor.visitFailure(failure);
        }

        @Override
        public boolean includeFiles() {
            return this.visitor.includeFiles();
        }

        @Override
        public boolean requireArtifactFiles() {
            return this.visitor.requireArtifactFiles();
        }

        @Override
        public void visitFile(ComponentArtifactIdentifier artifactIdentifier, AttributeContainer variant, File file) {
            TransformFileOperation operation = this.fileResults.get(file);
            if (operation.failure != null) {
                this.visitor.visitFailure(operation.failure);
                return;
            }
            List result = operation.result;
            for (File outputFile : result) {
                this.visitor.visitFile(new ComponentFileArtifactIdentifier(artifactIdentifier.getComponentIdentifier(), outputFile.getName()), (AttributeContainer)this.target, outputFile);
            }
        }
    }

    private static class TransformFileOperation
    implements RunnableBuildOperation {
        private final File file;
        private final Transformer<List<File>, File> transform;
        private Throwable failure;
        private List<File> result;

        TransformFileOperation(File file, Transformer<List<File>, File> transform) {
            this.file = file;
            this.transform = transform;
        }

        public void run(BuildOperationContext context) {
            try {
                this.result = (List)this.transform.transform((Object)this.file);
            }
            catch (Throwable t) {
                this.failure = t;
            }
        }

        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName((String)("Apply " + this.transform + " to " + this.file));
        }
    }

    private static class TransformArtifactOperation
    implements RunnableBuildOperation {
        private final ResolvableArtifact artifact;
        private final Transformer<List<File>, File> transform;
        private Throwable failure;
        private List<File> result;

        TransformArtifactOperation(ResolvableArtifact artifact, Transformer<List<File>, File> transform) {
            this.artifact = artifact;
            this.transform = transform;
        }

        public void run(BuildOperationContext context) {
            try {
                this.result = (List)this.transform.transform((Object)this.artifact.getFile());
            }
            catch (Throwable t) {
                this.failure = t;
            }
        }

        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName((String)("Apply " + this.transform + " to " + this.artifact));
        }
    }

    private static class ConsumerProvidedResolvedVariant
    implements ResolvedArtifactSet {
        private final ResolvedArtifactSet delegate;
        private final AttributeContainerInternal attributes;
        private final Transformer<List<File>, File> transform;

        ConsumerProvidedResolvedVariant(ResolvedArtifactSet delegate, AttributeContainerInternal target, Transformer<List<File>, File> transform) {
            this.delegate = delegate;
            this.attributes = target;
            this.transform = transform;
        }

        @Override
        public ResolvedArtifactSet.Completion startVisit(BuildOperationQueue<RunnableBuildOperation> actions, ResolvedArtifactSet.AsyncArtifactListener listener) {
            ConcurrentHashMap<ResolvableArtifact, TransformArtifactOperation> artifactResults = new ConcurrentHashMap<ResolvableArtifact, TransformArtifactOperation>();
            ConcurrentHashMap<File, TransformFileOperation> fileResults = new ConcurrentHashMap<File, TransformFileOperation>();
            ResolvedArtifactSet.Completion result = this.delegate.startVisit(actions, new TransformingAsyncArtifactListener(artifactResults, actions, this.transform, listener, fileResults));
            return new TransformingResult(result, artifactResults, fileResults);
        }

        @Override
        public void collectBuildDependencies(BuildDependenciesVisitor visitor) {
            this.delegate.collectBuildDependencies(visitor);
        }

        private class TransformingResult
        implements ResolvedArtifactSet.Completion {
            private final ResolvedArtifactSet.Completion result;
            private final Map<ResolvableArtifact, TransformArtifactOperation> artifactResults;
            private final Map<File, TransformFileOperation> fileResults;

            TransformingResult(ResolvedArtifactSet.Completion result, Map<ResolvableArtifact, TransformArtifactOperation> artifactResults, Map<File, TransformFileOperation> fileResults) {
                this.result = result;
                this.artifactResults = artifactResults;
                this.fileResults = fileResults;
            }

            @Override
            public void visit(ArtifactVisitor visitor) {
                this.result.visit(new ArtifactTransformingVisitor(visitor, ConsumerProvidedResolvedVariant.this.attributes, this.artifactResults, this.fileResults));
            }
        }

        private static class TransformingAsyncArtifactListener
        implements ResolvedArtifactSet.AsyncArtifactListener {
            private final Map<ResolvableArtifact, TransformArtifactOperation> artifactResults;
            private final BuildOperationQueue<RunnableBuildOperation> actions;
            private final ResolvedArtifactSet.AsyncArtifactListener listener;
            private final Map<File, TransformFileOperation> fileResults;
            private final Transformer<List<File>, File> transform;

            TransformingAsyncArtifactListener(Map<ResolvableArtifact, TransformArtifactOperation> artifactResults, BuildOperationQueue<RunnableBuildOperation> actions, Transformer<List<File>, File> transform, ResolvedArtifactSet.AsyncArtifactListener listener, Map<File, TransformFileOperation> fileResults) {
                this.artifactResults = artifactResults;
                this.actions = actions;
                this.transform = transform;
                this.listener = listener;
                this.fileResults = fileResults;
            }

            @Override
            public void artifactAvailable(ResolvableArtifact artifact) {
                TransformArtifactOperation operation = new TransformArtifactOperation(artifact, this.transform);
                this.artifactResults.put(artifact, operation);
                this.actions.add((BuildOperation)operation);
            }

            @Override
            public boolean requireArtifactFiles() {
                return true;
            }

            @Override
            public boolean includeFileDependencies() {
                return this.listener.includeFileDependencies();
            }

            @Override
            public void fileAvailable(File file) {
                TransformFileOperation operation = new TransformFileOperation(file, this.transform);
                this.fileResults.put(file, operation);
                this.actions.add((BuildOperation)operation);
            }
        }
    }

    private static class AttributeMatchingVariantSelector
    implements VariantSelector {
        private final VariantAttributeMatchingCache matchingCache;
        private final AttributesSchemaInternal schema;
        private final AttributeContainerInternal requested;
        private final boolean ignoreWhenNoMatches;

        private AttributeMatchingVariantSelector(VariantAttributeMatchingCache matchingCache, AttributesSchemaInternal schema, AttributeContainerInternal requested, boolean ignoreWhenNoMatches) {
            this.matchingCache = matchingCache;
            this.schema = schema;
            this.requested = requested;
            this.ignoreWhenNoMatches = ignoreWhenNoMatches;
        }

        public String toString() {
            return "Variant selector for " + this.requested;
        }

        @Override
        public ResolvedArtifactSet select(ResolvedVariantSet producer) {
            try {
                return this.doSelect(producer);
            }
            catch (VariantSelectionException t) {
                return new BrokenResolvedArtifactSet(t);
            }
            catch (Throwable t) {
                return new BrokenResolvedArtifactSet(VariantSelectionException.selectionFailed(producer, t));
            }
        }

        private ResolvedArtifactSet doSelect(ResolvedVariantSet producer) {
            AttributeMatcher matcher = this.schema.withProducer(producer.getSchema());
            List<ResolvedVariant> matches = matcher.matches(producer.getVariants(), this.requested);
            if (matches.size() == 1) {
                return matches.get(0).getArtifacts();
            }
            if (matches.size() > 1) {
                throw new AmbiguousVariantSelectionException(producer.asDescribable().getDisplayName(), this.requested, matches, matcher);
            }
            ArrayList<Pair<ResolvedVariant, ConsumerVariantMatchResult.ConsumerVariant>> candidates = new ArrayList<Pair<ResolvedVariant, ConsumerVariantMatchResult.ConsumerVariant>>();
            for (ResolvedVariant variant : producer.getVariants()) {
                ImmutableAttributes variantAttributes = variant.getAttributes().asImmutable();
                ConsumerVariantMatchResult matchResult = new ConsumerVariantMatchResult();
                this.matchingCache.collectConsumerVariants((AttributeContainerInternal)variantAttributes, this.requested, matchResult);
                for (ConsumerVariantMatchResult.ConsumerVariant consumerVariant : matchResult.getMatches()) {
                    candidates.add((Pair<ResolvedVariant, ConsumerVariantMatchResult.ConsumerVariant>)Pair.of((Object)variant, (Object)consumerVariant));
                }
            }
            if (candidates.size() == 1) {
                Pair result = (Pair)candidates.get(0);
                return new ConsumerProvidedResolvedVariant(((ResolvedVariant)result.getLeft()).getArtifacts(), ((ConsumerVariantMatchResult.ConsumerVariant)result.getRight()).attributes, ((ConsumerVariantMatchResult.ConsumerVariant)result.getRight()).transformer);
            }
            if (!candidates.isEmpty()) {
                throw new AmbiguousTransformException(producer.asDescribable().getDisplayName(), this.requested, candidates);
            }
            if (this.ignoreWhenNoMatches) {
                return ResolvedArtifactSet.EMPTY;
            }
            throw new NoMatchingVariantSelectionException(producer.asDescribable().getDisplayName(), this.requested, producer.getVariants(), matcher);
        }
    }
}

