/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transfer;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.resource.transfer.ResourceOperation;

public class AbstractProgressLoggingHandler {
    protected final ProgressLoggerFactory progressLoggerFactory;

    public AbstractProgressLoggingHandler(ProgressLoggerFactory progressLoggerFactory) {
        this.progressLoggerFactory = progressLoggerFactory;
    }

    protected ResourceOperation createResourceOperation(URI resource, ResourceOperation.Type operationType, Class loggingClazz, long contentLength) {
        ProgressLogger progressLogger = this.progressLoggerFactory.newOperation(loggingClazz != null ? loggingClazz : this.getClass());
        String description = this.createDescription(operationType, resource);
        progressLogger.setDescription(description);
        progressLogger.setLoggingHeader(description);
        progressLogger.started();
        String resourceName = this.createShortDescription(resource);
        return new ResourceOperation(progressLogger, operationType, contentLength, resourceName);
    }

    private String createDescription(ResourceOperation.Type operationType, URI resource) {
        return operationType.getCapitalized() + " " + resource.toString();
    }

    private String createShortDescription(URI resource) {
        String rawUri = resource.toString();
        int lastSlash = rawUri.lastIndexOf(47);
        return lastSlash == -1 ? rawUri : rawUri.substring(lastSlash + 1);
    }

    protected static class ProgressLoggingInputStream
    extends InputStream {
        private final InputStream inputStream;
        private final ResourceOperation resourceOperation;

        public ProgressLoggingInputStream(InputStream inputStream, ResourceOperation resourceOperation) {
            this.inputStream = inputStream;
            this.resourceOperation = resourceOperation;
        }

        @Override
        public void close() throws IOException {
            this.inputStream.close();
        }

        @Override
        public int read() throws IOException {
            int result = this.inputStream.read();
            if (result >= 0) {
                this.doLogProgress(1L);
            }
            return result;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int read = this.inputStream.read(b, off, len);
            if (read > 0) {
                this.doLogProgress(read);
            }
            return read;
        }

        private void doLogProgress(long numberOfBytes) {
            this.resourceOperation.logProcessedBytes(numberOfBytes);
        }
    }
}

