/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.text;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.internal.logging.text.AbstractStyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutput;

public class BufferingStyledTextOutput
extends AbstractStyledTextOutput {
    private final List<Action<StyledTextOutput>> events = new ArrayList<Action<StyledTextOutput>>();
    private boolean hasContent;

    public void writeTo(StyledTextOutput output) {
        for (Action<StyledTextOutput> event : this.events) {
            event.execute((Object)output);
        }
        this.events.clear();
    }

    protected void doStyleChange(StyledTextOutput.Style style) {
        if (!this.events.isEmpty() && this.events.get(this.events.size() - 1) instanceof ChangeStyleAction) {
            this.events.remove(this.events.size() - 1);
        }
        this.events.add(new ChangeStyleAction(style));
    }

    protected void doAppend(final String text) {
        if (text.length() == 0) {
            return;
        }
        this.hasContent = true;
        this.events.add(new Action<StyledTextOutput>(){

            public void execute(StyledTextOutput styledTextOutput) {
                styledTextOutput.text(text);
            }
        });
    }

    public boolean getHasContent() {
        return this.hasContent;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChangeStyleAction
    implements Action<StyledTextOutput> {
        private final StyledTextOutput.Style style;

        public ChangeStyleAction(StyledTextOutput.Style style) {
            this.style = style;
        }

        public void execute(StyledTextOutput styledTextOutput) {
            styledTextOutput.style(this.style);
        }
    }
}

