/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.msvcpp;

import java.io.File;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.WindowsKitComponent;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.WindowsSdk;
import org.gradle.util.VersionNumber;

public class WindowsKitWindowsSdk
extends WindowsKitComponent
implements WindowsSdk {
    public WindowsKitWindowsSdk(File baseDir, VersionNumber version, String name) {
        super(baseDir, version, name);
    }

    @Override
    public File getResourceCompiler(NativePlatformInternal platform) {
        return new File(this.getBinDir(platform), "rc.exe");
    }

    @Override
    public File getBinDir(NativePlatformInternal platform) {
        if (platform.getArchitecture().isAmd64()) {
            return new File(this.getBaseDir(), "bin/x64");
        }
        if (platform.getArchitecture().isArm()) {
            return new File(this.getBaseDir(), "bin/arm");
        }
        return new File(this.getBaseDir(), "bin/x86");
    }

    @Override
    public File[] getIncludeDirs() {
        return new File[]{new File(this.getBaseDir(), "Include/" + this.getVersion().toString() + "/um"), new File(this.getBaseDir(), "Include/" + this.getVersion().toString() + "/shared")};
    }

    @Override
    public File getLibDir(NativePlatformInternal platform) {
        String platformDir = "x86";
        if (platform.getArchitecture().isAmd64()) {
            platformDir = "x64";
        }
        if (platform.getArchitecture().isArm()) {
            platformDir = "arm";
        }
        return new File(this.getBaseDir(), "Lib/" + this.getVersion().toString() + "/um/" + platformDir);
    }
}

