/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal;

import java.lang.ref.SoftReference;
import java.util.concurrent.atomic.AtomicReference;
import org.gradle.internal.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Factories {
    public static <T> Factory<T> toFactory(final Runnable runnable) {
        return new Factory<T>(){

            @Override
            public T create() {
                runnable.run();
                return null;
            }
        };
    }

    public static <T> Factory<T> constant(final T item) {
        return new Factory<T>(){

            @Override
            public T create() {
                return item;
            }
        };
    }

    public static <T> Factory<T> constantNull() {
        return Factories.constant(null);
    }

    public static <T> Factory<T> softReferenceCache(Factory<T> factory) {
        return new CachingSoftReferenceFactory<T>(factory);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CachingSoftReferenceFactory<T>
    implements Factory<T> {
        private final Factory<T> factory;
        private final AtomicReference<SoftReference<T>> cachedReference = new AtomicReference();

        public CachingSoftReferenceFactory(Factory<T> factory) {
            this.factory = factory;
        }

        @Override
        public T create() {
            Object value;
            SoftReference<T> reference = this.cachedReference.get();
            Object t = value = reference != null ? (Object)reference.get() : null;
            if (value == null) {
                value = this.factory.create();
                this.cachedReference.set(new SoftReference<Object>(value));
            }
            return value;
        }
    }
}

