/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.scala;

import java.io.File;
import javax.inject.Inject;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.project.IsolatedAntBuilder;
import org.gradle.api.internal.tasks.scala.AntScalaDoc;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.scala.ScalaDocOptions;
import org.gradle.util.GUtil;

@CacheableTask
public class ScalaDoc
extends SourceTask {
    private File destinationDir;
    private FileCollection classpath;
    private FileCollection scalaClasspath;
    private ScalaDocOptions scalaDocOptions = new ScalaDocOptions();
    private String title;

    @Inject
    protected IsolatedAntBuilder getAntBuilder() {
        throw new UnsupportedOperationException();
    }

    @OutputDirectory
    public File getDestinationDir() {
        return this.destinationDir;
    }

    public void setDestinationDir(File destinationDir) {
        this.destinationDir = destinationDir;
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileTree getSource() {
        return super.getSource();
    }

    @Classpath
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setClasspath(FileCollection classpath) {
        this.classpath = classpath;
    }

    @Classpath
    public FileCollection getScalaClasspath() {
        return this.scalaClasspath;
    }

    public void setScalaClasspath(FileCollection scalaClasspath) {
        this.scalaClasspath = scalaClasspath;
    }

    @Nested
    public ScalaDocOptions getScalaDocOptions() {
        return this.scalaDocOptions;
    }

    public void setScalaDocOptions(ScalaDocOptions scalaDocOptions) {
        this.scalaDocOptions = scalaDocOptions;
    }

    @Input
    @Optional
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @TaskAction
    protected void generate() {
        ScalaDocOptions options = this.getScalaDocOptions();
        if (!GUtil.isTrue((Object)options.getDocTitle())) {
            options.setDocTitle(this.getTitle());
        }
        AntScalaDoc antScalaDoc = new AntScalaDoc(this.getAntBuilder());
        antScalaDoc.execute((FileCollection)this.getSource(), this.getDestinationDir(), (Iterable<File>)this.getClasspath(), (Iterable<File>)this.getScalaClasspath(), options);
    }
}

