/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal;

import java.io.File;
import net.rubygrapefruit.platform.FileEvents;
import net.rubygrapefruit.platform.FileWatch;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.ResourceClosedException;
import net.rubygrapefruit.platform.internal.FunctionResult;
import net.rubygrapefruit.platform.internal.jni.FileEventFunctions;

public class DefaultFileEvents
implements FileEvents {
    public FileWatch startWatch(File target) throws NativeException {
        FunctionResult result2 = new FunctionResult();
        Object handle = FileEventFunctions.createWatch(target.getAbsolutePath(), result2);
        if (result2.isFailed()) {
            throw new NativeException(String.format("Could not watch for changes to %s: %s", target, result2.getMessage()));
        }
        return new DefaultFileWatch(handle, target);
    }

    private static class DefaultFileWatch
    implements FileWatch {
        private final File target;
        private final Object lock = new Object();
        private Object handle;
        private State state = State.Watching;

        public DefaultFileWatch(Object handle, File target) {
            this.handle = handle;
            this.target = target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void nextChange() {
            Object object = this.lock;
            synchronized (object) {
                if (this.state != State.Watching) {
                    throw new ResourceClosedException("This file watch has been closed.");
                }
            }
            FunctionResult result2 = new FunctionResult();
            boolean hasEvent = FileEventFunctions.waitForNextEvent(this.handle, result2);
            if (result2.isFailed()) {
                throw new NativeException(String.format("Could not receive next change to %s: %s", this.target, result2.getMessage()));
            }
            if (!hasEvent) {
                throw new ResourceClosedException(String.format("This file watch has been closed.", new Object[0]));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.lock;
            synchronized (object) {
                if (this.state != State.Watching) {
                    while (this.state != State.Closed) {
                        try {
                            this.lock.wait();
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    return;
                }
                this.state = State.Closing;
            }
            try {
                FunctionResult result2 = new FunctionResult();
                FileEventFunctions.closeWatch(this.handle, result2);
                if (result2.isFailed()) {
                    throw new NativeException(String.format("Could cleanup watch handle for %s: %s", this.target, result2.getMessage()));
                }
            }
            finally {
                object = this.lock;
                synchronized (object) {
                    this.handle = null;
                    this.state = State.Closed;
                    this.lock.notifyAll();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum State {
            Watching,
            Closing,
            Closed;

        }
    }
}

