/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrExpressionBodyImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrIfThenElseImpl;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0014\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LateinitLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "throwErrorFunction", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "irBlock", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "kotlin-compiler"})
public final class LateinitLowering
implements FileLoweringPass {
    private final IrFunctionSymbol throwErrorFunction;
    @NotNull
    private final CommonBackendContext context;

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull(irFile, "irFile");
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, new IrElementTransformerVoid(this){
            final /* synthetic */ LateinitLowering this$0;

            @NotNull
            public IrStatement visitProperty(@NotNull IrProperty declaration) {
                Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                if (declaration.getDescriptor().isLateInit() && declaration.getDescriptor().getKind().isReal()) {
                    IrField irField = declaration.getBackingField();
                    if (irField == null) {
                        Intrinsics.throwNpe();
                    }
                    IrFieldSymbol irFieldSymbol = (IrFieldSymbol)irField.getSymbol();
                    IrFunction irFunction = declaration.getGetter();
                    if (irFunction == null) {
                        Intrinsics.throwNpe();
                    }
                    this.transformGetter(irFieldSymbol, irFunction);
                }
                return declaration;
            }

            private final void transformGetter(IrFieldSymbol backingFieldSymbol, IrFunction getter2) {
                DeclarationIrBuilder irBuilder;
                DeclarationIrBuilder declarationIrBuilder;
                boolean bl;
                KotlinType type2 = ((PropertyDescriptor)backingFieldSymbol.getDescriptor()).getType();
                boolean bl2 = bl = !KotlinBuiltIns.isPrimitiveType(type2);
                if (_Assertions.ENABLED && !bl) {
                    String string = "'lateinit' modifier is not allowed on primitive types";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                int startOffset = getter2.getStartOffset();
                int endOffset = getter2.getEndOffset();
                DeclarationIrBuilder $receiver = declarationIrBuilder = (irBuilder = LowerUtilsKt.createIrBuilder(this.this$0.getContext(), getter2.getSymbol(), startOffset, endOffset));
                IrBuilderWithScope irBuilderWithScope = $receiver;
                KotlinType kotlinType = type2;
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "type");
                IrBlock block = LateinitLowering.access$irBlock(this.this$0, irBuilderWithScope, kotlinType);
                Scope scope = $receiver.getScope();
                IrBuilderWithScope irBuilderWithScope2 = $receiver;
                IrBuilderWithScope irBuilderWithScope3 = $receiver;
                IrValueParameter irValueParameter = getter2.getDispatchReceiverParameter();
                if (irValueParameter == null) {
                    Intrinsics.throwNpe();
                }
                IrVariable resultVar = Scope.createTemporaryVariable$default(scope, LowerUtilsKt.irGetField(irBuilderWithScope2, ExpressionHelpersKt.irGet(irBuilderWithScope3, (IrValueSymbol)irValueParameter.getSymbol()), backingFieldSymbol), null, false, null, 14, null);
                block.getStatements().add(resultVar);
                IrBuilderWithScope irBuilderWithScope4 = $receiver;
                SimpleType simpleType2 = $receiver.getContext().getBuiltIns().getNothingType();
                Intrinsics.checkExpressionValueIsNotNull(simpleType2, "context.builtIns.nothingType");
                IrIfThenElseImpl throwIfNull = ExpressionHelpersKt.irIfThenElse(irBuilderWithScope4, simpleType2, ExpressionHelpersKt.irNotEquals($receiver, ExpressionHelpersKt.irGet($receiver, (IrValueSymbol)resultVar.getSymbol()), ExpressionHelpersKt.irNull($receiver)), ExpressionHelpersKt.irReturn($receiver, ExpressionHelpersKt.irGet($receiver, (IrValueSymbol)resultVar.getSymbol())), ExpressionHelpersKt.irCall($receiver, LateinitLowering.access$getThrowErrorFunction$p(this.this$0)));
                block.getStatements().add(throwIfNull);
                getter2.setBody(new IrExpressionBodyImpl(startOffset, endOffset, block));
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    private final IrBlock irBlock(@NotNull IrBuilderWithScope $receiver, KotlinType type2) {
        return new IrBlockImpl($receiver.getStartOffset(), $receiver.getEndOffset(), type2, null, 8, null);
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    public LateinitLowering(@NotNull CommonBackendContext context) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        this.context = context;
        this.throwErrorFunction = this.context.getIr().getSymbols().getThrowUninitializedPropertyAccessException();
    }

    @NotNull
    public static final /* synthetic */ IrBlock access$irBlock(LateinitLowering $this, @NotNull IrBuilderWithScope $receiver, @NotNull KotlinType type2) {
        return $this.irBlock($receiver, type2);
    }

    @NotNull
    public static final /* synthetic */ IrFunctionSymbol access$getThrowErrorFunction$p(LateinitLowering $this) {
        return $this.throwErrorFunction;
    }
}

