/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.vfs;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.CachedSingletonsRegistry;
import org.jetbrains.kotlin.com.intellij.openapi.util.ModificationTracker;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileSystem;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.newvfs.BulkFileListener;
import org.jetbrains.kotlin.com.intellij.util.messages.Topic;

public abstract class VirtualFileManager
implements ModificationTracker {
    public static final Topic<BulkFileListener> VFS_CHANGES = new Topic<BulkFileListener>("NewVirtualFileSystem changes", BulkFileListener.class);
    public static final ModificationTracker VFS_STRUCTURE_MODIFICATIONS = new ModificationTracker(){

        @Override
        public long getModificationCount() {
            return VirtualFileManager.getInstance().getStructureModificationCount();
        }
    };
    private static VirtualFileManager ourInstance = CachedSingletonsRegistry.markCachedField(VirtualFileManager.class);

    @NotNull
    public static VirtualFileManager getInstance() {
        VirtualFileManager result2 = ourInstance;
        if (result2 == null) {
            ourInstance = result2 = ApplicationManager.getApplication().getComponent(VirtualFileManager.class);
        }
        VirtualFileManager virtualFileManager = result2;
        if (virtualFileManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFileManager", "getInstance"));
        }
        return virtualFileManager;
    }

    public abstract VirtualFileSystem getFileSystem(String var1);

    @Nullable
    public abstract VirtualFile findFileByUrl(@NonNls @NotNull String var1);

    @NotNull
    public static String constructUrl(@NotNull String protocol, @NotNull String path) {
        if (protocol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protocol", "org/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFileManager", "constructUrl"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFileManager", "constructUrl"));
        }
        String string = protocol + "://" + path;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFileManager", "constructUrl"));
        }
        return string;
    }

    @Nullable
    public static String extractProtocol(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFileManager", "extractProtocol"));
        }
        int index2 = url.indexOf("://");
        if (index2 < 0) {
            return null;
        }
        return url.substring(0, index2);
    }

    @NotNull
    public static String extractPath(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFileManager", "extractPath"));
        }
        int index2 = url.indexOf("://");
        if (index2 < 0) {
            String string = url;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFileManager", "extractPath"));
            }
            return string;
        }
        String string = url.substring(index2 + "://".length());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFileManager", "extractPath"));
        }
        return string;
    }

    public abstract void notifyPropertyChanged(@NotNull VirtualFile var1, @NotNull String var2, Object var3, Object var4);

    public abstract long getStructureModificationCount();
}

