/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.components.ServiceManager;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.SmartPsiElementPointer;
import org.jetbrains.kotlin.com.intellij.psi.SmartPsiFileRange;

public abstract class SmartPointerManager {
    @NotNull
    public abstract SmartPsiFileRange createSmartPsiFileRangePointer(@NotNull PsiFile var1, @NotNull TextRange var2);

    public static SmartPointerManager getInstance(Project project) {
        return ServiceManager.getService(project, SmartPointerManager.class);
    }

    @NotNull
    public abstract <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(@NotNull E var1);

    @NotNull
    public abstract <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(@NotNull E var1, PsiFile var2);

    @NotNull
    public <E extends PsiElement> SmartPsiElementPointer<E> createLazyPointer(@NotNull E element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/SmartPointerManager", "createLazyPointer"));
        }
        SmartPsiElementPointer<E> smartPsiElementPointer = this.createSmartPsiElementPointer(element);
        if (smartPsiElementPointer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/SmartPointerManager", "createLazyPointer"));
        }
        return smartPsiElementPointer;
    }

    public abstract boolean pointToTheSameElement(@NotNull SmartPsiElementPointer var1, @NotNull SmartPsiElementPointer var2);

    public abstract void removePointer(@NotNull SmartPsiElementPointer var1);
}

