/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.LighterAST;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpression;
import org.jetbrains.kotlin.com.intellij.psi.impl.cache.RecordUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.FunctionalExpressionElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.FunctionalExpressionStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaSourceUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LightTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java.PsiLambdaExpressionImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java.ReplaceExpressionUtil;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;

public class LambdaExpressionElementType
extends FunctionalExpressionElementType<PsiLambdaExpression> {
    public LambdaExpressionElementType() {
        super("LAMBDA_EXPRESSION");
    }

    @Override
    public PsiLambdaExpression createPsi(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/LambdaExpressionElementType", "createPsi"));
        }
        return new PsiLambdaExpressionImpl(node);
    }

    @Override
    public PsiLambdaExpression createPsi(@NotNull FunctionalExpressionStub<PsiLambdaExpression> stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/LambdaExpressionElementType", "createPsi"));
        }
        return new PsiLambdaExpressionImpl(stub);
    }

    @Override
    @NotNull
    public ASTNode createCompositeNode() {
        CompositeElement compositeElement = new CompositeElement(this){

            @Override
            public void replaceChildInternal(@NotNull ASTNode child, @NotNull TreeElement newElement) {
                boolean needParenth;
                if (child == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/LambdaExpressionElementType$1", "replaceChildInternal"));
                }
                if (newElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/LambdaExpressionElementType$1", "replaceChildInternal"));
                }
                if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType()) && ElementType.EXPRESSION_BIT_SET.contains(newElement.getElementType()) && (needParenth = ReplaceExpressionUtil.isNeedParenthesis(child, newElement))) {
                    newElement = JavaSourceUtil.addParenthToReplacedChild(JavaElementType.PARENTH_EXPRESSION, newElement, this.getManager());
                }
                super.replaceChildInternal(child, newElement);
            }

            @Override
            public int getChildRole(ASTNode child) {
                IElementType elType = child.getElementType();
                if (elType == JavaTokenType.ARROW) {
                    return 252;
                }
                if (elType == JavaElementType.PARAMETER_LIST) {
                    return 14;
                }
                if (elType == JavaElementType.CODE_BLOCK) {
                    return 18;
                }
                return 64;
            }
        };
        if (compositeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/LambdaExpressionElementType", "createCompositeNode"));
        }
        return compositeElement;
    }

    @Override
    @NotNull
    protected String getPresentableText(@NotNull LighterAST tree, @NotNull LighterASTNode funExpr) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/LambdaExpressionElementType", "getPresentableText"));
        }
        if (funExpr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "funExpr", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/LambdaExpressionElementType", "getPresentableText"));
        }
        LighterASTNode parameterList = ObjectUtils.notNull(LightTreeUtil.firstChildOfType(tree, funExpr, JavaStubElementTypes.PARAMETER_LIST));
        String string = LambdaExpressionElementType.getLambdaPresentableText(tree, parameterList);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/LambdaExpressionElementType", "getPresentableText"));
        }
        return string;
    }

    private static String getLambdaPresentableText(@NotNull LighterAST tree, @NotNull LighterASTNode parameterList) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/LambdaExpressionElementType", "getLambdaPresentableText"));
        }
        if (parameterList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterList", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/LambdaExpressionElementType", "getLambdaPresentableText"));
        }
        StringBuilder buf = new StringBuilder(parameterList.getEndOffset() - parameterList.getStartOffset());
        LambdaExpressionElementType.formatParameterList(tree, parameterList, buf);
        buf.append(" -> {...}");
        return buf.toString();
    }

    private static void formatParameterList(@NotNull LighterAST tree, @NotNull LighterASTNode parameterList, StringBuilder buf) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/LambdaExpressionElementType", "formatParameterList"));
        }
        if (parameterList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterList", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/LambdaExpressionElementType", "formatParameterList"));
        }
        List<LighterASTNode> children = tree.getChildren(parameterList);
        boolean isFirstParameter = true;
        boolean appendCloseBracket = false;
        for (LighterASTNode node : children) {
            IElementType tokenType = node.getTokenType();
            if (tokenType == JavaTokenType.LPARENTH) {
                buf.append('(');
                appendCloseBracket = true;
                continue;
            }
            if (tokenType != JavaStubElementTypes.PARAMETER) continue;
            if (!isFirstParameter) {
                buf.append(", ");
            }
            LambdaExpressionElementType.formatParameter(tree, node, buf);
            if (!isFirstParameter) continue;
            isFirstParameter = false;
        }
        if (appendCloseBracket) {
            buf.append(')');
        }
    }

    private static void formatParameter(@NotNull LighterAST tree, @NotNull LighterASTNode parameter, StringBuilder buf) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/LambdaExpressionElementType", "formatParameter"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/LambdaExpressionElementType", "formatParameter"));
        }
        List<LighterASTNode> children = tree.getChildren(parameter);
        for (LighterASTNode node : children) {
            IElementType tokenType = node.getTokenType();
            if (tokenType == JavaElementType.TYPE) {
                LambdaExpressionElementType.formatType(tree, node, buf);
                buf.append(' ');
                continue;
            }
            if (tokenType != JavaTokenType.IDENTIFIER) continue;
            buf.append(RecordUtil.intern(tree.getCharTable(), node));
        }
    }

    private static void formatType(LighterAST tree, LighterASTNode typeElement, StringBuilder buf) {
        for (LighterASTNode node : tree.getChildren(typeElement)) {
            IElementType tokenType = node.getTokenType();
            if (tokenType == JavaElementType.JAVA_CODE_REFERENCE) {
                LambdaExpressionElementType.formatCodeReference(tree, node, buf);
                continue;
            }
            if (tokenType == JavaElementType.TYPE) {
                LambdaExpressionElementType.formatType(tree, node, buf);
                continue;
            }
            if (tokenType == JavaTokenType.QUEST) {
                buf.append("? ");
                continue;
            }
            if (ElementType.KEYWORD_BIT_SET.contains(tokenType)) {
                buf.append(RecordUtil.intern(tree.getCharTable(), node));
                if (ElementType.PRIMITIVE_TYPE_BIT_SET.contains(tokenType)) continue;
                buf.append(" ");
                continue;
            }
            if (tokenType == JavaTokenType.ELLIPSIS) {
                buf.append("...");
                continue;
            }
            if (tokenType == JavaTokenType.RBRACKET) {
                buf.append("]");
                continue;
            }
            if (tokenType != JavaTokenType.LBRACKET) continue;
            buf.append("[");
        }
    }

    private static void formatCodeReference(LighterAST tree, LighterASTNode codeRef, StringBuilder buf) {
        for (LighterASTNode node : tree.getChildren(codeRef)) {
            IElementType tokenType = node.getTokenType();
            if (tokenType == JavaTokenType.IDENTIFIER) {
                buf.append(RecordUtil.intern(tree.getCharTable(), node));
                continue;
            }
            if (tokenType != JavaElementType.REFERENCE_PARAMETER_LIST) continue;
            LambdaExpressionElementType.formatTypeParameters(tree, node, buf);
        }
    }

    private static void formatTypeParameters(LighterAST tree, LighterASTNode typeParameters2, StringBuilder buf) {
        List<LighterASTNode> children = LightTreeUtil.getChildrenOfType(tree, typeParameters2, JavaElementType.TYPE);
        if (children.isEmpty()) {
            return;
        }
        buf.append('<');
        for (int i = 0; i < children.size(); ++i) {
            LighterASTNode child = children.get(i);
            LambdaExpressionElementType.formatType(tree, child, buf);
            if (i == children.size() - 1) continue;
            buf.append(", ");
        }
        buf.append('>');
    }
}

