/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source;

import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.LighterAST;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.impl.cache.RecordUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LightTreeUtil;

public class JavaLightTreeUtil {
    @Nullable
    @Contract(value="_,null->null")
    public static List<LighterASTNode> getArgList(@NotNull LighterAST tree, @Nullable LighterASTNode call2) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/kotlin/com/intellij/psi/impl/source/JavaLightTreeUtil", "getArgList"));
        }
        LighterASTNode anonClass = LightTreeUtil.firstChildOfType(tree, call2, JavaElementType.ANONYMOUS_CLASS);
        LighterASTNode exprList = LightTreeUtil.firstChildOfType(tree, anonClass != null ? anonClass : call2, JavaElementType.EXPRESSION_LIST);
        return exprList == null ? null : JavaLightTreeUtil.getExpressionChildren(tree, exprList);
    }

    @Nullable
    @Contract(value="_,null->null")
    public static String getNameIdentifierText(@NotNull LighterAST tree, @Nullable LighterASTNode idOwner) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/kotlin/com/intellij/psi/impl/source/JavaLightTreeUtil", "getNameIdentifierText"));
        }
        LighterASTNode id = LightTreeUtil.firstChildOfType(tree, idOwner, JavaTokenType.IDENTIFIER);
        return id != null ? RecordUtil.intern(tree.getCharTable(), id) : null;
    }

    @NotNull
    public static List<LighterASTNode> getExpressionChildren(@NotNull LighterAST tree, @NotNull LighterASTNode node) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/kotlin/com/intellij/psi/impl/source/JavaLightTreeUtil", "getExpressionChildren"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/psi/impl/source/JavaLightTreeUtil", "getExpressionChildren"));
        }
        List<LighterASTNode> list2 = LightTreeUtil.getChildrenOfType(tree, node, ElementType.EXPRESSION_BIT_SET);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/JavaLightTreeUtil", "getExpressionChildren"));
        }
        return list2;
    }

    @Nullable
    public static LighterASTNode findExpressionChild(@NotNull LighterAST tree, @Nullable LighterASTNode node) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/kotlin/com/intellij/psi/impl/source/JavaLightTreeUtil", "findExpressionChild"));
        }
        return LightTreeUtil.firstChildOfType(tree, node, ElementType.EXPRESSION_BIT_SET);
    }
}

