/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.javadoc;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiReference;
import org.jetbrains.kotlin.com.intellij.psi.javadoc.JavadocTagInfo;
import org.jetbrains.kotlin.com.intellij.psi.javadoc.PsiDocTagValue;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;

class SimpleDocTagInfo
implements JavadocTagInfo {
    private final String myName;
    private final Class[] myContexts;
    private final boolean myInline;
    private final LanguageLevel myLanguageLevel;

    SimpleDocTagInfo(@NotNull String name, @NotNull LanguageLevel level, boolean isInline, Class ... contexts) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/source/javadoc/SimpleDocTagInfo", "<init>"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "org/jetbrains/kotlin/com/intellij/psi/impl/source/javadoc/SimpleDocTagInfo", "<init>"));
        }
        if (contexts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contexts", "org/jetbrains/kotlin/com/intellij/psi/impl/source/javadoc/SimpleDocTagInfo", "<init>"));
        }
        this.myName = name;
        this.myContexts = contexts;
        this.myInline = isInline;
        this.myLanguageLevel = level;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public boolean isInline() {
        return this.myInline;
    }

    @Override
    public boolean isValidInContext(PsiElement element) {
        if (element != null && PsiUtil.getLanguageLevel(element).compareTo(this.myLanguageLevel) < 0) {
            return false;
        }
        for (Class context : this.myContexts) {
            if (!context.isInstance(element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String checkTagValue(PsiDocTagValue value) {
        return null;
    }

    @Override
    public PsiReference getReference(PsiDocTagValue value) {
        return null;
    }
}

