/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrimitiveType;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.StrictSubtypingConstraint;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeEqualityConstraint;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;

public class TypeCompatibilityConstraint
implements ConstraintFormula {
    private PsiType myT;
    private PsiType myS;

    public TypeCompatibilityConstraint(@NotNull PsiType t, @NotNull PsiType s) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/constraints/TypeCompatibilityConstraint", "<init>"));
        }
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/constraints/TypeCompatibilityConstraint", "<init>"));
        }
        this.myT = t;
        this.myS = s;
    }

    @Override
    public boolean reduce(InferenceSession session, List<ConstraintFormula> constraints) {
        PsiClassType boxedType;
        if (session.isProperType(this.myT) && session.isProperType(this.myS)) {
            boolean assignable = TypeConversionUtil.isAssignable(this.myT, this.myS);
            if (!assignable) {
                session.registerIncompatibleErrorMessage("Incompatible types: " + session.getPresentableText(this.myS) + " is not convertible to " + session.getPresentableText(this.myT));
            }
            return assignable;
        }
        if (this.myS instanceof PsiPrimitiveType && !PsiType.VOID.equals(this.myS) && (boxedType = ((PsiPrimitiveType)this.myS).getBoxedType(session.getManager(), session.getScope())) != null) {
            constraints.add(new TypeCompatibilityConstraint(this.myT, boxedType));
            return true;
        }
        if (this.myT instanceof PsiPrimitiveType && !PsiType.VOID.equals(this.myT) && (boxedType = ((PsiPrimitiveType)this.myT).getBoxedType(session.getManager(), session.getScope())) != null) {
            constraints.add(new TypeEqualityConstraint(boxedType, this.myS));
            return true;
        }
        if (TypeCompatibilityConstraint.isUncheckedConversion(this.myT, this.myS)) {
            session.setErasedDuringApplicabilityCheck();
            return true;
        }
        constraints.add(new StrictSubtypingConstraint(this.myT, this.myS));
        return true;
    }

    public static boolean isUncheckedConversion(PsiType t, PsiType s) {
        if (t instanceof PsiClassType && !((PsiClassType)t).isRaw() && s instanceof PsiClassType) {
            PsiSubstitutor sSubstitutor;
            PsiClassType.ClassResolveResult tResult = ((PsiClassType)t).resolveGenerics();
            PsiClassType.ClassResolveResult sResult = ((PsiClassType)s).resolveGenerics();
            PsiClass tClass = tResult.getElement();
            PsiClass sClass = sResult.getElement();
            if (tClass != null && sClass != null && !(sClass instanceof InferenceVariable) && ((sSubstitutor = TypeConversionUtil.getClassSubstitutor(tClass, sClass, sResult.getSubstitutor())) != null ? PsiUtil.isRawSubstitutor(tClass, sSubstitutor) : tClass instanceof InferenceVariable && ((PsiClassType)s).isRaw() && tClass.isInheritor(sClass, true))) {
                return true;
            }
        } else if (t instanceof PsiArrayType && s != null && t.getArrayDimensions() == s.getArrayDimensions()) {
            return TypeCompatibilityConstraint.isUncheckedConversion(t.getDeepComponentType(), s.getDeepComponentType());
        }
        return false;
    }

    @Override
    public void apply(PsiSubstitutor substitutor2, boolean cache2) {
        this.myT = substitutor2.substitute(this.myT);
        this.myS = substitutor2.substitute(this.myS);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeCompatibilityConstraint that = (TypeCompatibilityConstraint)o;
        if (!this.myS.equals(that.myS)) {
            return false;
        }
        return this.myT.equals(that.myT);
    }

    public int hashCode() {
        int result2 = this.myT.hashCode();
        result2 = 31 * result2 + this.myS.hashCode();
        return result2;
    }

    public String toString() {
        return this.myS.getPresentableText() + " -> " + this.myT.getPresentableText();
    }
}

