/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.LogUtil;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.Getter;
import org.jetbrains.kotlin.com.intellij.openapi.util.StaticGetter;
import org.jetbrains.kotlin.com.intellij.psi.impl.DebugUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.AstPath;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.ILazyParseableElementTypeBase;
import org.jetbrains.kotlin.com.intellij.reference.SoftReference;
import org.jetbrains.kotlin.com.intellij.util.text.CharArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.text.ImmutableCharSequence;

public class LazyParseableElement
extends CompositeElement {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.LazyParseableElement");
    private static final StaticGetter<CharSequence> NO_TEXT = new StaticGetter<Object>(null);
    private final ChameleonLock lock;
    @NotNull
    private Getter<CharSequence> myText;
    private boolean myParsed;
    private static boolean ourParsingAllowed = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LazyParseableElement(@NotNull IElementType type2, @Nullable CharSequence text2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LazyParseableElement", "<init>"));
        }
        super(type2);
        ChameleonLock chameleonLock = this.lock = new ChameleonLock();
        synchronized (chameleonLock) {
            boolean bl = this.myParsed = text2 == null;
            if (text2 == null) {
                this.myText = NO_TEXT;
            } else {
                this.myText = new StaticGetter<CharSequence>(ImmutableCharSequence.asImmutable(text2));
                this.setCachedLength(text2.length());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCaches() {
        super.clearCaches();
        ChameleonLock chameleonLock = this.lock;
        synchronized (chameleonLock) {
            if (this.myParsed) {
                this.myText = NO_TEXT;
            } else {
                this.setCachedLength(this.myText.get().length());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public String getText() {
        CharSequence text2 = this.myText();
        if (text2 != null) {
            String string = text2.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LazyParseableElement", "getText"));
            }
            return string;
        }
        String s = super.getText();
        ChameleonLock chameleonLock = this.lock;
        synchronized (chameleonLock) {
            this.myText = new SoftReference<String>(s);
        }
        String string = s;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LazyParseableElement", "getText"));
        }
        return string;
    }

    @Override
    @NotNull
    public CharSequence getChars() {
        CharSequence text2 = this.myText();
        CharSequence charSequence = text2 != null ? text2 : this.getText();
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LazyParseableElement", "getChars"));
        }
        return charSequence;
    }

    @Override
    public int getTextLength() {
        CharSequence text2 = this.myText();
        if (text2 != null) {
            return text2.length();
        }
        return super.getTextLength();
    }

    @Override
    public int getNotCachedLength() {
        CharSequence text2 = this.myText();
        if (text2 != null) {
            return text2.length();
        }
        return super.getNotCachedLength();
    }

    @Override
    public int hc() {
        CharSequence text2 = this.myText();
        return text2 == null ? super.hc() : LeafElement.leafHC(text2);
    }

    @Override
    protected int textMatches(@NotNull CharSequence buffer, int start) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LazyParseableElement", "textMatches"));
        }
        CharSequence text2 = this.myText();
        if (text2 != null) {
            return LeafElement.leafTextMatches(text2, buffer, start);
        }
        return super.textMatches(buffer, start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isParsed() {
        ChameleonLock chameleonLock = this.lock;
        synchronized (chameleonLock) {
            return this.myParsed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CharSequence myText() {
        ChameleonLock chameleonLock = this.lock;
        synchronized (chameleonLock) {
            return this.myText.get();
        }
    }

    @Override
    final void setFirstChildNode(TreeElement child) {
        if (!this.isParsed()) {
            LOG.error("Mutating collapsed chameleon");
        }
        super.setFirstChildNode(child);
    }

    @Override
    final void setLastChildNode(TreeElement child) {
        if (!this.isParsed()) {
            LOG.error("Mutating collapsed chameleon");
        }
        super.setLastChildNode(child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureParsed() {
        CharSequence text2;
        if (!ourParsingAllowed) {
            LOG.error("Parsing not allowed!!!");
        }
        ChameleonLock chameleonLock = this.lock;
        synchronized (chameleonLock) {
            if (this.myParsed) {
                return;
            }
            text2 = this.myText.get();
            assert (text2 != null);
        }
        if (TreeUtil.getFileElement(this) == null) {
            LOG.error("Chameleons must not be parsed till they're in file tree: " + this);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        DebugUtil.startPsiModification("lazy-parsing");
        try {
            ILazyParseableElementTypeBase type2 = (ILazyParseableElementTypeBase)((Object)this.getElementType());
            ASTNode parsedNode = type2.parseContents(this);
            if (parsedNode == null && text2.length() > 0) {
                CharSequence diagText = ApplicationManager.getApplication().isInternal() ? text2 : "";
                LOG.error("No parse for a non-empty string: " + diagText + "; type=" + LogUtil.objectAndClass(type2));
            }
            ChameleonLock chameleonLock2 = this.lock;
            synchronized (chameleonLock2) {
                block18: {
                    if (!this.myParsed) break block18;
                    return;
                }
                if (this.rawFirstChild() != null) {
                    LOG.error("Reentrant parsing?");
                }
                this.myParsed = true;
                if (parsedNode != null) {
                    super.rawAddChildrenWithoutNotifications((TreeElement)parsedNode);
                }
                AstPath.cacheNodePaths(this);
                this.assertTextLengthIntact(text2.length());
                this.myText = new SoftReference<CharSequence>(text2);
            }
        }
        finally {
            DebugUtil.finishPsiModification();
        }
    }

    private void assertTextLengthIntact(int expected) {
        int length = 0;
        for (ASTNode node : this.getChildren(null)) {
            length += node.getTextLength();
        }
        assert (length == expected) : "Text mismatch in " + this.getElementType();
    }

    @Override
    public void rawAddChildrenWithoutNotifications(@NotNull TreeElement first) {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LazyParseableElement", "rawAddChildrenWithoutNotifications"));
        }
        if (!this.isParsed()) {
            LOG.error("Mutating collapsed chameleon");
        }
        super.rawAddChildrenWithoutNotifications(first);
    }

    @Override
    public TreeElement getFirstChildNode() {
        this.ensureParsed();
        return super.getFirstChildNode();
    }

    @Override
    public TreeElement getLastChildNode() {
        this.ensureParsed();
        return super.getLastChildNode();
    }

    public int copyTo(@Nullable char[] buffer, int start) {
        CharSequence text2 = this.myText();
        if (text2 == null) {
            return -1;
        }
        if (buffer != null) {
            CharArrayUtil.getChars(text2, buffer, start);
        }
        return start + text2.length();
    }

    public static void setParsingAllowed(boolean allowed) {
        ourParsingAllowed = allowed;
    }

    private static class ChameleonLock {
        private ChameleonLock() {
        }

        @NonNls
        public String toString() {
            return "chameleon parsing lock";
        }
    }
}

