/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.stubs;

import java.io.IOException;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.io.AbstractStringEnumerator;
import org.jetbrains.kotlin.com.intellij.util.io.DataInputOutputUtil;
import org.jetbrains.kotlin.com.intellij.util.io.DataOutputStream;
import org.jetbrains.kotlin.com.intellij.util.io.IOUtil;

public class StubOutputStream
extends DataOutputStream {
    private final AbstractStringEnumerator myNameStorage;
    private final byte[] myStringIOBuffer;

    public StubOutputStream(@NotNull OutputStream out, @NotNull AbstractStringEnumerator nameStorage) {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/kotlin/com/intellij/psi/stubs/StubOutputStream", "<init>"));
        }
        if (nameStorage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameStorage", "org/jetbrains/kotlin/com/intellij/psi/stubs/StubOutputStream", "<init>"));
        }
        super(out);
        this.myStringIOBuffer = IOUtil.allocReadWriteUTFBuffer();
        this.myNameStorage = nameStorage;
    }

    public void writeUTFFast(@NotNull String arg) throws IOException {
        if (arg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "org/jetbrains/kotlin/com/intellij/psi/stubs/StubOutputStream", "writeUTFFast"));
        }
        IOUtil.writeUTFFast(this.myStringIOBuffer, this, arg);
    }

    public void writeName(@Nullable String arg) throws IOException {
        DataInputOutputUtil.writeNAME(this, arg, this.myNameStorage);
    }

    public void writeVarInt(int value) throws IOException {
        DataInputOutputUtil.writeINT(this, value);
    }

    public int getStringId(String value) throws IOException {
        return this.myNameStorage.enumerate(value);
    }
}

