/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.nio.charset.Charset;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.LoggerRt;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfoRt;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtilRt;

public class PathUtilRt {
    private static final Set<String> WINDOWS_NAMES = ContainerUtilRt.newHashSet("CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9");
    private static final Charset FS_CHARSET = PathUtilRt.fsCharset();

    @NotNull
    public static String getFileName(@Nullable String path) {
        if (path == null || path.length() == 0) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/PathUtilRt", "getFileName"));
            }
            return "";
        }
        char c = path.charAt(path.length() - 1);
        int end = c == '/' || c == '\\' ? path.length() - 1 : path.length();
        int start = Math.max(path.lastIndexOf(47, end - 1), path.lastIndexOf(92, end - 1)) + 1;
        String string = path.substring(start, end);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/PathUtilRt", "getFileName"));
        }
        return string;
    }

    private static Charset fsCharset() {
        String property;
        if (!SystemInfoRt.isWindows && !SystemInfoRt.isMac && (property = System.getProperty("sun.jnu.encoding")) != null) {
            try {
                return Charset.forName(property);
            }
            catch (Exception e) {
                LoggerRt.getInstance(PathUtilRt.class).warn("unknown JNU charset: " + property, e);
            }
        }
        return null;
    }
}

