/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import groovy.util.Node;
import java.util.HashMap;
import java.util.Map;
import org.gradle.plugins.ide.eclipse.model.ClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.internal.PathUtil;

public class Output
implements ClasspathEntry {
    private String path;

    public Output(Node node) {
        this((String)node.attribute((Object)"path"));
    }

    public Output(String path) {
        Preconditions.checkNotNull((Object)path);
        this.path = PathUtil.normalizePath(path);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public String getKind() {
        return "output";
    }

    @Override
    public void appendNode(Node node) {
        HashMap attributes = Maps.newHashMap();
        attributes.put("kind", this.getKind());
        attributes.put("path", this.path);
        node.appendNode((Object)"classpathentry", (Map)attributes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Output output = (Output)o;
        return Objects.equal((Object)this.path, (Object)output.path);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.path});
    }

    public String toString() {
        return "Output{path='" + this.path + "'}";
    }
}

