/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.core;

import java.util.ArrayList;
import java.util.List;
import org.simpleframework.http.Cookie;
import org.simpleframework.http.parse.DateParser;
import org.simpleframework.http.parse.ValueParser;
import org.simpleframework.util.KeyMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Message {
    private final KeyMap<Cookie> cookies = new KeyMap();
    private final KeyMap<Entry> values = new KeyMap();
    private final KeyMap<String> names = new KeyMap();
    private final DateParser parser = new DateParser();

    public List<String> getNames() {
        return this.names.getValues();
    }

    public void set(String name, String value) {
        List<String> list = this.getAll(name);
        if (value != null) {
            list.clear();
            list.add(value);
        }
    }

    public void set(String name, int value) {
        this.set(name, String.valueOf(value));
    }

    public void setDate(String name, long date) {
        this.set(name, this.parser.convert(date));
    }

    public void add(String name, String value) {
        List<String> list = this.getAll(name);
        if (value != null) {
            list.add(value);
        }
    }

    public void add(String name, int value) {
        this.add(name, String.valueOf(value));
    }

    public void addDate(String name, long date) {
        this.add(name, this.parser.convert(date));
    }

    public String getValue(String name) {
        List<String> list = this.getAll(name);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public int getInteger(String name) {
        String value = this.getValue(name);
        if (value == null) {
            return -1;
        }
        return Integer.parseInt(value);
    }

    public long getDate(String name) {
        String value = this.getValue(name);
        if (value == null) {
            return -1L;
        }
        return this.parser.convert(value);
    }

    public Cookie getCookie(String name) {
        return (Cookie)this.cookies.get(name);
    }

    public List<Cookie> getCookies() {
        return this.cookies.getValues();
    }

    public Cookie setCookie(String name, String value) {
        return this.setCookie(new Cookie(name, value, true));
    }

    public Cookie setCookie(Cookie cookie) {
        String name = cookie.getName();
        if (name != null) {
            this.cookies.put(name, cookie);
        }
        return cookie;
    }

    public List<String> getValues(String name) {
        return this.getValues(this.getAll(name));
    }

    public List<String> getValues(List<String> list) {
        return new ValueParser(list).list();
    }

    public List<String> getAll(String name) {
        String token = name.toLowerCase();
        Entry entry = (Entry)this.values.get(token);
        if (entry == null) {
            return this.getAll(name, token);
        }
        return entry.getValues();
    }

    private List<String> getAll(String name, String token) {
        Entry entry = new Entry(name);
        String value = (String)this.names.get(token);
        if (value == null) {
            this.names.put(token, name);
        }
        this.values.put(token, entry);
        return entry.getValues();
    }

    public void remove(String name) {
        String token = name.toLowerCase();
        String value = (String)this.names.get(token);
        if (value != null) {
            this.names.remove(token);
        }
        this.values.remove(token);
    }

    public boolean contains(String name) {
        return !this.getAll(name).isEmpty();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Entry {
        private List<String> value = new ArrayList<String>(2);
        private String name;

        public Entry(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public List<String> getValues() {
            return this.value;
        }
    }
}

