/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.parse;

import org.simpleframework.http.ContentType;
import org.simpleframework.util.KeyMap;
import org.simpleframework.util.parse.ParseBuffer;
import org.simpleframework.util.parse.Parser;

public class ContentParser
extends Parser
implements ContentType {
    private ParseBuffer subtype = new ParseBuffer();
    private ParseBuffer charset = new ParseBuffer();
    private ParseBuffer type;
    private ParseBuffer name;
    private ParseBuffer value = new ParseBuffer();
    private KeyMap<String> map;

    public ContentParser() {
        this.name = new ParseBuffer();
        this.type = new ParseBuffer();
        this.map = new KeyMap();
    }

    public ContentParser(String header) {
        this();
        this.parse(header);
    }

    public void setPrimary(String primary) {
        this.type.reset(primary);
    }

    public String getPrimary() {
        return this.type.toString();
    }

    public void setSecondary(String type) {
        this.subtype.reset(type);
    }

    public String getSecondary() {
        return this.subtype.toString();
    }

    public void setCharset(String enc) {
        this.charset.reset(enc);
    }

    public String getCharset() {
        return this.charset.toString();
    }

    public String getParameter(String name) {
        return (String)this.map.get(name);
    }

    public void setParameter(String name, String value) {
        this.map.put(name, value);
    }

    protected void init() {
        if (this.count > 0) {
            this.pack();
        }
        this.clear();
    }

    private void clear() {
        this.type.clear();
        this.subtype.clear();
        this.charset.clear();
        this.name.clear();
        this.value.clear();
        this.map.clear();
        this.off = 0;
    }

    protected void parse() {
        this.type();
        ++this.off;
        this.subtype();
        this.parameters();
    }

    private void pack() {
        char old = this.buf[0];
        int len = this.count;
        int seek = 0;
        int pos = 0;
        block0: while (seek < len) {
            char ch;
            if ((ch = this.buf[seek++]) == '\"' && old != '\\') {
                this.buf[pos++] = ch;
                while (seek < len) {
                    old = this.buf[seek - 1];
                    ch = this.buf[seek++];
                    this.buf[pos++] = ch;
                    if (ch != '\"' || old == '\\') continue;
                    continue block0;
                }
                continue;
            }
            if (this.space(ch)) continue;
            old = this.buf[seek - 1];
            this.buf[pos++] = old;
        }
        this.count = pos;
    }

    private void type() {
        while (this.off < this.count && this.buf[this.off] != '/') {
            this.type.append(this.buf[this.off]);
            ++this.off;
        }
    }

    private void subtype() {
        while (this.off < this.count && this.buf[this.off] != ';') {
            this.subtype.append(this.buf[this.off]);
            ++this.off;
        }
    }

    private void parameters() {
        while (this.skip(";")) {
            if (this.skip("charset=")) {
                this.charset();
                break;
            }
            this.parameter();
            this.insert();
        }
    }

    private void insert() {
        this.insert(this.name, this.value);
    }

    private void insert(ParseBuffer name, ParseBuffer value) {
        this.map.put(name.toString(), value.toString());
    }

    private void parameter() {
        this.name();
        ++this.off;
        this.value();
    }

    private void name() {
        while (this.off < this.count && this.buf[this.off] != '=') {
            this.name.append(this.buf[this.off]);
            ++this.off;
        }
    }

    private void value() {
        if (this.quote(this.buf[this.off])) {
            ++this.off;
            while (!(this.off >= this.count || this.quote(this.buf[this.off]) && this.buf[++this.off - 2] != '\\')) {
                this.value.append(this.buf[this.off++]);
            }
        } else {
            while (this.off < this.count && this.buf[this.off] != ';') {
                this.value.append(this.buf[this.off]);
                ++this.off;
            }
        }
    }

    private boolean quote(char ch) {
        return ch == '\'' || ch == '\"';
    }

    private void charset() {
        if (this.buf[this.off] == '\"') {
            this.charset.append('\"');
            ++this.off;
            while (this.off < this.count) {
                this.charset.append(this.buf[this.off]);
                if (this.buf[this.off++] != '\"' || this.buf[this.off - 2] == '\\') continue;
                break;
            }
        } else {
            while (this.off < this.count && this.buf[this.off] != ';') {
                this.charset.append(this.buf[this.off]);
                ++this.off;
            }
        }
    }

    private String encode() {
        StringBuilder text = new StringBuilder();
        if (this.type != null) {
            text.append(this.type);
            text.append("/");
            text.append(this.subtype);
        }
        if (this.charset.length() > 0) {
            text.append("; charset=");
            text.append(this.charset);
        }
        return this.encode(text);
    }

    private String encode(StringBuilder text) {
        for (String name : this.map) {
            String value = (String)this.map.get(name);
            text.append("; ");
            text.append(name);
            if (value == null) continue;
            text.append("=");
            text.append(value);
        }
        return text.toString();
    }

    public String toString() {
        return this.encode();
    }
}

