/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.resource;

import java.io.File;
import org.simpleframework.http.Address;
import org.simpleframework.http.Path;
import org.simpleframework.http.parse.AddressParser;
import org.simpleframework.http.resource.Index;
import org.simpleframework.http.resource.Indexer;

class FileIndex
implements Index {
    private Indexer indexer;
    private Path path;
    private File file;
    private String type;
    private Address target;

    public FileIndex(Indexer indexer, String target) {
        this(indexer, new AddressParser(target));
    }

    public FileIndex(Indexer indexer, Address target) {
        this.indexer = indexer;
        this.target = target;
    }

    public String getContentType() {
        if (this.type == null) {
            this.type = this.getContentType(this.target);
        }
        return this.type;
    }

    public String getContentType(Address target) {
        return this.indexer.getContentType(target);
    }

    public File getFile() {
        if (this.file == null) {
            this.file = this.getFile(this.target);
        }
        return this.file;
    }

    public File getFile(Address target) {
        return this.indexer.getFile(target);
    }

    public Path getPath() {
        if (this.path == null) {
            this.path = this.getPath(this.target);
        }
        return this.path;
    }

    public Path getPath(Address target) {
        return this.indexer.getPath(target);
    }

    public String getRealPath() {
        return this.getFile().getAbsolutePath();
    }

    public File getDirectory() {
        return this.getFile().getParentFile();
    }

    public String getRequestPath() {
        return this.getPath().getPath();
    }

    public String getName() {
        return this.getPath().getName();
    }
}

