/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.remote.internal.hub;

import org.gradle.internal.remote.internal.hub.MethodArgsSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Message;
import org.gradle.internal.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JavaSerializationBackedMethodArgsSerializer
implements MethodArgsSerializer {
    private static final Object[] ZERO_ARGS = new Object[0];
    private final ClassLoader classLoader;

    public JavaSerializationBackedMethodArgsSerializer(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public Serializer<Object[]> forTypes(Class<?>[] types) {
        if (types.length == 0) {
            return new EmptyArraySerializer();
        }
        return new ArraySerializer();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ArraySerializer
    implements Serializer<Object[]> {
        private ArraySerializer() {
        }

        @Override
        public Object[] read(Decoder decoder) throws Exception {
            return (Object[])Message.receive(decoder.getInputStream(), JavaSerializationBackedMethodArgsSerializer.this.classLoader);
        }

        @Override
        public void write(Encoder encoder, Object[] value) throws Exception {
            Message.send(value, encoder.getOutputStream());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EmptyArraySerializer
    implements Serializer<Object[]> {
        private EmptyArraySerializer() {
        }

        @Override
        public Object[] read(Decoder decoder) {
            return ZERO_ARGS;
        }

        @Override
        public void write(Encoder encoder, Object[] value) {
        }
    }
}

