/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.impl.internal;

import java.util.Collection;
import java.util.List;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.RequestTrace;
import org.sonatype.aether.SyncContext;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.collection.CollectResult;
import org.sonatype.aether.collection.DependencyCollectionException;
import org.sonatype.aether.deployment.DeployRequest;
import org.sonatype.aether.deployment.DeployResult;
import org.sonatype.aether.deployment.DeploymentException;
import org.sonatype.aether.graph.DependencyFilter;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.graph.DependencyVisitor;
import org.sonatype.aether.impl.ArtifactDescriptorReader;
import org.sonatype.aether.impl.ArtifactResolver;
import org.sonatype.aether.impl.DependencyCollector;
import org.sonatype.aether.impl.Deployer;
import org.sonatype.aether.impl.Installer;
import org.sonatype.aether.impl.LocalRepositoryProvider;
import org.sonatype.aether.impl.MetadataResolver;
import org.sonatype.aether.impl.SyncContextFactory;
import org.sonatype.aether.impl.VersionRangeResolver;
import org.sonatype.aether.impl.VersionResolver;
import org.sonatype.aether.impl.internal.ArtifactRequestBuilder;
import org.sonatype.aether.installation.InstallRequest;
import org.sonatype.aether.installation.InstallResult;
import org.sonatype.aether.installation.InstallationException;
import org.sonatype.aether.repository.LocalRepository;
import org.sonatype.aether.repository.LocalRepositoryManager;
import org.sonatype.aether.repository.NoLocalRepositoryManagerException;
import org.sonatype.aether.resolution.ArtifactDescriptorException;
import org.sonatype.aether.resolution.ArtifactDescriptorRequest;
import org.sonatype.aether.resolution.ArtifactDescriptorResult;
import org.sonatype.aether.resolution.ArtifactRequest;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.resolution.ArtifactResult;
import org.sonatype.aether.resolution.DependencyRequest;
import org.sonatype.aether.resolution.DependencyResolutionException;
import org.sonatype.aether.resolution.DependencyResult;
import org.sonatype.aether.resolution.MetadataRequest;
import org.sonatype.aether.resolution.MetadataResult;
import org.sonatype.aether.resolution.VersionRangeRequest;
import org.sonatype.aether.resolution.VersionRangeResolutionException;
import org.sonatype.aether.resolution.VersionRangeResult;
import org.sonatype.aether.resolution.VersionRequest;
import org.sonatype.aether.resolution.VersionResolutionException;
import org.sonatype.aether.resolution.VersionResult;
import org.sonatype.aether.spi.locator.Service;
import org.sonatype.aether.spi.locator.ServiceLocator;
import org.sonatype.aether.spi.log.Logger;
import org.sonatype.aether.spi.log.NullLogger;
import org.sonatype.aether.util.DefaultRequestTrace;
import org.sonatype.aether.util.graph.FilteringDependencyVisitor;
import org.sonatype.aether.util.graph.TreeDependencyVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=RepositorySystem.class)
public class DefaultRepositorySystem
implements RepositorySystem,
Service {
    @Requirement
    private Logger logger = NullLogger.INSTANCE;
    @Requirement
    private VersionResolver versionResolver;
    @Requirement
    private VersionRangeResolver versionRangeResolver;
    @Requirement
    private ArtifactResolver artifactResolver;
    @Requirement
    private MetadataResolver metadataResolver;
    @Requirement
    private ArtifactDescriptorReader artifactDescriptorReader;
    @Requirement
    private DependencyCollector dependencyCollector;
    @Requirement
    private Installer installer;
    @Requirement
    private Deployer deployer;
    @Requirement
    private LocalRepositoryProvider localRepositoryProvider;
    @Requirement
    private SyncContextFactory syncContextFactory;

    public DefaultRepositorySystem() {
    }

    public DefaultRepositorySystem(Logger logger, VersionResolver versionResolver, VersionRangeResolver versionRangeResolver, ArtifactResolver artifactResolver, MetadataResolver metadataResolver, ArtifactDescriptorReader artifactDescriptorReader, DependencyCollector dependencyCollector, Installer installer, Deployer deployer, LocalRepositoryProvider localRepositoryProvider, SyncContextFactory syncContextFactory) {
        this.setLogger(logger);
        this.setVersionResolver(versionResolver);
        this.setVersionRangeResolver(versionRangeResolver);
        this.setArtifactResolver(artifactResolver);
        this.setMetadataResolver(metadataResolver);
        this.setArtifactDescriptorReader(artifactDescriptorReader);
        this.setDependencyCollector(dependencyCollector);
        this.setInstaller(installer);
        this.setDeployer(deployer);
        this.setLocalRepositoryProvider(localRepositoryProvider);
        this.setSyncContextFactory(syncContextFactory);
    }

    public void initService(ServiceLocator locator) {
        this.setLogger((Logger)locator.getService(Logger.class));
        this.setVersionResolver((VersionResolver)locator.getService(VersionResolver.class));
        this.setVersionRangeResolver((VersionRangeResolver)locator.getService(VersionRangeResolver.class));
        this.setArtifactResolver((ArtifactResolver)locator.getService(ArtifactResolver.class));
        this.setMetadataResolver((MetadataResolver)locator.getService(MetadataResolver.class));
        this.setArtifactDescriptorReader((ArtifactDescriptorReader)locator.getService(ArtifactDescriptorReader.class));
        this.setDependencyCollector((DependencyCollector)locator.getService(DependencyCollector.class));
        this.setInstaller((Installer)locator.getService(Installer.class));
        this.setDeployer((Deployer)locator.getService(Deployer.class));
        this.setLocalRepositoryProvider((LocalRepositoryProvider)locator.getService(LocalRepositoryProvider.class));
        this.setSyncContextFactory((SyncContextFactory)locator.getService(SyncContextFactory.class));
    }

    public DefaultRepositorySystem setLogger(Logger logger) {
        this.logger = logger != null ? logger : NullLogger.INSTANCE;
        return this;
    }

    public DefaultRepositorySystem setVersionResolver(VersionResolver versionResolver) {
        if (versionResolver == null) {
            throw new IllegalArgumentException("version resolver has not been specified");
        }
        this.versionResolver = versionResolver;
        return this;
    }

    public DefaultRepositorySystem setVersionRangeResolver(VersionRangeResolver versionRangeResolver) {
        if (versionRangeResolver == null) {
            throw new IllegalArgumentException("version range resolver has not been specified");
        }
        this.versionRangeResolver = versionRangeResolver;
        return this;
    }

    public DefaultRepositorySystem setArtifactResolver(ArtifactResolver artifactResolver) {
        if (artifactResolver == null) {
            throw new IllegalArgumentException("artifact resolver has not been specified");
        }
        this.artifactResolver = artifactResolver;
        return this;
    }

    public DefaultRepositorySystem setMetadataResolver(MetadataResolver metadataResolver) {
        if (metadataResolver == null) {
            throw new IllegalArgumentException("metadata resolver has not been specified");
        }
        this.metadataResolver = metadataResolver;
        return this;
    }

    public DefaultRepositorySystem setArtifactDescriptorReader(ArtifactDescriptorReader artifactDescriptorReader) {
        if (artifactDescriptorReader == null) {
            throw new IllegalArgumentException("artifact descriptor reader has not been specified");
        }
        this.artifactDescriptorReader = artifactDescriptorReader;
        return this;
    }

    public DefaultRepositorySystem setDependencyCollector(DependencyCollector dependencyCollector) {
        if (dependencyCollector == null) {
            throw new IllegalArgumentException("dependency collector has not been specified");
        }
        this.dependencyCollector = dependencyCollector;
        return this;
    }

    public DefaultRepositorySystem setInstaller(Installer installer) {
        if (installer == null) {
            throw new IllegalArgumentException("installer has not been specified");
        }
        this.installer = installer;
        return this;
    }

    public DefaultRepositorySystem setDeployer(Deployer deployer) {
        if (deployer == null) {
            throw new IllegalArgumentException("deployer has not been specified");
        }
        this.deployer = deployer;
        return this;
    }

    public DefaultRepositorySystem setLocalRepositoryProvider(LocalRepositoryProvider localRepositoryProvider) {
        if (localRepositoryProvider == null) {
            throw new IllegalArgumentException("local repository provider has not been specified");
        }
        this.localRepositoryProvider = localRepositoryProvider;
        return this;
    }

    public DefaultRepositorySystem setSyncContextFactory(SyncContextFactory syncContextFactory) {
        if (syncContextFactory == null) {
            throw new IllegalArgumentException("sync context factory has not been specified");
        }
        this.syncContextFactory = syncContextFactory;
        return this;
    }

    public VersionResult resolveVersion(RepositorySystemSession session, VersionRequest request) throws VersionResolutionException {
        this.validateSession(session);
        return this.versionResolver.resolveVersion(session, request);
    }

    public VersionRangeResult resolveVersionRange(RepositorySystemSession session, VersionRangeRequest request) throws VersionRangeResolutionException {
        this.validateSession(session);
        return this.versionRangeResolver.resolveVersionRange(session, request);
    }

    public ArtifactDescriptorResult readArtifactDescriptor(RepositorySystemSession session, ArtifactDescriptorRequest request) throws ArtifactDescriptorException {
        this.validateSession(session);
        return this.artifactDescriptorReader.readArtifactDescriptor(session, request);
    }

    public ArtifactResult resolveArtifact(RepositorySystemSession session, ArtifactRequest request) throws ArtifactResolutionException {
        this.validateSession(session);
        return this.artifactResolver.resolveArtifact(session, request);
    }

    public List<ArtifactResult> resolveArtifacts(RepositorySystemSession session, Collection<? extends ArtifactRequest> requests) throws ArtifactResolutionException {
        this.validateSession(session);
        return this.artifactResolver.resolveArtifacts(session, requests);
    }

    public List<MetadataResult> resolveMetadata(RepositorySystemSession session, Collection<? extends MetadataRequest> requests) {
        this.validateSession(session);
        return this.metadataResolver.resolveMetadata(session, requests);
    }

    public CollectResult collectDependencies(RepositorySystemSession session, CollectRequest request) throws DependencyCollectionException {
        this.validateSession(session);
        return this.dependencyCollector.collectDependencies(session, request);
    }

    public DependencyResult resolveDependencies(RepositorySystemSession session, DependencyRequest request) throws DependencyResolutionException {
        List results;
        this.validateSession(session);
        RequestTrace trace = DefaultRequestTrace.newChild((RequestTrace)request.getTrace(), (Object)request);
        DependencyResult result = new DependencyResult(request);
        DependencyCollectionException dce = null;
        ArtifactResolutionException are = null;
        if (request.getRoot() != null) {
            result.setRoot(request.getRoot());
        } else if (request.getCollectRequest() != null) {
            CollectResult collectResult;
            try {
                request.getCollectRequest().setTrace(trace);
                collectResult = this.dependencyCollector.collectDependencies(session, request.getCollectRequest());
            }
            catch (DependencyCollectionException e) {
                dce = e;
                collectResult = e.getResult();
            }
            result.setRoot(collectResult.getRoot());
            result.setCollectExceptions(collectResult.getExceptions());
        } else {
            throw new IllegalArgumentException("dependency node or collect request missing");
        }
        ArtifactRequestBuilder builder = new ArtifactRequestBuilder(trace);
        DependencyFilter filter = request.getFilter();
        ArtifactRequestBuilder visitor = filter != null ? new FilteringDependencyVisitor((DependencyVisitor)builder, filter) : builder;
        visitor = new TreeDependencyVisitor((DependencyVisitor)visitor);
        result.getRoot().accept((DependencyVisitor)visitor);
        List<ArtifactRequest> requests = builder.getRequests();
        try {
            results = this.artifactResolver.resolveArtifacts(session, requests);
        }
        catch (ArtifactResolutionException e) {
            are = e;
            results = e.getResults();
        }
        result.setArtifactResults(results);
        this.updateNodesWithResolvedArtifacts(results);
        if (dce != null) {
            throw new DependencyResolutionException(result, (Throwable)dce);
        }
        if (are != null) {
            throw new DependencyResolutionException(result, (Throwable)are);
        }
        return result;
    }

    public List<ArtifactResult> resolveDependencies(RepositorySystemSession session, DependencyNode node, DependencyFilter filter) throws ArtifactResolutionException {
        this.validateSession(session);
        RequestTrace trace = DefaultRequestTrace.newChild(null, (Object)node);
        ArtifactRequestBuilder builder = new ArtifactRequestBuilder(trace);
        ArtifactRequestBuilder visitor = filter != null ? new FilteringDependencyVisitor((DependencyVisitor)builder, filter) : builder;
        visitor = new TreeDependencyVisitor((DependencyVisitor)visitor);
        node.accept((DependencyVisitor)visitor);
        List<ArtifactRequest> requests = builder.getRequests();
        try {
            List<ArtifactResult> results = this.resolveArtifacts(session, requests);
            this.updateNodesWithResolvedArtifacts(results);
            return results;
        }
        catch (ArtifactResolutionException e) {
            this.updateNodesWithResolvedArtifacts(e.getResults());
            throw e;
        }
    }

    private void updateNodesWithResolvedArtifacts(List<ArtifactResult> results) {
        for (ArtifactResult result : results) {
            Artifact artifact = result.getArtifact();
            if (artifact == null) continue;
            result.getRequest().getDependencyNode().setArtifact(artifact);
        }
    }

    public List<ArtifactResult> resolveDependencies(RepositorySystemSession session, CollectRequest request, DependencyFilter filter) throws DependencyCollectionException, ArtifactResolutionException {
        this.validateSession(session);
        CollectResult result = this.collectDependencies(session, request);
        return this.resolveDependencies(session, result.getRoot(), filter);
    }

    public InstallResult install(RepositorySystemSession session, InstallRequest request) throws InstallationException {
        this.validateSession(session);
        return this.installer.install(session, request);
    }

    public DeployResult deploy(RepositorySystemSession session, DeployRequest request) throws DeploymentException {
        this.validateSession(session);
        return this.deployer.deploy(session, request);
    }

    public LocalRepositoryManager newLocalRepositoryManager(LocalRepository localRepository) {
        try {
            return this.localRepositoryProvider.newLocalRepositoryManager(localRepository);
        }
        catch (NoLocalRepositoryManagerException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public SyncContext newSyncContext(RepositorySystemSession session, boolean shared) {
        this.validateSession(session);
        return this.syncContextFactory.newInstance(session, shared);
    }

    private void validateSession(RepositorySystemSession session) {
        if (session == null) {
            throw new IllegalArgumentException("Invalid repository system session: the session may not be null.");
        }
        if (session.getLocalRepositoryManager() == null) {
            this.invalidSession("LocalRepositoryManager");
        }
        if (session.getSystemProperties() == null) {
            this.invalidSession("SystemProperties");
        }
        if (session.getUserProperties() == null) {
            this.invalidSession("UserProperties");
        }
        if (session.getConfigProperties() == null) {
            this.invalidSession("ConfigProperties");
        }
        if (session.getMirrorSelector() == null) {
            this.invalidSession("MirrorSelector");
        }
        if (session.getProxySelector() == null) {
            this.invalidSession("ProxySelector");
        }
        if (session.getAuthenticationSelector() == null) {
            this.invalidSession("AuthenticationSelector");
        }
        if (session.getArtifactTypeRegistry() == null) {
            this.invalidSession("ArtifactTypeRegistry");
        }
        if (session.getDependencyTraverser() == null) {
            this.invalidSession("DependencyTraverser");
        }
        if (session.getDependencyManager() == null) {
            this.invalidSession("DependencyManager");
        }
        if (session.getDependencySelector() == null) {
            this.invalidSession("DependencySelector");
        }
        if (session.getDependencyGraphTransformer() == null) {
            this.invalidSession("DependencyGraphTransformer");
        }
        if (session.getData() == null) {
            this.invalidSession("Data");
        }
    }

    private void invalidSession(String name) {
        throw new IllegalArgumentException("Invalid repository system session: " + name + " is not set.");
    }
}

