/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.swift.plugins;

import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.language.base.plugins.LifecycleBasePlugin;
import org.gradle.language.nativeplatform.internal.Names;
import org.gradle.language.swift.SwiftBinary;
import org.gradle.language.swift.SwiftExecutable;
import org.gradle.language.swift.SwiftSharedLibrary;
import org.gradle.language.swift.internal.DefaultSwiftBinary;
import org.gradle.language.swift.internal.DefaultSwiftExecutable;
import org.gradle.language.swift.internal.DefaultSwiftSharedLibrary;
import org.gradle.language.swift.tasks.SwiftCompile;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.tasks.InstallExecutable;
import org.gradle.nativeplatform.tasks.LinkExecutable;
import org.gradle.nativeplatform.tasks.LinkSharedLibrary;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainRegistryInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.nativeplatform.toolchain.plugins.SwiftCompilerPlugin;
import org.gradle.platform.base.Platform;
import org.gradle.platform.base.ToolChain;

@Incubating
public class SwiftBasePlugin
implements Plugin<ProjectInternal> {
    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(LifecycleBasePlugin.class);
        project.getPluginManager().apply(SwiftCompilerPlugin.class);
        final TaskContainerInternal tasks = project.getTasks();
        final DirectoryProperty buildDirectory = project.getLayout().getBuildDirectory();
        final ModelRegistry modelRegistry = project.getModelRegistry();
        final ProviderFactory providers = project.getProviders();
        project.getComponents().withType(SwiftBinary.class, (Action)new Action<SwiftBinary>(){

            public void execute(final SwiftBinary binary) {
                final Names names = Names.of(binary.getName());
                SwiftCompile compile = (SwiftCompile)tasks.create(names.getCompileTaskName("swift"), SwiftCompile.class);
                compile.getModules().from(new Object[]{binary.getCompileModules()});
                compile.getSource().from(new Object[]{binary.getSwiftSource()});
                if (binary.isDebuggable()) {
                    compile.setDebuggable(true);
                } else {
                    compile.setOptimized(true);
                }
                if (binary.isTestable()) {
                    compile.getCompilerArgs().add((Object)"-enable-testing");
                }
                compile.getModuleName().set(binary.getModule());
                compile.getObjectFileDir().set(buildDirectory.dir("obj/" + names.getDirName()));
                compile.getModuleFile().set(buildDirectory.file(providers.provider((Callable)new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return "modules/" + names.getDirName() + (String)binary.getModule().get() + ".swiftmodule";
                    }
                })));
                ((DefaultSwiftBinary)binary).getModuleFile().set((Provider)compile.getModuleFile());
                DefaultNativePlatform currentPlatform = new DefaultNativePlatform("current");
                compile.setTargetPlatform((NativePlatform)currentPlatform);
                NativeToolChain toolChain = (NativeToolChain)((NativeToolChainRegistryInternal)modelRegistry.realize("toolChains", NativeToolChainRegistryInternal.class)).getForPlatform((Platform)currentPlatform);
                compile.setToolChain(toolChain);
                ((DefaultSwiftBinary)binary).getObjectsDir().set((Provider)compile.getObjectFileDir());
                if (binary instanceof SwiftExecutable) {
                    LinkExecutable link = (LinkExecutable)tasks.create(names.getTaskName("link"), LinkExecutable.class);
                    link.source((Object)binary.getObjects());
                    link.lib((Object)binary.getLinkLibraries());
                    final PlatformToolProvider toolProvider = ((NativeToolChainInternal)toolChain).select((NativePlatformInternal)currentPlatform);
                    Provider exeLocation = buildDirectory.file(providers.provider((Callable)new Callable<String>(){

                        @Override
                        public String call() {
                            return toolProvider.getExecutableName("exe/" + names.getDirName() + (String)binary.getModule().get());
                        }
                    }));
                    link.setOutputFile(exeLocation);
                    link.setTargetPlatform((NativePlatform)currentPlatform);
                    link.setToolChain(toolChain);
                    link.setDebuggable(binary.isDebuggable());
                    ((DefaultSwiftExecutable)binary).getExecutableFile().set((Provider)link.getBinaryFile());
                    InstallExecutable install = (InstallExecutable)tasks.create(names.getTaskName("install"), InstallExecutable.class);
                    install.setPlatform(link.getTargetPlatform());
                    install.setToolChain((ToolChain)link.getToolChain());
                    install.getInstallDirectory().set(buildDirectory.dir("install/" + names.getDirName()));
                    install.getSourceFile().set((Provider)link.getBinaryFile());
                    install.lib((Object)binary.getRuntimeLibraries());
                    ((DefaultSwiftExecutable)binary).getInstallDirectory().set((Provider)install.getInstallDirectory());
                    ((DefaultSwiftExecutable)binary).getRunScriptFile().set(install.getRunScriptFile());
                } else if (binary instanceof SwiftSharedLibrary) {
                    compile.getCompilerArgs().add((Object)"-parse-as-library");
                    LinkSharedLibrary link = (LinkSharedLibrary)tasks.create(names.getTaskName("link"), LinkSharedLibrary.class);
                    link.source((Object)binary.getObjects());
                    link.lib((Object)binary.getLinkLibraries());
                    final PlatformToolProvider toolProvider = ((NativeToolChainInternal)toolChain).select((NativePlatformInternal)currentPlatform);
                    Provider runtimeFile = buildDirectory.file(providers.provider((Callable)new Callable<String>(){

                        @Override
                        public String call() {
                            return toolProvider.getSharedLibraryName("lib/" + names.getDirName() + (String)binary.getModule().get());
                        }
                    }));
                    link.setOutputFile(runtimeFile);
                    link.setTargetPlatform((NativePlatform)currentPlatform);
                    link.setToolChain(toolChain);
                    link.setDebuggable(binary.isDebuggable());
                    ((DefaultSwiftSharedLibrary)binary).getRuntimeFile().set((Provider)link.getBinaryFile());
                }
            }
        });
    }
}

