/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.changedetection.state.DirContentSnapshot;
import org.gradle.api.internal.changedetection.state.FileContentSnapshot;
import org.gradle.api.internal.changedetection.state.FileSnapshot;
import org.gradle.internal.file.FileType;
import org.gradle.internal.hash.HashCode;

public class DirectoryFileSnapshot
implements FileSnapshot {
    final String path;
    private final RelativePath relativePath;
    private final boolean root;

    public DirectoryFileSnapshot(String path, RelativePath relativePath, boolean root) {
        this.path = path;
        this.relativePath = relativePath;
        this.root = root;
    }

    public String toString() {
        return this.getType() + " " + this.path;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.relativePath.getLastName();
    }

    public boolean isRoot() {
        return this.root;
    }

    public RelativePath getRelativePath() {
        return this.relativePath;
    }

    public FileContentSnapshot getContent() {
        return DirContentSnapshot.getInstance();
    }

    public FileType getType() {
        return FileType.Directory;
    }

    public FileSnapshot withContentHash(HashCode contentHash) {
        throw new UnsupportedOperationException("Cannot change the content of a directory");
    }
}

